/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;
import openllet.core.utils.ATermUtils;
import openllet.shared.tools.Log;

public class UnfoldingRule
extends AbstractTableauRule {
    public static final Logger _logger = Log.getLogger(UnfoldingRule.class);

    public UnfoldingRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.ATOM, AbstractTableauRule.BlockingType.COMPLETE);
    }

    @Override
    public void apply(Individual node) {
        if (!node.canApply(0)) {
            return;
        }
        List<ATermAppl> types = node.getTypes(0);
        int size = types.size();
        for (int j = node._applyNext[0]; j < size; ++j) {
            ATermAppl c = types.get(j);
            if (!OpenlletOptions.MAINTAIN_COMPLETION_QUEUE && node.getDepends((ATerm)c) == null) continue;
            this.applyUnfoldingRule(node, c);
            if (this._strategy.getABox().isClosed()) {
                return;
            }
            size = types.size();
        }
        node._applyNext[0] = size;
    }

    protected void applyUnfoldingRule(Individual node, ATermAppl c) {
        DependencySet ds = node.getDepends((ATerm)c);
        if (!OpenlletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        Iterator<Unfolding> unfoldingList = this._strategy.getTBox().unfold(c);
        while (unfoldingList.hasNext()) {
            Unfolding unfolding = unfoldingList.next();
            ATermAppl unfoldingCondition = unfolding.getCondition();
            DependencySet finalDS = node.getDepends((ATerm)unfoldingCondition);
            if (finalDS == null) continue;
            Set<ATermAppl> unfoldingDS = unfolding.getExplanation();
            finalDS = finalDS.union(ds, this._strategy.getABox().doExplanation());
            finalDS = finalDS.union(unfoldingDS, this._strategy.getABox().doExplanation());
            ATermAppl unfoldedConcept = unfolding.getResult();
            if (_logger.isLoggable(Level.FINE) && !node.hasType((ATerm)unfoldedConcept)) {
                _logger.fine("UNF : " + node + ", " + ATermUtils.toString(c) + " -> " + ATermUtils.toString(unfoldedConcept) + " - " + finalDS);
            }
            this._strategy.addType(node, unfoldedConcept, finalDS);
        }
    }
}

