/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.tbox.TBox;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.taxonomy.DefinitionOrder;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;

public abstract class AbstractDefinitionOrder
implements DefinitionOrder {
    protected KnowledgeBase _kb;
    protected Comparator<ATerm> _comparator;
    private Set<ATermAppl> _cyclicConcepts;
    private List<ATermAppl> _definitionOrder;

    public AbstractDefinitionOrder(KnowledgeBase kb, Comparator<ATerm> comparator) {
        this._kb = kb;
        this._comparator = comparator;
        this._cyclicConcepts = CollectionUtils.makeIdentitySet();
        this._definitionOrder = new ArrayList<ATermAppl>(kb.getClasses().size() + 2);
        this.initialize();
        this.processDefinitions();
        this._cyclicConcepts = this.computeCycles();
        this._definitionOrder = this.computeDefinitionOrder();
    }

    protected abstract void initialize();

    protected abstract Set<ATermAppl> computeCycles();

    protected abstract List<ATermAppl> computeDefinitionOrder();

    protected void processDefinitions() {
        boolean hasInverses = this._kb.getExpressivity().hasInverse();
        TBox tbox = this._kb.getTBox();
        for (ATermAppl c : this._kb.getClasses()) {
            Iterator<Unfolding> unfoldingList = tbox.unfold(c);
            while (unfoldingList.hasNext()) {
                Unfolding unf = unfoldingList.next();
                Set<ATermAppl> usedByC = ATermUtils.findPrimitives(unf.getResult(), !hasInverses, true);
                for (ATermAppl used : usedByC) {
                    if (!this._kb.getClasses().contains(used)) continue;
                    this.addUses(c, used);
                }
            }
        }
    }

    protected abstract void addUses(ATermAppl var1, ATermAppl var2);

    @Override
    public boolean isCyclic(ATermAppl concept) {
        return this._cyclicConcepts.contains(concept);
    }

    @Override
    public Iterator<ATermAppl> iterator() {
        return this._definitionOrder.iterator();
    }

    @Override
    public List<ATermAppl> getList() {
        return this._definitionOrder;
    }
}

