/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import openllet.core.utils.SetUtils;

public class TaxonomyNode<T> {
    private final Map<Object, Object> _dataMap = new ConcurrentHashMap<Object, Object>();
    private final Set<TaxonomyNode<T>> _subs = SetUtils.create(2);
    private final Set<TaxonomyNode<T>> _supers = SetUtils.create();
    private volatile Set<T> _equivalents;
    private volatile boolean _hidden;
    private volatile boolean _checkMark;
    private volatile boolean _seen = false;
    private volatile T _name;
    protected volatile short _depth = 0;

    public TaxonomyNode(T name, boolean hidden) {
        this._name = name;
        this._hidden = hidden;
        this._equivalents = name == null ? Collections.emptySet() : Collections.singleton(name);
    }

    public TaxonomyNode(Collection<T> equivalents, boolean hidden) {
        if (equivalents == null || equivalents.isEmpty()) {
            this._name = null;
            this._equivalents = Collections.emptySet();
        } else {
            this._name = equivalents.iterator().next();
            this._equivalents = SetUtils.create(equivalents);
        }
        this._hidden = hidden;
    }

    public void setMark(boolean b) {
        this._checkMark = b;
        this._seen = true;
    }

    public boolean markIsDefined() {
        return this._seen;
    }

    public boolean getMark() {
        return this._checkMark;
    }

    public void resetMark() {
        this._seen = false;
    }

    public void addEquivalent(T t) {
        if (this._equivalents.size() < 2) {
            this._equivalents = SetUtils.create(this._equivalents);
        }
        this._equivalents.add(t);
    }

    public void addSub(TaxonomyNode<T> other) {
        if (this.equals(other) || this._subs.contains(other)) {
            return;
        }
        this._subs.add(other);
        if (!this._hidden) {
            other._supers.add(this);
        }
    }

    public void addSubs(Collection<TaxonomyNode<T>> others) {
        others.forEach(t -> this.addSub((TaxonomyNode<T>)t));
    }

    public void addSupers(Collection<TaxonomyNode<T>> others) {
        this._supers.addAll(others);
        if (!this._hidden) {
            for (TaxonomyNode<T> other : others) {
                other._subs.add(this);
            }
        }
    }

    public void clearData() {
        this._dataMap.clear();
    }

    public void disconnect() {
        Iterator<TaxonomyNode<T>> j = this._subs.iterator();
        while (j.hasNext()) {
            TaxonomyNode<T> sub = j.next();
            j.remove();
            sub._supers.remove(this);
        }
        j = this._supers.iterator();
        while (j.hasNext()) {
            TaxonomyNode<T> sup = j.next();
            j.remove();
            sup._subs.remove(this);
        }
    }

    public Object getDatum(Object key) {
        return this._dataMap.get(key);
    }

    public Set<T> getEquivalents() {
        return this._equivalents;
    }

    public T getName() {
        return this._name;
    }

    public Collection<TaxonomyNode<T>> getSubs() {
        return this._subs;
    }

    public Collection<TaxonomyNode<T>> getSupers() {
        return this._supers;
    }

    public boolean isBottom() {
        return this._subs.isEmpty();
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public boolean isLeaf() {
        return this._subs.size() == 1 && this._subs.iterator().next().isBottom();
    }

    public boolean isTop() {
        return this._supers.isEmpty();
    }

    public void print() {
        this.print("");
    }

    public void print(String indentLvl) {
        if (this._subs.isEmpty()) {
            return;
        }
        System.out.print(indentLvl);
        Iterator<T> i = this._equivalents.iterator();
        while (i.hasNext()) {
            System.out.print(i.next());
            if (!i.hasNext()) continue;
            System.out.print(" = ");
        }
        System.out.println();
        String indent = indentLvl + "  ";
        for (TaxonomyNode<T> sub : this._subs) {
            sub.print(indent);
        }
    }

    public Object putDatum(Object key, Object value) {
        return this._dataMap.put(key, value);
    }

    public Object removeDatum(Object key) {
        return this._dataMap.remove(key);
    }

    public void removeMultiplePaths() {
        if (!this._hidden) {
            for (TaxonomyNode<T> sup : this._supers) {
                for (TaxonomyNode<T> sub : this._subs) {
                    sup.removeSub(sub);
                }
            }
        }
    }

    public void removeEquivalent(T t) {
        this._equivalents.remove(t);
        if (this._name != null && this._name.equals(t)) {
            this._name = this._equivalents.iterator().next();
        }
    }

    public void removeSub(TaxonomyNode<T> other) {
        this._subs.remove(other);
        other._supers.remove(this);
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public String toString() {
        return this._name.toString();
    }
}

