/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermFactory;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.aterm.pure.PureFactory;
import openllet.atom.OpenError;
import openllet.core.boxes.rbox.Role;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.output.ATermManchesterSyntaxRenderer;
import openllet.core.utils.Bool;
import openllet.core.utils.Comparators;
import openllet.core.utils.QNameProvider;
import openllet.core.utils.SetUtils;
import openllet.core.utils.URIUtils;
import openllet.core.utils.iterator.MultiListIterator;
import openllet.core.utils.iterator.PairIterator;

public class ATermUtils {
    private static final ATermFactory factory = new PureFactory();
    public static final AFun LITFUN = factory.makeAFun("literal", 3, false);
    public static final int LIT_VAL_INDEX = 0;
    public static final int LIT_LANG_INDEX = 1;
    public static final int LIT_URI_INDEX = 2;
    public static final AFun ANDFUN = factory.and();
    public static final AFun ORFUN = factory.or();
    public static final AFun SOMEFUN = factory.some();
    public static final AFun ALLFUN = factory.all();
    public static final AFun NOTFUN = factory.not();
    public static final AFun MAXFUN = factory.max();
    public static final AFun MINFUN = factory.min();
    public static final AFun VALUEFUN = factory.value();
    public static final AFun SELFFUN = factory.self();
    public static final AFun CARDFUN = factory.card();
    public static Set<AFun> CLASS_FUN = SetUtils.create(ALLFUN, SOMEFUN, MAXFUN, MINFUN, CARDFUN, ANDFUN, ORFUN, NOTFUN, VALUEFUN, SELFFUN);
    public static final AFun INVFUN = factory.inv();
    public static final AFun SUBFUN = factory.subClassOf();
    public static final AFun EQCLASSFUN = factory.equivalentClasses();
    public static final AFun SAMEASFUN = factory.sameAs();
    public static final AFun DISJOINTFUN = factory.disjointWith();
    public static final AFun DISJOINTSFUN = factory.disjointClasses();
    public static final AFun DISJOINTPROPFUN = factory.disjointPropertyWith();
    public static final AFun DISJOINTPROPSFUN = factory.disjointProperties();
    public static final AFun COMPLEMENTFUN = factory.complementOf();
    public static final AFun VARFUN = factory.var();
    public static final AFun TYPEFUN = factory.type();
    public static final AFun PROPFUN = factory.prop();
    public static final AFun DIFFERENTFUN = factory.different();
    public static final AFun ALLDIFFERENTFUN = factory.allDifferent();
    public static final AFun ASYMMETRICFUN;
    @Deprecated
    public static final AFun ANTISYMMETRICFUN;
    public static final AFun FUNCTIONALFUN;
    public static final AFun INVFUNCTIONALFUN;
    public static final AFun IRREFLEXIVEFUN;
    public static final AFun REFLEXIVEFUN;
    public static final AFun SYMMETRICFUN;
    public static final AFun TRANSITIVEFUN;
    public static final AFun SUBPROPFUN;
    public static final AFun EQPROPFUN;
    public static final AFun INVPROPFUN;
    public static final AFun DOMAINFUN;
    public static final AFun RANGEFUN;
    public static final AFun RULEFUN;
    public static final AFun BUILTINFUN;
    public static final AFun DATATYPEDEFFUN;
    public static final AFun RESTRDATATYPEFUN;
    public static final AFun FACET;
    public static final ATermAppl EMPTY;
    public static final ATermList EMPTY_LIST;
    public static Set<AFun> AXIOM_FUN;
    public static final ATermAppl TOP;
    public static final ATermAppl BOTTOM;
    public static final ATermAppl TOP_OBJECT_PROPERTY;
    public static final ATermAppl TOP_DATA_PROPERTY;
    public static final ATermAppl BOTTOM_OBJECT_PROPERTY;
    public static final ATermAppl BOTTOM_DATA_PROPERTY;
    public static final ATermAppl TOP_LIT;
    public static final ATermAppl BOTTOM_LIT;
    public static final ATermAppl CONCEPT_SAT_IND;
    public static final ATermInt ONE;
    public static final ATermAppl LITERAL_STRING;
    public static final ATermAppl PLAIN_LITERAL_DATATYPE;
    public static QNameProvider qnames;
    public static ATermAppl NO_DATATYPE;
    public static final AFun BNODE_FUN;
    public static final AFun ANON_FUN;
    public static final AFun ANON_NOMINAL_FUN;
    private static final ATermAppl[] anonCache;

    public static ATermFactory getFactory() {
        return factory;
    }

    public static final ATermAppl makeTypeAtom(ATermAppl ind, ATermAppl c) {
        return factory.makeAppl(TYPEFUN, (ATerm)ind, (ATerm)c);
    }

    public static final ATermAppl makePropAtom(ATermAppl p, ATermAppl s, ATermAppl o) {
        return factory.makeAppl(PROPFUN, (ATerm)p, (ATerm)s, (ATerm)o);
    }

    public static ATermAppl makeStringLiteral(String value) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(value), (ATerm)EMPTY, (ATerm)LITERAL_STRING);
    }

    public static ATermAppl makePlainLiteral(String value) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(value), (ATerm)EMPTY, (ATerm)PLAIN_LITERAL_DATATYPE);
    }

    public static ATermAppl makePlainLiteral(String value, String lang) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(value), (ATerm)ATermUtils.makeTermAppl(lang), (ATerm)PLAIN_LITERAL_DATATYPE);
    }

    public static ATermAppl makeTypedLiteral(String value, ATermAppl dt) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(value), (ATerm)EMPTY, (ATerm)dt);
    }

    public static ATermAppl makeTypedLiteral(String value, String dt) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(value), (ATerm)EMPTY, (ATerm)ATermUtils.makeTermAppl(dt));
    }

    public static ATermAppl makeTypedPlainLangLiteral(String value, String lang) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(value), (ATerm)ATermUtils.makeTermAppl(lang), (ATerm)PLAIN_LITERAL_DATATYPE);
    }

    public static ATermAppl makeLiteral(ATermAppl name) {
        return factory.makeAppl(LITFUN, (ATerm)name, (ATerm)EMPTY, (ATerm)NO_DATATYPE);
    }

    public static String getLiteralValue(ATermAppl literal) {
        return ((ATermAppl)literal.getArgument(0)).getName();
    }

    public static String getLiteralLang(ATermAppl literal) {
        return ((ATermAppl)literal.getArgument(1)).getName();
    }

    public static String getLiteralDatatype(ATermAppl literal) {
        return ((ATermAppl)literal.getArgument(2)).getName();
    }

    public static ATermAppl makeTermAppl(String name) {
        return factory.makeAppl(factory.makeAFun(name, 0, false));
    }

    public static ATermAppl makeTermAppl(AFun fun, ATerm[] args) {
        return factory.makeAppl(fun, args);
    }

    public static ATermAppl makeNot(ATerm c) {
        return factory.makeAppl(NOTFUN, c);
    }

    public static ATerm term(String str) {
        return factory.parse(str);
    }

    public static ATermList negate(ATermList list) {
        if (list.isEmpty()) {
            return list;
        }
        ATermAppl a = (ATermAppl)list.getFirst();
        a = ATermUtils.isNot(a) ? (ATermAppl)a.getArgument(0) : ATermUtils.makeNot((ATerm)a);
        ATermList result = ATermUtils.makeList((ATerm)a, ATermUtils.negate(list.getNext()));
        return result;
    }

    public static final ATermAppl negate(ATermAppl a) {
        return ATermUtils.isNot(a) ? (ATermAppl)a.getArgument(0) : ATermUtils.makeNot((ATerm)a);
    }

    public static final boolean isAnonNominal(ATermAppl term) {
        return term.getAFun().equals(ANON_NOMINAL_FUN);
    }

    public static final ATermAppl makeAnonNominal(int id) {
        return factory.makeAppl(ANON_NOMINAL_FUN, (ATerm)factory.makeInt(id));
    }

    public static final ATermAppl makeAnon(int id) {
        if (id < anonCache.length) {
            return anonCache[id];
        }
        return factory.makeAppl(ANON_FUN, (ATerm)factory.makeInt(id));
    }

    public static final ATermAppl makeBnode(String id) {
        return factory.makeAppl(BNODE_FUN, (ATerm)ATermUtils.makeTermAppl(id));
    }

    public static final ATermAppl makeVar(String name) {
        return factory.makeAppl(VARFUN, (ATerm)ATermUtils.makeTermAppl(name));
    }

    public static final ATermAppl makeVar(ATermAppl name) {
        return factory.makeAppl(VARFUN, (ATerm)name);
    }

    public static final ATermAppl makeValue(ATerm c) {
        return factory.makeAppl(VALUEFUN, c);
    }

    public static final ATermAppl makeInv(ATermAppl r) {
        if (ATermUtils.isInv(r)) {
            return (ATermAppl)r.getArgument(0);
        }
        return factory.makeAppl(INVFUN, (ATerm)r);
    }

    public static final ATermAppl makeInvProp(ATerm r, ATerm s) {
        return factory.makeAppl(INVPROPFUN, r, s);
    }

    public static final ATermAppl makeSub(ATerm a, ATerm b) {
        return factory.makeAppl(SUBFUN, a, b);
    }

    public static final ATermAppl makeEqClasses(ATerm a, ATerm b) {
        return factory.makeAppl(EQCLASSFUN, a, b);
    }

    public static final ATermAppl makeSameAs(ATerm a, ATerm b) {
        return factory.makeAppl(SAMEASFUN, a, b);
    }

    public static final ATermAppl makeSubProp(ATerm r, ATerm s) {
        return factory.makeAppl(SUBPROPFUN, r, s);
    }

    public static final ATermAppl makeEqProp(ATerm r, ATerm s) {
        return factory.makeAppl(EQPROPFUN, r, s);
    }

    public static final ATermAppl makeDomain(ATerm r, ATerm c) {
        return factory.makeAppl(DOMAINFUN, r, c);
    }

    public static final ATermAppl makeRange(ATerm r, ATerm c) {
        return factory.makeAppl(RANGEFUN, r, c);
    }

    public static final ATermAppl makeComplement(ATerm a, ATerm b) {
        return factory.makeAppl(COMPLEMENTFUN, a, b);
    }

    public static final ATermAppl makeDisjoint(ATerm a, ATerm b) {
        return factory.makeAppl(DISJOINTFUN, a, b);
    }

    public static final ATermAppl makeDisjoints(ATermList list) {
        return factory.makeAppl(DISJOINTSFUN, (ATerm)list);
    }

    public static final ATermAppl makeDisjointProperty(ATerm a, ATerm b) {
        return factory.makeAppl(DISJOINTPROPFUN, a, b);
    }

    public static final ATermAppl makeDisjointProperties(ATermList list) {
        return factory.makeAppl(DISJOINTPROPSFUN, (ATerm)list);
    }

    public static final ATermAppl makeDifferent(ATerm a, ATerm b) {
        return factory.makeAppl(DIFFERENTFUN, a, b);
    }

    public static final ATermAppl makeAllDifferent(ATermList list) {
        return factory.makeAppl(ALLDIFFERENTFUN, (ATerm)list);
    }

    public static final ATermAppl makeAsymmetric(ATerm r) {
        return factory.makeAppl(ASYMMETRICFUN, r);
    }

    @Deprecated
    public static final ATermAppl makeAntisymmetric(ATerm r) {
        return ATermUtils.makeAsymmetric(r);
    }

    public static final ATermAppl makeFunctional(ATerm a) {
        return factory.makeAppl(FUNCTIONALFUN, a);
    }

    public static final ATermAppl makeInverseFunctional(ATerm a) {
        return factory.makeAppl(INVFUNCTIONALFUN, a);
    }

    public static final ATermAppl makeIrreflexive(ATerm r) {
        return factory.makeAppl(IRREFLEXIVEFUN, r);
    }

    public static final ATermAppl makeReflexive(ATerm r) {
        return factory.makeAppl(REFLEXIVEFUN, r);
    }

    public static final ATermAppl makeSymmetric(ATerm r) {
        return factory.makeAppl(SYMMETRICFUN, r);
    }

    public static final ATermAppl makeTransitive(ATerm r) {
        return factory.makeAppl(TRANSITIVEFUN, r);
    }

    public static final ATermAppl makeAnd(ATerm c1, ATerm c2) {
        return ATermUtils.makeAnd(ATermUtils.makeList(c2).insert(c1));
    }

    public static ATermAppl makeAnd(ATermList list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            return TOP;
        }
        if (list.getNext().isEmpty()) {
            return (ATermAppl)list.getFirst();
        }
        return factory.makeAppl(ANDFUN, (ATerm)list);
    }

    public static final ATermAppl makeOr(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeOr(ATermUtils.makeList((ATerm)c2).insert((ATerm)c1));
    }

    public static ATermAppl makeOr(ATermList list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            return BOTTOM;
        }
        if (list.getNext().isEmpty()) {
            return (ATermAppl)list.getFirst();
        }
        return factory.makeAppl(ORFUN, (ATerm)list);
    }

    public static final ATermAppl makeAllValues(ATerm r, ATerm c) {
        ATermList list;
        ATerm arg1 = r.getType() == 4 ? ((list = (ATermList)r).getLength() == 1 ? (ATerm)list.getFirst() : r) : r;
        return factory.makeAppl(ALLFUN, arg1, c);
    }

    public static final ATermAppl makeSomeValues(ATerm r, ATerm c) {
        ATermUtils.assertTrue(c instanceof ATermAppl);
        return factory.makeAppl(SOMEFUN, r, c);
    }

    public static final ATermAppl makeSelf(ATermAppl r) {
        return factory.makeAppl(SELFFUN, (ATerm)r);
    }

    public static final ATermAppl makeHasValue(ATerm r, ATerm ind) {
        ATermAppl c = ATermUtils.makeValue(ind);
        return factory.makeAppl(SOMEFUN, r, (ATerm)c);
    }

    public static final ATermAppl makeNormalizedMax(ATermAppl r, int n, ATermAppl c) {
        ATermUtils.assertTrue(n >= 0);
        return ATermUtils.makeNot((ATerm)ATermUtils.makeMin((ATerm)r, n + 1, (ATerm)c));
    }

    public static final ATermAppl makeMax(ATerm r, int n, ATerm c) {
        return ATermUtils.makeMax(r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeMax(ATerm r, ATermInt n, ATerm c) {
        ATermUtils.assertTrue(n.getInt() >= 0);
        return factory.makeAppl(MAXFUN, r, (ATerm)n, c);
    }

    public static final ATermAppl makeMin(ATerm r, int n, ATerm c) {
        return ATermUtils.makeMin(r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeMin(ATerm r, ATermInt n, ATerm c) {
        ATermUtils.assertTrue(n.getInt() >= 0);
        return factory.makeAppl(MINFUN, r, (ATerm)n, c);
    }

    public static final ATermAppl makeDisplayCard(ATerm r, int n, ATerm c) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(CARDFUN, r, (ATerm)factory.makeInt(n), c);
    }

    public static final ATermAppl makeDisplayMax(ATerm r, int n, ATerm c) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(MAXFUN, r, (ATerm)factory.makeInt(n), c);
    }

    public static final ATermAppl makeDisplayMin(ATerm r, int n, ATerm c) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(MINFUN, r, (ATerm)factory.makeInt(n), c);
    }

    public static final ATermAppl makeCard(ATerm r, int n, ATerm c) {
        return ATermUtils.makeDisplayCard(r, n, c);
    }

    public static final ATermAppl makeExactCard(ATerm r, int n, ATerm c) {
        return ATermUtils.makeExactCard(r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeExactCard(ATerm r, ATermInt n, ATerm c) {
        ATermAppl max = ATermUtils.makeMax(r, n, c);
        if (n.getInt() == 0) {
            return max;
        }
        ATermAppl min = ATermUtils.makeMin(r, n, c);
        return ATermUtils.makeAnd((ATerm)min, (ATerm)max);
    }

    public static final ATermAppl makeFacetRestriction(ATermAppl facetName, ATermAppl facetValue) {
        return factory.makeAppl(FACET, (ATerm)facetName, (ATerm)facetValue);
    }

    public static final ATermAppl makeRestrictedDatatype(ATermAppl baseDatatype, ATermAppl[] restrictions) {
        return factory.makeAppl(RESTRDATATYPEFUN, (ATerm)baseDatatype, (ATerm)ATermUtils.makeList((ATerm[])restrictions));
    }

    public static final ATermAppl makeDatatypeDefinition(ATermAppl datatype, ATermAppl definition) {
        return factory.makeAppl(DATATYPEDEFFUN, (ATerm)datatype, (ATerm)definition);
    }

    public static final boolean isRestrictedDatatype(ATermAppl term) {
        return term.getAFun().equals(RESTRDATATYPEFUN);
    }

    public static final ATermList makeList(ATerm singleton) {
        return factory.makeList(singleton, EMPTY_LIST);
    }

    public static final ATermList makeList(ATerm first, ATermList rest) {
        return factory.makeList(first, rest);
    }

    public static ATermList makeList(Collection<ATermAppl> set) {
        ATermList list = EMPTY_LIST;
        for (ATerm aTerm : set) {
            list = list.insert(aTerm);
        }
        return list;
    }

    public static final ATermList makeList(ATerm[] aTerms) {
        return ATermUtils.makeList(aTerms, 0);
    }

    private static ATermList makeList(ATerm[] aTerms, int index) {
        if (index >= aTerms.length) {
            return EMPTY_LIST;
        }
        if (index == aTerms.length - 1) {
            return ATermUtils.makeList(aTerms[index]);
        }
        return ATermUtils.makeList(aTerms[index], ATermUtils.makeList(aTerms, index + 1));
    }

    public static final boolean member(ATerm a, ATermList list) {
        return list.indexOf((Object)a, 0) != -1;
    }

    public static boolean isSet(ATermList list) {
        if (list.isEmpty()) {
            return true;
        }
        ATerm curr = (ATerm)list.getFirst();
        for (ATerm term : list) {
            if (Comparators.termComparator.compare(curr, term) >= 0) {
                return false;
            }
            curr = term;
        }
        return true;
    }

    public static ATermList toSet(ATermList list) {
        if (ATermUtils.isSet(list)) {
            return list;
        }
        int size = list.getLength();
        ATermAppl[] a = ATermUtils.toArray(list);
        if (a == null || a.length < size) {
            a = new ATerm[Math.max(100, size)];
        }
        Arrays.sort(a, 0, size, Comparators.termComparator);
        ATermList set = ATermUtils.makeList((ATerm)a[size - 1]);
        for (int i = size - 2; i >= 0; --i) {
            ATerm s = (ATerm)set.getFirst();
            if (s.equals((Object)a[i])) continue;
            set = set.insert((ATerm)a[i]);
        }
        return set;
    }

    public static ATermList toSet(ATerm[] a, int size) {
        Arrays.sort(a, 0, size, Comparators.termComparator);
        ATermList set = ATermUtils.makeList(a[size - 1]);
        for (int i = size - 2; i >= 0; --i) {
            ATerm s = (ATerm)set.getFirst();
            if (s.equals((Object)a[i])) continue;
            set = set.insert(a[i]);
        }
        return set;
    }

    public static ATermList toSet(Collection<ATermAppl> terms) {
        int size = terms.size();
        ATermAppl[] a = new ATermAppl[size];
        terms.toArray(a);
        return ATermUtils.toSet((ATerm[])a, size);
    }

    public static String toString(Collection<ATermAppl> terms) {
        if (terms.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<ATermAppl> i = terms.iterator();
        sb.append(ATermUtils.toString(i.next()));
        while (i.hasNext()) {
            sb.append(", ");
            sb.append(ATermUtils.toString(i.next()));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(ATermAppl term) {
        return ATermUtils.toString(term, true, true);
    }

    public static String toString(ATermAppl term, boolean printLocalName, boolean printNNF) {
        if (term == null) {
            return "<null>";
        }
        StringBuilder sb = new StringBuilder();
        ATermUtils.toString(term, sb, printNNF ? Bool.FALSE : Bool.UNKNOWN, printLocalName);
        return sb.toString();
    }

    private static void toString(ATermAppl term, StringBuilder sb, Bool negated, boolean printLocalName) {
        if (TOP.equals(term)) {
            sb.append(negated.isTrue() ? "owl:Nothing" : "owl:Thing");
        } else if (BOTTOM.equals(term)) {
            sb.append(negated.isTrue() ? "owl:Thing" : "owl:Nothing");
        } else if (ATermUtils.isVar(term)) {
            String name = ((ATermAppl)term.getArgument(0)).getName();
            if (printLocalName) {
                name = URIUtils.getLocalName(name);
            }
            sb.append("?").append(name);
        } else if (ATermUtils.isLiteral(term)) {
            String value = ((ATermAppl)term.getArgument(0)).toString();
            String lang = ((ATermAppl)term.getArgument(1)).getName();
            ATermAppl datatypeURI = (ATermAppl)term.getArgument(2);
            sb.append('\"').append(value).append('\"');
            if (!"".equals(lang)) {
                sb.append('@').append(lang);
            } else if (!datatypeURI.equals(NO_DATATYPE) && !datatypeURI.equals(PLAIN_LITERAL_DATATYPE)) {
                sb.append("^^");
                ATermUtils.toString(datatypeURI, sb, Bool.FALSE, printLocalName);
            }
        } else if (ATermUtils.isPrimitive(term)) {
            if (negated.isTrue()) {
                sb.append("not(");
            }
            String name = term.getName();
            sb.append(URIUtils.getLocalName(name));
            if (negated.isTrue()) {
                sb.append(")");
            }
        } else if (ATermUtils.isRestrictedDatatype(term)) {
            if (negated.isTrue()) {
                sb.append("not(");
            }
            ATermUtils.toString((ATermAppl)term.getArgument(0), sb, Bool.FALSE, printLocalName);
            sb.append("[");
            ATermList list = (ATermList)term.getArgument(1);
            while (!list.isEmpty()) {
                ATermAppl facet = (ATermAppl)list.getFirst();
                sb.append(ATermManchesterSyntaxRenderer.FACETS.get(facet.getArgument(0)));
                sb.append(" ");
                ATermUtils.toString((ATermAppl)facet.getArgument(1), sb, Bool.FALSE, printLocalName);
                if ((list = list.getNext()).isEmpty()) continue;
                sb.append(", ");
            }
            sb.append("]");
            if (negated.isTrue()) {
                sb.append(")");
            }
        } else if (negated.isKnown() && ATermUtils.isNot(term)) {
            ATermUtils.toString((ATermAppl)term.getArgument(0), sb, negated.not(), printLocalName);
        } else {
            AFun fun = term.getAFun();
            if (negated.isTrue()) {
                if (ANDFUN.equals(fun)) {
                    sb.append(ORFUN.getName());
                } else if (ORFUN.equals(fun)) {
                    sb.append(ANDFUN.getName());
                } else if (SOMEFUN.equals(fun)) {
                    sb.append(ALLFUN.getName());
                } else if (ALLFUN.equals(fun)) {
                    sb.append(SOMEFUN.getName());
                } else if (MINFUN.equals(fun)) {
                    sb.append(MAXFUN.getName());
                } else if (MAXFUN.equals(fun)) {
                    sb.append(MINFUN.getName());
                } else if (!NOTFUN.equals(fun)) {
                    if (VALUEFUN.equals(fun) || RESTRDATATYPEFUN.equals(fun)) {
                        sb.append("not(");
                    }
                    sb.append(fun.getName());
                }
            } else {
                sb.append(fun.getName());
            }
            Bool negatedRecurse = negated;
            if (negated.isKnown() && MINFUN.equals(fun) || MAXFUN.equals(fun)) {
                negatedRecurse = Bool.FALSE;
            } else if (NOTFUN.equals(fun)) {
                negatedRecurse = negated.not();
            }
            sb.append("(");
            int n = term.getArity();
            for (int i = 0; i < n; ++i) {
                ATerm arg;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((arg = term.getArgument(i)) instanceof ATermAppl) {
                    ATermUtils.toString((ATermAppl)arg, sb, i > 0 ? negatedRecurse : Bool.FALSE, printLocalName);
                    continue;
                }
                if (arg instanceof ATermList) {
                    sb.append("[");
                    ATermList list = (ATermList)arg;
                    while (!list.isEmpty()) {
                        ATermUtils.toString((ATermAppl)list.getFirst(), sb, negatedRecurse, printLocalName);
                        if ((list = list.getNext()).isEmpty()) continue;
                        sb.append(", ");
                    }
                    sb.append("]");
                    continue;
                }
                int value = ((ATermInt)arg).getInt();
                if (negated.isTrue()) {
                    if (MINFUN.equals(fun)) {
                        --value;
                    } else if (MAXFUN.equals(fun)) {
                        ++value;
                    }
                }
                sb.append(value);
            }
            sb.append(")");
            if ((VALUEFUN.equals(fun) || RESTRDATATYPEFUN.equals(fun)) && negated.isTrue()) {
                sb.append(")");
            }
        }
    }

    public static ATermAppl[] toArray(ATermList list) {
        ATermAppl[] a = new ATermAppl[list.getLength()];
        int i = 0;
        for (ATerm term : list) {
            a[i] = (ATermAppl)term;
            ++i;
        }
        return a;
    }

    public static final void assertTrue(boolean condition) {
        if (!condition) {
            throw new OpenError("assertion failed.");
        }
    }

    public static final boolean isPrimitive(ATermAppl c) {
        return c.getArity() == 0;
    }

    public static final boolean isNegatedPrimitive(ATermAppl c) {
        return ATermUtils.isNot(c) && ATermUtils.isPrimitive((ATermAppl)c.getArgument(0));
    }

    public static final boolean isPrimitiveOrNegated(ATermAppl c) {
        return ATermUtils.isPrimitive(c) || ATermUtils.isNegatedPrimitive(c);
    }

    public static final boolean isBnode(ATermAppl name) {
        return BNODE_FUN.equals(name.getAFun());
    }

    public static final boolean isAnon(ATermAppl term) {
        return ANON_FUN.equals(term.getAFun());
    }

    public static final boolean isBuiltinProperty(ATermAppl name) {
        return TOP_OBJECT_PROPERTY.equals(name) || BOTTOM_OBJECT_PROPERTY.equals(name) || ATermUtils.makeInv(TOP_OBJECT_PROPERTY).equals(name) || ATermUtils.makeInv(BOTTOM_OBJECT_PROPERTY).equals(name) || TOP_DATA_PROPERTY.equals(name) || BOTTOM_DATA_PROPERTY.equals(name);
    }

    public static Set<ATermAppl> listToSet(ATermList list) {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (ATerm term : list) {
            set.add((ATermAppl)term);
        }
        return set;
    }

    public static Set<ATermAppl> getPrimitives(ATermList list) {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (ATerm term : list) {
            ATermAppl appl = (ATermAppl)term;
            if (!ATermUtils.isPrimitive(appl)) continue;
            set.add(appl);
        }
        return set;
    }

    public static final ATermAppl getTop(Role r) {
        return r.isDatatypeRole() ? TOP_LIT : TOP;
    }

    public static final boolean isTop(ATermAppl a) {
        return TOP.equals(a) || TOP_LIT.equals(a);
    }

    public static final boolean isBottom(ATermAppl a) {
        return BOTTOM.equals(a) || BOTTOM_LIT.equals(a);
    }

    public static final boolean isInv(ATermAppl r) {
        return INVFUN.equals(r.getAFun());
    }

    public static final boolean isAnd(ATermAppl a) {
        return ANDFUN.equals(a.getAFun());
    }

    public static final boolean isOr(ATermAppl a) {
        return ORFUN.equals(a.getAFun());
    }

    public static final boolean isAllValues(ATermAppl a) {
        return ALLFUN.equals(a.getAFun());
    }

    public static final boolean isSomeValues(ATermAppl a) {
        return SOMEFUN.equals(a.getAFun());
    }

    public static final boolean isSelf(ATermAppl a) {
        return SELFFUN.equals(a.getAFun());
    }

    public static final boolean isHasValue(ATermAppl a) {
        return SOMEFUN.equals(a.getAFun()) && VALUEFUN.equals(((ATermAppl)a.getArgument(1)).getAFun());
    }

    public static final boolean isNominal(ATermAppl a) {
        return VALUEFUN.equals(a.getAFun());
    }

    public static final boolean isOneOf(ATermAppl a) {
        if (!ORFUN.equals(a.getAFun())) {
            return false;
        }
        ATermList list = (ATermList)a.getArgument(0);
        while (!list.isEmpty()) {
            if (!ATermUtils.isNominal((ATermAppl)list.getFirst())) {
                return false;
            }
            list = list.getNext();
        }
        return true;
    }

    public static final boolean isDataRange(ATermAppl a) {
        if (!ORFUN.equals(a.getAFun())) {
            return false;
        }
        ATermList list = (ATermList)a.getArgument(0);
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            if (!ATermUtils.isNominal(term) || !ATermUtils.isLiteral((ATermAppl)term.getArgument(0))) {
                return false;
            }
            list = list.getNext();
        }
        return true;
    }

    public static final boolean isNot(ATermAppl a) {
        return NOTFUN.equals(a.getAFun());
    }

    public static final boolean isMax(ATermAppl a) {
        return MAXFUN.equals(a.getAFun());
    }

    public static final boolean isMin(ATermAppl a) {
        return MINFUN.equals(a.getAFun());
    }

    public static final boolean isCard(ATermAppl a) {
        if (ATermUtils.isMin(a) || ATermUtils.isMax(a)) {
            return true;
        }
        if (ATermUtils.isAnd(a)) {
            ATermAppl arg0 = (ATermAppl)a.getArgument(0);
            return ATermUtils.isMin(arg0) || ATermUtils.isMax(arg0);
        }
        return false;
    }

    public static final boolean isLiteral(ATermAppl a) {
        return LITFUN.equals(a.getAFun());
    }

    public static final boolean isVar(ATermAppl a) {
        return VARFUN.equals(a.getAFun());
    }

    public static final boolean isTransitiveChain(ATermList chain, ATerm r) {
        return chain.getLength() == 2 && ((ATerm)chain.getFirst()).equals((Object)r) && ((ATerm)chain.getLast()).equals((Object)r);
    }

    public static boolean isComplexClass(ATerm c) {
        if (c instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)c;
            AFun f = a.getAFun();
            return CLASS_FUN.contains(f);
        }
        return false;
    }

    public static final boolean isPropertyAssertion(ATermAppl a) {
        return PROPFUN.equals(a.getAFun());
    }

    public static final boolean isTypeAssertion(ATermAppl a) {
        return TYPEFUN.equals(a.getAFun());
    }

    public static ATerm nnf(ATerm term) {
        if (term instanceof ATermList) {
            return ATermUtils.nnf((ATermList)term);
        }
        if (term instanceof ATermAppl) {
            return ATermUtils.nnf((ATermAppl)term);
        }
        return null;
    }

    public static ATermList nnf(ATermList list) {
        ATermList newList = factory.makeList();
        for (ATerm term : list) {
            newList = newList.append((ATerm)ATermUtils.nnf((ATermAppl)term));
        }
        return newList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ATermAppl nnf(ATermAppl term) {
        ATermAppl newterm = null;
        AFun af = term.getAFun();
        if (af.equals(NOTFUN)) {
            ATermUtils.assertTrue(af.getArity() == 1);
            ATermAppl arg = (ATermAppl)term.getArgument(0);
            af = arg.getAFun();
            if (arg.getArity() == 0) {
                newterm = term;
            } else if (NOTFUN.equals(af)) {
                newterm = ATermUtils.nnf((ATermAppl)arg.getArgument(0));
            } else if (VALUEFUN.equals(af) || SELFFUN.equals(af) || RESTRDATATYPEFUN.equals(af)) {
                newterm = term;
            } else if (MAXFUN.equals(af)) {
                ATermInt n = (ATermInt)arg.getArgument(1);
                newterm = ATermUtils.makeMin(arg.getArgument(0), n.getInt() + 1, ATermUtils.nnf(arg.getArgument(2)));
            } else if (MINFUN.equals(af)) {
                ATermInt n = (ATermInt)arg.getArgument(1);
                newterm = n.getInt() == 0 ? BOTTOM : ATermUtils.makeMax(arg.getArgument(0), n.getInt() - 1, ATermUtils.nnf(arg.getArgument(2)));
            } else if (CARDFUN.equals(af)) {
                newterm = ATermUtils.nnf(ATermUtils.makeNot((ATerm)ATermUtils.makeExactCard(arg.getArgument(0), (ATermInt)arg.getArgument(1), arg.getArgument(2))));
            } else if (ANDFUN.equals(af)) {
                newterm = ATermUtils.makeOr(ATermUtils.nnf(ATermUtils.negate((ATermList)arg.getArgument(0))));
            } else if (ORFUN.equals(af)) {
                newterm = ATermUtils.makeAnd(ATermUtils.nnf(ATermUtils.negate((ATermList)arg.getArgument(0))));
            } else if (SOMEFUN.equals(af)) {
                ATerm p = arg.getArgument(0);
                ATerm c = arg.getArgument(1);
                newterm = ATermUtils.makeAllValues(p, (ATerm)ATermUtils.nnf(ATermUtils.makeNot(c)));
            } else {
                if (!ALLFUN.equals(af)) throw new InternalReasonerException("Unknown term type: " + term);
                ATerm p = arg.getArgument(0);
                ATerm c = arg.getArgument(1);
                newterm = ATermUtils.makeSomeValues(p, (ATerm)ATermUtils.nnf(ATermUtils.makeNot(c)));
            }
        } else if (MINFUN.equals(af) || MAXFUN.equals(af) || SELFFUN.equals(af)) {
            newterm = term;
        } else if (CARDFUN.equals(af)) {
            newterm = ATermUtils.nnf(ATermUtils.makeExactCard(term.getArgument(0), (ATermInt)term.getArgument(1), term.getArgument(2)));
        } else {
            ATerm[] args = new ATerm[term.getArity()];
            for (int i = 0; i < term.getArity(); ++i) {
                args[i] = ATermUtils.nnf(term.getArgument(i));
            }
            newterm = factory.makeAppl(af, args);
        }
        ATermUtils.assertTrue(newterm != null);
        return newterm;
    }

    public static Collection<ATermAppl> normalize(Collection<ATermAppl> terms) {
        ArrayList<ATermAppl> list = new ArrayList<ATermAppl>();
        for (ATermAppl term : terms) {
            list.add(ATermUtils.normalize(term));
        }
        return list;
    }

    public static ATermList normalize(ATermList list) {
        int size = list.getLength();
        ATerm[] terms = new ATerm[size];
        int i = 0;
        for (ATerm term : list) {
            terms[i] = ATermUtils.normalize((ATermAppl)term);
            ++i;
        }
        return ATermUtils.toSet(terms, size);
    }

    public static ATermAppl normalize(ATermAppl term) {
        ATerm arg3;
        ATermAppl norm = term;
        AFun fun = term.getAFun();
        ATerm arg1 = term.getArity() > 0 ? term.getArgument(0) : null;
        ATerm arg2 = term.getArity() > 1 ? term.getArgument(1) : null;
        ATerm aTerm = arg3 = term.getArity() > 2 ? term.getArgument(2) : null;
        if (!(arg1 == null || SELFFUN.equals(fun) || VALUEFUN.equals(fun) || INVFUN.equals(fun) || RESTRDATATYPEFUN.equals(fun))) {
            if (NOTFUN.equals(fun)) {
                if (!ATermUtils.isPrimitive((ATermAppl)arg1)) {
                    norm = ATermUtils.simplify(ATermUtils.makeNot((ATerm)ATermUtils.normalize((ATermAppl)arg1)));
                }
            } else if (ANDFUN.equals(fun)) {
                norm = ATermUtils.simplify(ATermUtils.makeAnd(ATermUtils.normalize((ATermList)arg1)));
            } else if (ORFUN.equals(fun)) {
                ATermList neg = ATermUtils.negate((ATermList)arg1);
                ATermAppl and = ATermUtils.makeAnd(neg);
                ATermAppl notAnd = ATermUtils.makeNot((ATerm)and);
                norm = ATermUtils.normalize(notAnd);
            } else if (ALLFUN.equals(fun)) {
                norm = ATermUtils.simplify(ATermUtils.makeAllValues(arg1, (ATerm)ATermUtils.normalize((ATermAppl)arg2)));
            } else if (SOMEFUN.equals(fun)) {
                norm = ATermUtils.normalize(ATermUtils.makeNot((ATerm)ATermUtils.makeAllValues(arg1, (ATerm)ATermUtils.makeNot(arg2))));
            } else if (MAXFUN.equals(fun) && arg2 != null) {
                norm = ATermUtils.normalize(ATermUtils.makeNot((ATerm)ATermUtils.makeMin(arg1, ((ATermInt)arg2).getInt() + 1, arg3)));
            } else if (MINFUN.equals(fun)) {
                norm = ATermUtils.simplify(ATermUtils.makeMin(arg1, (ATermInt)arg2, (ATerm)ATermUtils.normalize((ATermAppl)arg3)));
            } else if (CARDFUN.equals(fun) && arg2 != null) {
                ATermAppl normMin = ATermUtils.simplify(ATermUtils.makeMin(arg1, ((ATermInt)arg2).getInt(), (ATerm)ATermUtils.normalize((ATermAppl)arg3)));
                ATermAppl normMax = ATermUtils.normalize(ATermUtils.makeMax(arg1, ((ATermInt)arg2).getInt(), arg3));
                norm = ATermUtils.simplify(ATermUtils.makeAnd((ATerm)normMin, (ATerm)normMax));
            } else {
                throw new InternalReasonerException("Unknown concept type: " + term);
            }
        }
        return norm;
    }

    public static ATermAppl simplify(ATermAppl term) {
        ATerm arg3;
        ATermAppl simp = term;
        AFun fun = term.getAFun();
        ATerm arg1 = term.getArity() > 0 ? term.getArgument(0) : null;
        ATerm arg2 = term.getArity() > 1 ? term.getArgument(1) : null;
        ATerm aTerm = arg3 = term.getArity() > 2 ? term.getArgument(2) : null;
        if (!(arg1 == null || SELFFUN.equals(fun) || VALUEFUN.equals(fun) || RESTRDATATYPEFUN.equals(fun))) {
            if (NOTFUN.equals(fun)) {
                ATermInt n;
                ATermAppl arg = (ATermAppl)arg1;
                if (ATermUtils.isNot(arg)) {
                    simp = ATermUtils.simplify((ATermAppl)arg.getArgument(0));
                } else if (ATermUtils.isMin(arg) && (n = (ATermInt)arg.getArgument(1)).getInt() == 0) {
                    simp = BOTTOM;
                }
            } else if (ANDFUN.equals(fun)) {
                ATermList conjuncts = (ATermList)arg1;
                if (conjuncts.isEmpty()) {
                    simp = TOP;
                } else {
                    HashSet<Object> set = new HashSet<Object>();
                    ArrayList<Object> negations = new ArrayList<Object>();
                    MultiListIterator i = new MultiListIterator(conjuncts);
                    while (i.hasNext()) {
                        ATermAppl c = i.next();
                        if (TOP.equals(c)) continue;
                        if (BOTTOM.equals(c)) {
                            return BOTTOM;
                        }
                        if (ATermUtils.isAnd(c)) {
                            i.append((ATermList)c.getArgument(0));
                            continue;
                        }
                        if (ATermUtils.isNot(c)) {
                            negations.add(c);
                            continue;
                        }
                        set.add(c);
                    }
                    for (ATermAppl aTermAppl : negations) {
                        ATermAppl c = (ATermAppl)aTermAppl.getArgument(0);
                        if (!set.contains(c)) continue;
                        return BOTTOM;
                    }
                    if (set.isEmpty()) {
                        if (negations.isEmpty()) {
                            return TOP;
                        }
                        if (negations.size() == 1) {
                            return (ATermAppl)negations.get(0);
                        }
                    } else if (set.size() == 1 && negations.isEmpty()) {
                        return (ATermAppl)set.iterator().next();
                    }
                    negations.addAll(set);
                    int size = negations.size();
                    ATermAppl[] aTermApplArray = new ATermAppl[size];
                    negations.toArray(aTermApplArray);
                    simp = ATermUtils.makeAnd(ATermUtils.toSet((ATerm[])aTermApplArray, size));
                }
            } else if (ALLFUN.equals(fun)) {
                if (arg2 != null && arg2.equals((Object)TOP)) {
                    simp = TOP;
                }
            } else if (MINFUN.equals(fun)) {
                ATermInt n = (ATermInt)arg2;
                if (n != null && n.getInt() == 0) {
                    simp = TOP;
                }
                if (arg3 != null && arg3.equals((Object)BOTTOM)) {
                    simp = BOTTOM;
                }
            } else if (MAXFUN.equals(fun)) {
                ATermInt n = (ATermInt)arg2;
                if (n != null && arg3 != null && n.getInt() > 0 && arg3.equals((Object)BOTTOM)) {
                    simp = TOP;
                }
            } else {
                throw new InternalReasonerException("Unknown term type: " + term);
            }
        }
        return simp;
    }

    public static ATermAppl makeSimplifiedAnd(Collection<ATermAppl> conjuncts) {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        ArrayList<ATermAppl> negations = new ArrayList<ATermAppl>();
        MultiListIterator listIt = new MultiListIterator(EMPTY_LIST);
        PairIterator<ATermAppl> i = new PairIterator<ATermAppl>(conjuncts.iterator(), listIt);
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            if (TOP.equals(c)) continue;
            if (BOTTOM.equals(c)) {
                return BOTTOM;
            }
            if (ATermUtils.isAnd(c)) {
                listIt.append((ATermList)c.getArgument(0));
                continue;
            }
            if (ATermUtils.isNot(c)) {
                negations.add(c);
                continue;
            }
            set.add(c);
        }
        for (ATermAppl notC : negations) {
            ATermAppl c = (ATermAppl)notC.getArgument(0);
            if (!set.contains(c)) continue;
            return BOTTOM;
        }
        if (set.isEmpty()) {
            if (negations.isEmpty()) {
                return TOP;
            }
            if (negations.size() == 1) {
                return (ATermAppl)negations.get(0);
            }
        } else if (set.size() == 1 && negations.isEmpty()) {
            return (ATermAppl)set.iterator().next();
        }
        negations.addAll(set);
        int size = negations.size();
        ATermAppl[] terms = new ATermAppl[size];
        negations.toArray(terms);
        return ATermUtils.makeAnd(ATermUtils.toSet((ATerm[])terms, size));
    }

    public static Set<ATermAppl> findPrimitives(ATermAppl term) {
        HashSet<ATermAppl> primitives = new HashSet<ATermAppl>();
        ATermUtils.findPrimitives(term, primitives, false, false);
        return primitives;
    }

    public static Set<ATermAppl> findPrimitives(ATermAppl term, boolean skipRestrictions, boolean skipTopLevel) {
        HashSet<ATermAppl> primitives = new HashSet<ATermAppl>();
        ATermUtils.findPrimitives(term, primitives, skipRestrictions, skipTopLevel);
        return primitives;
    }

    public static void findPrimitives(ATermAppl term, Set<ATermAppl> primitives) {
        ATermUtils.findPrimitives(term, primitives, false, false);
    }

    public static void findPrimitives(ATermAppl term, Set<ATermAppl> primitives, boolean skipRestrictions, boolean skipTopLevel) {
        AFun fun = term.getAFun();
        if (ATermUtils.isPrimitive(term)) {
            primitives.add(term);
        } else if (!(SELFFUN.equals(fun) || VALUEFUN.equals(fun) || RESTRDATATYPEFUN.equals(fun))) {
            if (NOTFUN.equals(fun)) {
                ATermAppl arg = (ATermAppl)term.getArgument(0);
                if (!ATermUtils.isPrimitive(arg) || !skipTopLevel) {
                    ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                }
            } else if (ANDFUN.equals(fun) || ORFUN.equals(fun)) {
                ATermList list = (ATermList)term.getArgument(0);
                while (!list.isEmpty()) {
                    ATermAppl arg = (ATermAppl)list.getFirst();
                    if (!ATermUtils.isNegatedPrimitive(arg) || !skipTopLevel) {
                        ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                    }
                    list = list.getNext();
                }
            } else if (!skipRestrictions) {
                if (ALLFUN.equals(fun) || SOMEFUN.equals(fun)) {
                    ATermAppl arg = (ATermAppl)term.getArgument(1);
                    ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                } else if (MAXFUN.equals(fun) || MINFUN.equals(fun) || CARDFUN.equals(fun)) {
                    ATermAppl arg = (ATermAppl)term.getArgument(2);
                    ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                } else {
                    throw new InternalReasonerException("Unknown concept type: " + term);
                }
            }
        }
    }

    public static Collection<ATermAppl> primitiveOrBottom(Collection<ATermAppl> collection) {
        return collection.stream().filter(a -> ATermUtils.isPrimitive(a) || a == BOTTOM).collect(Collectors.toList());
    }

    public static Set<ATermAppl> primitiveOrBottom(Set<ATermAppl> collection) {
        return collection.stream().filter(a -> ATermUtils.isPrimitive(a) || a == BOTTOM).collect(Collectors.toSet());
    }

    public static ATermAppl makeRule(ATermAppl[] head, ATermAppl[] body) {
        return ATermUtils.makeRule(null, head, body);
    }

    public static ATermAppl makeRule(ATermAppl name, ATermAppl[] head, ATermAppl[] body) {
        return factory.makeAppl(RULEFUN, (ATerm)(name == null ? EMPTY : name), (ATerm)ATermUtils.makeList((ATerm[])head), (ATerm)ATermUtils.makeList((ATerm[])body));
    }

    public static ATermAppl makeBuiltinAtom(ATermAppl[] args) {
        return factory.makeAppl(BUILTINFUN, (ATerm)ATermUtils.makeList((ATerm[])args));
    }

    static {
        ANTISYMMETRICFUN = ASYMMETRICFUN = factory.asymmetric();
        FUNCTIONALFUN = factory.functional();
        INVFUNCTIONALFUN = factory.inverseFunctional();
        IRREFLEXIVEFUN = factory.irreflexive();
        REFLEXIVEFUN = factory.reflexive();
        SYMMETRICFUN = factory.symmetric();
        TRANSITIVEFUN = factory.transitive();
        SUBPROPFUN = factory.subProperty();
        EQPROPFUN = factory.equivalentProperty();
        INVPROPFUN = factory.inverseProperty();
        DOMAINFUN = factory.domain();
        RANGEFUN = factory.range();
        RULEFUN = factory.rule();
        BUILTINFUN = factory.builtin();
        DATATYPEDEFFUN = factory.datatypeDefinition();
        RESTRDATATYPEFUN = factory.restrictedDatatype();
        FACET = factory.facet();
        EMPTY = ATermUtils.makeTermAppl("");
        EMPTY_LIST = factory.makeList();
        AXIOM_FUN = SetUtils.create(TYPEFUN, PROPFUN, SAMEASFUN, DIFFERENTFUN, ALLDIFFERENTFUN, SUBFUN, EQCLASSFUN, DISJOINTFUN, DISJOINTSFUN, COMPLEMENTFUN, SUBPROPFUN, EQPROPFUN, INVPROPFUN, DOMAINFUN, RANGEFUN, FUNCTIONALFUN, INVFUNCTIONALFUN, TRANSITIVEFUN, SYMMETRICFUN, REFLEXIVEFUN, IRREFLEXIVEFUN, ANTISYMMETRICFUN);
        TOP = ATermUtils.makeTermAppl("_TOP_");
        BOTTOM = ATermUtils.makeNot((ATerm)TOP);
        TOP_OBJECT_PROPERTY = ATermUtils.makeTermAppl("_TOP_OBJECT_PROPERTY_");
        TOP_DATA_PROPERTY = ATermUtils.makeTermAppl("_TOP_DATA_PROPERTY_");
        BOTTOM_OBJECT_PROPERTY = ATermUtils.makeTermAppl("_BOTTOM_OBJECT_PROPERTY_");
        BOTTOM_DATA_PROPERTY = ATermUtils.makeTermAppl("_BOTTOM_DATA_PROPERTY_");
        TOP_LIT = ATermUtils.makeTermAppl("http://www.w3.org/2000/01/rdf-schema#Literal");
        BOTTOM_LIT = ATermUtils.makeNot((ATerm)TOP_LIT);
        CONCEPT_SAT_IND = ATermUtils.makeTermAppl("_C_");
        ONE = factory.makeInt(1);
        LITERAL_STRING = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#string");
        PLAIN_LITERAL_DATATYPE = ATermUtils.makeTermAppl("http://www.w3.org/1999/02/22-rdf-syntax-ns#PlainLiteral");
        qnames = new QNameProvider();
        NO_DATATYPE = ATermUtils.makeTermAppl("NO_DATATYPE");
        BNODE_FUN = factory.makeAFun("bnode", 1, false);
        ANON_FUN = factory.makeAFun("anon", 1, false);
        ANON_NOMINAL_FUN = factory.makeAFun("anon_nominal", 1, false);
        anonCache = new ATermAppl[1000];
        for (int i = 0; i < anonCache.length; ++i) {
            ATermUtils.anonCache[i] = factory.makeAppl(ANON_FUN, (ATerm)factory.makeInt(i));
        }
    }
}

