/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import openllet.atom.OpenError;
import openllet.core.utils.AlphaNumericComparator;

public class FileUtils {
    public static boolean exists(String file) {
        return new File(file).exists();
    }

    public static String readURL(URL fileURL) throws IOException {
        return FileUtils.readAll(new InputStreamReader(fileURL.openStream()));
    }

    public static String readFile(File file) throws FileNotFoundException, IOException {
        try (FileReader reader = new FileReader(file);){
            String string = FileUtils.readAll(reader);
            return string;
        }
    }

    public static String readFile(String fileName) throws FileNotFoundException, IOException {
        try (FileReader reader = new FileReader(fileName);){
            String string = FileUtils.readAll(reader);
            return string;
        }
    }

    public static String readAll(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader in = new BufferedReader(reader);){
            int ch;
            while ((ch = in.read()) > -1) {
                buffer.append((char)ch);
            }
        }
        return buffer.toString();
    }

    public static String toURI(String fileName) {
        try {
            URI uri = URI.create(fileName);
            if (uri.isAbsolute()) {
                return uri.toString();
            }
            return new File(fileName).toURI().toString();
        }
        catch (IllegalArgumentException e1) {
            File localFile = new File(fileName);
            if (!localFile.exists()) {
                throw new OpenError((Throwable)new FileNotFoundException(localFile.getAbsolutePath()));
            }
            try {
                return localFile.toURI().toURL().toString();
            }
            catch (MalformedURLException e2) {
                throw new OpenError(e1.getMessage() + " " + e2.getMessage(), (Throwable)new FileNotFoundException(localFile.getAbsolutePath()));
            }
        }
    }

    public static Collection<String> getFileURIsFromRegex(String ... fileNameRegexList) {
        ArrayList<String> uris = new ArrayList<String>();
        for (String fileNameRegex : fileNameRegexList) {
            File file = new File(fileNameRegex);
            File dir = file.getParentFile();
            if (dir != null && dir.exists()) {
                String filter = file.getName();
                File[] files = dir.listFiles((dir1, name) -> dir1 != null && name.matches(filter));
                if (files.length == 0) {
                    throw new OpenError("File not found: " + fileNameRegex);
                }
                Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
                for (File f : files) {
                    uris.add(f.toURI().toString());
                }
                continue;
            }
            if (file.exists()) {
                uris.add(file.toURI().toString());
                continue;
            }
            if (URI.create(fileNameRegex) == null) {
                throw new OpenError((Throwable)new FileNotFoundException(fileNameRegex));
            }
            uris.add(fileNameRegex);
        }
        return uris;
    }

    public static Collection<String> getFileURIs(String ... fileNameList) {
        ArrayList<String> uris = new ArrayList<String>();
        for (String fileName : fileNameList) {
            uris.add(FileUtils.getFileURI(fileName));
        }
        return uris;
    }

    public static String getFileURI(String fileName) {
        File file = new File(fileName);
        File dir = file.getParentFile();
        if (file.exists()) {
            return file.toURI().toString();
        }
        if (dir != null && dir.exists()) {
            throw new OpenError((Throwable)new FileNotFoundException(fileName));
        }
        if (URI.create(fileName) == null) {
            throw new OpenError((Throwable)new FileNotFoundException(fileName));
        }
        return fileName;
    }
}

