/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.rbox.Role;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Bool;
import openllet.core.utils.KBOperation;
import openllet.core.utils.StatisticsTable;
import openllet.core.utils.Timer;
import openllet.shared.tools.Log;

public class SizeEstimate {
    protected static final Logger _logger = Log.getLogger(SizeEstimate.class);
    public static double UNKNOWN_PROB = 0.5;
    public static boolean CHECK_CONCEPT_SAT = false;
    private long noSatCost;
    private long oneSatCost;
    private long classificationCost;
    private long realizationCost;
    private long instanceRetrievalCost;
    private long classRetrievalCost;
    private final KnowledgeBase _kb;
    private boolean computed = false;
    private int pCount;
    private int opCount;
    private int dpCount;
    private int fpCount;
    private int ifpCount;
    private int tpCount;
    private int spCount;
    private int cCount;
    private int iCount;
    private Map<ATermAppl, Integer> instancesPC;
    private Map<ATermAppl, Integer> directInstancesPC;
    private Map<ATermAppl, Integer> classesPI;
    private Map<ATermAppl, Integer> directClassesPI;
    private Map<ATermAppl, Integer> pairsPP;
    private Map<ATermAppl, Integer> sames;
    private Map<ATermAppl, Integer> differents;
    private Map<ATermAppl, Double> avgObjectsPP;
    private Map<ATermAppl, Integer> equivClasses;
    private Map<ATermAppl, Integer> subClasses;
    private Map<ATermAppl, Integer> directSubClasses;
    private Map<ATermAppl, Integer> superClasses;
    private Map<ATermAppl, Integer> directSuperClasses;
    private Map<ATermAppl, Integer> disjoints;
    private Map<ATermAppl, Integer> complements;
    private Map<ATermAppl, Integer> equivProperties;
    private Map<ATermAppl, Integer> subProperties;
    private Map<ATermAppl, Integer> directSubProperties;
    private Map<ATermAppl, Integer> superProperties;
    private Map<ATermAppl, Integer> directSuperProperties;
    private Map<ATermAppl, Integer> inverses;
    private double avgClassesPI;
    private double avgDirectClassesPI;
    private double avgSamesPI;
    private double avgDifferentsPI;
    private double avgSubClasses;
    private double avgDirectSubClasses;
    private double avgSuperClasses;
    private double avgDirectSuperClasses;
    private double avgEquivClasses;
    private double avgDisjoints;
    private double avgComplements;
    private double avgSubProperties;
    private double avgDirectSubProperties;
    private double avgSuperProperties;
    private double avgDirectSuperProperties;
    private double avgEquivProperties;
    private double avgInversesPP;
    private double avgPairsPP;
    private double avgSubjectsPerProperty;
    private double avgInstancesPC;
    private double avgDirectInstances;

    public SizeEstimate(KnowledgeBase kb) {
        this._kb = kb;
        this.init();
    }

    public boolean isKBComputed() {
        return this.computed;
    }

    private void init() {
        this.cCount = this._kb.getClasses().size();
        this.iCount = this._kb.getIndividuals().size();
        this.pCount = this._kb.getProperties().size();
        this.opCount = this._kb.getObjectProperties().size();
        this.dpCount = this._kb.getDataProperties().size();
        this.fpCount = this._kb.getFunctionalProperties().size();
        this.ifpCount = this._kb.getInverseFunctionalProperties().size();
        this.tpCount = this._kb.getTransitiveProperties().size();
        this.spCount = this._kb.getSymmetricProperties().size();
        this.instancesPC = new HashMap<ATermAppl, Integer>();
        this.directInstancesPC = new HashMap<ATermAppl, Integer>();
        this.classesPI = new HashMap<ATermAppl, Integer>();
        this.directClassesPI = new HashMap<ATermAppl, Integer>();
        this.pairsPP = new HashMap<ATermAppl, Integer>();
        this.avgObjectsPP = new HashMap<ATermAppl, Double>();
        this.sames = new HashMap<ATermAppl, Integer>();
        this.differents = new HashMap<ATermAppl, Integer>();
        this.subClasses = new HashMap<ATermAppl, Integer>();
        this.directSubClasses = new HashMap<ATermAppl, Integer>();
        this.superClasses = new HashMap<ATermAppl, Integer>();
        this.directSuperClasses = new HashMap<ATermAppl, Integer>();
        this.equivClasses = new HashMap<ATermAppl, Integer>();
        this.disjoints = new HashMap<ATermAppl, Integer>();
        this.complements = new HashMap<ATermAppl, Integer>();
        this.inverses = new HashMap<ATermAppl, Integer>();
        this.subProperties = new HashMap<ATermAppl, Integer>();
        this.directSubProperties = new HashMap<ATermAppl, Integer>();
        this.superProperties = new HashMap<ATermAppl, Integer>();
        this.directSuperProperties = new HashMap<ATermAppl, Integer>();
        this.equivProperties = new HashMap<ATermAppl, Integer>();
        this.instancesPC.put(ATermUtils.TOP, this.iCount);
        this.instancesPC.put(ATermUtils.BOTTOM, 0);
        this.subClasses.put(ATermUtils.TOP, this.cCount);
        this.directSubClasses.put(ATermUtils.TOP, this.cCount);
        this.subClasses.put(ATermUtils.BOTTOM, 1);
        this.directSubClasses.put(ATermUtils.BOTTOM, 0);
        this.superClasses.put(ATermUtils.TOP, 1);
        this.directSuperClasses.put(ATermUtils.TOP, 0);
        this.superClasses.put(ATermUtils.BOTTOM, this.cCount);
        this.directSuperClasses.put(ATermUtils.BOTTOM, this.cCount);
        this.equivClasses.put(ATermUtils.TOP, 1);
        this.equivClasses.put(ATermUtils.BOTTOM, 1);
        this.disjoints.put(ATermUtils.TOP, 1);
        this.disjoints.put(ATermUtils.BOTTOM, this.cCount);
        this.complements.put(ATermUtils.TOP, 1);
        this.complements.put(ATermUtils.BOTTOM, 1);
        this.computed = false;
        this.avgSubjectsPerProperty = 1.0;
        this.avgPairsPP = 1.0;
        this.computKBCosts();
    }

    public void computKBCosts() {
        int classCount = this._kb.getClasses().size();
        int indCount = this._kb.getClasses().size();
        this.noSatCost = 1L;
        this.oneSatCost = 2L;
        this.classificationCost = this._kb.isClassified() ? this.noSatCost : (long)(classCount * classCount) * this.oneSatCost / 10L;
        this.realizationCost = this._kb.isRealized() ? this.noSatCost : this.classificationCost + this.oneSatCost * (long)classCount * (long)indCount;
        this.instanceRetrievalCost = this._kb.isRealized() ? this.noSatCost : (long)indCount * this.oneSatCost / 100L;
        this.classRetrievalCost = this._kb.isRealized() ? this.noSatCost : this.realizationCost;
    }

    public void computeAll() {
        if (!this.computed) {
            this.computKBCosts();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("   NoSat cost : " + this.noSatCost + " ms.");
                _logger.fine("  OneSat cost : " + this.oneSatCost + " ms.");
                _logger.fine("Classify cost : " + this.classificationCost + " ms.");
                _logger.fine(" Realize cost : " + this.realizationCost + " ms.");
                _logger.fine("      IR cost : " + this.instanceRetrievalCost + " ms.");
                _logger.fine("      CR cost : " + this.classRetrievalCost + " ms.");
            }
            this.compute(new HashSet<ATermAppl>(this._kb.getClasses()), new HashSet<ATermAppl>(this._kb.getProperties()));
            this.computed = true;
        }
    }

    public boolean isComputed(ATermAppl term) {
        return this.instancesPC.containsKey(term) || this.pairsPP.containsKey(term) || this.classesPI.containsKey(term);
    }

    private static double average(Collection<Integer> x) {
        int a = 0;
        for (Integer integer : x) {
            a += integer.intValue();
        }
        return x.size() > 0 ? (double)a / (double)x.size() : 1.0;
    }

    public synchronized void compute(Collection<ATermAppl> cs, Collection<ATermAppl> ps) {
        HashSet<ATermAppl> concepts = new HashSet<ATermAppl>(cs);
        HashSet<ATermAppl> properties = new HashSet<ATermAppl>(ps);
        concepts.removeAll(this.instancesPC.keySet());
        properties.removeAll(this.pairsPP.keySet());
        Optional<Timer> timer = this._kb.getTimers().startTimer("sizeEstimate");
        _logger.fine("Size estimation started");
        Random randomGen = new Random();
        HashMap<ATermAppl, Integer> pSubj = new HashMap<ATermAppl, Integer>();
        HashMap<ATermAppl, Integer> pObj = new HashMap<ATermAppl, Integer>();
        Taxonomy<ATermAppl> taxonomy = this._kb.isClassified() ? this._kb.getTaxonomy() : this._kb.getToldTaxonomy();
        Iterator i = concepts.iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            if (!this._kb.isClass((ATerm)c)) continue;
            if (taxonomy.contains(c)) {
                this.subClasses.put(c, taxonomy.getFlattenedSubs(c, false).size());
                this.directSubClasses.put(c, taxonomy.getFlattenedSubs(c, true).size());
                this.superClasses.put(c, taxonomy.getFlattenedSupers(c, false).size());
                this.directSuperClasses.put(c, taxonomy.getFlattenedSupers(c, true).size());
                this.equivClasses.put(c, taxonomy.getEquivalents(c).size() + 1);
            } else {
                this.subClasses.put(c, 1);
                this.directSubClasses.put(c, 1);
                this.superClasses.put(c, 1);
                this.directSuperClasses.put(c, 1);
                this.equivClasses.put(c, 1);
            }
            Map<ATermAppl, Set<ATermAppl>> toldDisjoints = this._kb.getToldDisjoints();
            if (toldDisjoints.containsKey(c)) {
                this.disjoints.put(c, toldDisjoints.get(c).size());
                this.complements.put(c, toldDisjoints.get(c).size());
            } else {
                this.disjoints.put(c, 1);
                this.complements.put(c, 1);
            }
            if (this._kb.isRealized() && !ATermUtils.isComplexClass((ATerm)c)) {
                this.instancesPC.put(c, this._kb.getInstances(c).size());
                this.directInstancesPC.put(c, this._kb.getInstances(c, true).size());
            } else {
                this.instancesPC.put(c, 0);
                this.directInstancesPC.put(c, 0);
                if (CHECK_CONCEPT_SAT) {
                    if (!this._kb.isSatisfiable(c)) {
                        i.remove();
                    }
                    if (!this._kb.isSatisfiable(ATermUtils.makeNot((ATerm)c))) {
                        i.remove();
                        this.instancesPC.put(c, this._kb.getIndividualsCount());
                    }
                }
            }
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("Initialize " + c + " = " + this.size(c));
        }
        for (ATermAppl p : properties) {
            this.pairsPP.put(p, 0);
            pSubj.put(p, 0);
            pObj.put(p, 0);
            this.subProperties.put(p, this._kb.getSubProperties(p).size());
            this.directSubProperties.put(p, this._kb.getSubProperties(p, true).size());
            this.superProperties.put(p, this._kb.getSuperProperties(p).size());
            this.directSuperProperties.put(p, this._kb.getSuperProperties(p, true).size());
            this.equivProperties.put(p, ATermUtils.primitiveOrBottom(this._kb.getEquivalentProperties(p)).size() + 1);
            this.inverses.put(p, this._kb.getInverses((ATerm)p).size());
        }
        for (ATermAppl ind : this._kb.getIndividuals()) {
            if (!this._kb.isIndividual((ATerm)ind)) continue;
            this.sames.put(ind, 1);
            this.differents.put(ind, this.iCount);
            float random = randomGen.nextFloat();
            if ((double)random > OpenlletOptions.SAMPLING_RATIO) continue;
            if (this._kb.isRealized()) {
                this.classesPI.put(ind, this._kb.getTypes(ind).size());
                this.directClassesPI.put(ind, this._kb.getTypes(ind, true).size());
            } else {
                this.classesPI.put(ind, 0);
                this.directClassesPI.put(ind, 0);
                for (ATermAppl c : concepts) {
                    Bool isKnownType = this._kb.getABox().isKnownType(ind, c);
                    if (!isKnownType.isTrue() && (!CHECK_CONCEPT_SAT || !isKnownType.isUnknown() || !((double)randomGen.nextFloat() < UNKNOWN_PROB))) continue;
                    this.instancesPC.put(c, this.size(c) + 1);
                    this.directInstancesPC.put(c, this.size(c) + 1);
                    this.classesPI.put(ind, this.classesPerInstance(ind, false) + 1);
                    this.directClassesPI.put(ind, this.classesPerInstance(ind, true) + 1);
                }
            }
            for (ATermAppl p : properties) {
                HashSet<Object> unknowns;
                Collection<Object> knowns;
                Role role = this._kb.getRBox().getRole((ATerm)p);
                int knownSize = 0;
                if (role.isObjectRole()) {
                    knowns = new HashSet();
                    unknowns = new HashSet<ATermAppl>();
                    this._kb.getABox().getObjectPropertyValues(ind, role, (Set<ATermAppl>)knowns, (Set<ATermAppl>)unknowns, true);
                    knownSize = knowns.size();
                } else {
                    knowns = this._kb.getABox().getObviousDataPropertyValues(ind, role, null);
                    knownSize = knowns.size();
                }
                if (knownSize > 0) {
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.finer("Update " + p + " by " + knownSize);
                    }
                    this.pairsPP.put(p, this.size(p) + knownSize);
                    pSubj.put(p, (Integer)pSubj.get(p) + 1);
                }
                if (!role.isObjectRole()) continue;
                role = role.getInverse();
                knowns = new HashSet();
                unknowns = new HashSet();
                this._kb.getABox().getObjectPropertyValues(ind, role, (Set<ATermAppl>)knowns, (Set<ATermAppl>)unknowns, true);
                if (knowns.isEmpty()) continue;
                pObj.put(p, (Integer)pObj.get(p) + 1);
            }
        }
        if (!this.computed) {
            this.avgClassesPI = SizeEstimate.average(this.classesPI.values());
            this.avgDirectClassesPI = SizeEstimate.average(this.directClassesPI.values());
        }
        if (!this._kb.isRealized()) {
            for (ATermAppl c : concepts) {
                int size = this.instancesPC.get(c);
                if (size == 0) {
                    this.instancesPC.put(c, 1);
                } else {
                    this.instancesPC.put(c, (int)((double)size / OpenlletOptions.SAMPLING_RATIO));
                }
                size = this.directInstancesPC.get(c);
                if (size == 0) {
                    this.directInstancesPC.put(c, 1);
                    continue;
                }
                this.directInstancesPC.put(c, (int)((double)size / OpenlletOptions.SAMPLING_RATIO));
            }
            int avgCPI = Double.valueOf(this.avgClassesPI).intValue();
            int avgDCPI = Double.valueOf(this.avgDirectClassesPI).intValue();
            for (ATermAppl i2 : this._kb.getIndividuals()) {
                Integer size = this.classesPI.get(i2);
                if (size == null) {
                    size = avgCPI;
                }
                if (size == 0) {
                    this.classesPI.put(i2, 1);
                } else {
                    this.classesPI.put(i2, (int)((double)size.intValue() / OpenlletOptions.SAMPLING_RATIO));
                }
                size = this.directClassesPI.get(i2);
                if (size == null) {
                    size = avgDCPI;
                }
                if (size == 0) {
                    this.directClassesPI.put(i2, 1);
                    continue;
                }
                this.directClassesPI.put(i2, (int)((double)size.intValue() / OpenlletOptions.SAMPLING_RATIO));
            }
        }
        for (ATermAppl p : properties) {
            int objCount;
            int size = this.size(p);
            if (size == 0) {
                this.pairsPP.put(p, 1);
            } else {
                this.pairsPP.put(p, (int)((double)size / OpenlletOptions.SAMPLING_RATIO));
            }
            Role role = this._kb.getRBox().getRole((ATerm)p);
            ATermAppl invP = role.getInverse() != null ? role.getInverse().getName() : null;
            int subjCount = (Integer)pSubj.get(p);
            if (subjCount == 0) {
                subjCount = 1;
            }
            if ((objCount = ((Integer)pObj.get(p)).intValue()) == 0) {
                objCount = 1;
            }
            double avg = (double)size / (double)subjCount;
            this.avgObjectsPP.put(p, avg);
            this.avgSubjectsPerProperty += (double)subjCount;
            if (invP == null) continue;
            avg = (double)size / (double)objCount;
            this.avgObjectsPP.put(invP, avg);
            this.avgSubjectsPerProperty += (double)objCount;
        }
        if (properties.size() > 0) {
            this.avgSubjectsPerProperty /= (double)(2 * properties.size());
            this.avgPairsPP = SizeEstimate.average(this.pairsPP.values());
        } else {
            this.avgSubjectsPerProperty = 1.0;
            this.avgPairsPP = 1.0;
        }
        this.avgInstancesPC = SizeEstimate.average(this.instancesPC.values());
        this.avgDirectInstances = SizeEstimate.average(this.directInstancesPC.values());
        this.avgSamesPI = SizeEstimate.average(this.sames.values());
        this.avgDifferentsPI = SizeEstimate.average(this.differents.values());
        this.avgSubClasses = SizeEstimate.average(this.subClasses.values());
        this.avgDirectSubClasses = SizeEstimate.average(this.directSubClasses.values());
        this.avgSuperClasses = SizeEstimate.average(this.superClasses.values());
        this.avgDirectSuperClasses = SizeEstimate.average(this.directSuperClasses.values());
        this.avgEquivClasses = SizeEstimate.average(this.equivClasses.values());
        this.avgDisjoints = SizeEstimate.average(this.disjoints.values());
        this.avgComplements = SizeEstimate.average(this.complements.values());
        this.avgSubProperties = SizeEstimate.average(this.subProperties.values());
        this.avgDirectSubProperties = SizeEstimate.average(this.directSubProperties.values());
        this.avgSuperProperties = SizeEstimate.average(this.superProperties.values());
        this.avgDirectSuperProperties = SizeEstimate.average(this.directSuperProperties.values());
        this.avgEquivProperties = SizeEstimate.average(this.equivProperties.values());
        this.avgInversesPP = SizeEstimate.average(this.inverses.values());
        timer.ifPresent(t -> t.stop());
        if (_logger.isLoggable(Level.FINE) && timer.isPresent()) {
            DecimalFormat nf = new DecimalFormat("0.00");
            _logger.fine("Size estimation finished in " + nf.format((double)timer.get().getLast() / 1000.0) + " sec");
        }
    }

    private void printStatistics() {
        System.out.println("Avg classes per instance:" + this.avgClassesPI);
        System.out.println("Avg sames per _individual:" + this.avgSamesPerInstance());
        System.out.println("Avg differents per _individual:" + this.avgDifferentsPerInstance());
        StatisticsTable<ATermAppl, String> classes = new StatisticsTable<ATermAppl, String>();
        classes.add("size", this.instancesPC);
        classes.add("subs", this.subClasses);
        classes.add("supers", this.superClasses);
        classes.add("equivs", this.equivClasses);
        classes.add("complements", this.complements);
        classes.add("disjoints", this.disjoints);
        System.out.println(classes.toString());
        System.out.println("Avg individuals per class:" + this.avgInstancesPC);
        System.out.println("Avg subclasses:" + this.avgSubClasses(false));
        System.out.println("Avg direct subclasses:" + this.avgSubClasses(true));
        System.out.println("Avg superclasses:" + this.avgSuperClasses(false));
        System.out.println("Avg direct superclasses:" + this.avgSuperClasses(true));
        System.out.println("Avg equivalent classes:" + this.avgEquivClasses());
        System.out.println("Avg complement classes:" + this.avgComplementClasses());
        System.out.println("Avg disjoint classes:" + this.avgDisjointClasses());
        StatisticsTable<ATermAppl, String> properties = new StatisticsTable<ATermAppl, String>();
        properties.add("size", this.pairsPP);
        properties.add("avgs", this.avgObjectsPP);
        properties.add("subs", this.subProperties);
        properties.add("supers", this.superProperties);
        properties.add("equivs", this.equivProperties);
        properties.add("inverses", this.inverses);
        System.out.println(properties.toString());
        System.out.println("Avg pairs per property:" + this.avgPairsPerProperty());
        System.out.println("Avg subjects per property:" + this.avgSubjectsPerProperty());
        System.out.println("Avg subproperties:" + this.avgSubProperties(false));
        System.out.println("Avg superproperties:" + this.avgSuperProperties(false));
        System.out.println("Avg equivalent properties:" + this.avgEquivProperties());
    }

    public int size(ATermAppl c) {
        if (this.instancesPC.containsKey(c)) {
            return this.instancesPC.get(c);
        }
        if (this.pairsPP.containsKey(c)) {
            return this.pairsPP.get(c);
        }
        if (this._kb.isProperty((ATerm)c)) {
            this.compute(Collections.emptySet(), Collections.singleton(c));
        } else {
            this.compute(Collections.singleton(c), Collections.emptySet());
        }
        return this.size(c);
    }

    public int classesPerInstance(ATermAppl i, boolean direct) {
        Map<ATermAppl, Integer> map;
        Map<ATermAppl, Integer> map2 = map = direct ? this.directClassesPI : this.classesPI;
        if (map.containsKey(i)) {
            return map.get(i);
        }
        throw new InternalReasonerException("Instance number estimate : " + i + " is not found!");
    }

    public double avg(ATermAppl pred) {
        if (!this.avgObjectsPP.containsKey(pred)) {
            this.compute(Collections.emptySet(), Collections.singleton(pred));
        }
        return this.avgObjectsPP.get(pred);
    }

    public int getClassCount() {
        return this.cCount;
    }

    public int getInstanceCount() {
        return this.iCount;
    }

    public int getPropertyCount() {
        return this.pCount;
    }

    public int getObjectPropertyCount() {
        return this.opCount;
    }

    public int getDataPropertyCount() {
        return this.dpCount;
    }

    public int getFunctionalPropertyCount() {
        return this.fpCount;
    }

    public int getInverseFunctionalPropertyCount() {
        return this.ifpCount;
    }

    public int getTransitivePropertyCount() {
        return this.tpCount;
    }

    public int getSymmetricPropertyCount() {
        return this.spCount;
    }

    public double avgInstancesPerClass(boolean direct) {
        return direct ? this.avgDirectInstances : this.avgInstancesPC;
    }

    public double avgDirectInstancesPerClass() {
        return this.avgDirectInstances;
    }

    public double avgPairsPerProperty() {
        return this.avgPairsPP;
    }

    public double avgSubjectsPerProperty() {
        return this.avgSubjectsPerProperty;
    }

    public double avgSubClasses(boolean direct) {
        return direct ? this.avgDirectSubClasses : this.avgSubClasses;
    }

    public double avgSuperClasses(boolean direct) {
        return direct ? this.avgDirectSuperClasses : this.avgSuperClasses;
    }

    public double avgEquivClasses() {
        return this.avgEquivClasses;
    }

    public double avgDisjointClasses() {
        return this.avgDisjoints;
    }

    public double avgComplementClasses() {
        return this.avgComplements;
    }

    public double avgSubProperties(boolean direct) {
        return direct ? this.avgDirectSubProperties : this.avgSubProperties;
    }

    public double avgSuperProperties(boolean direct) {
        return direct ? this.avgDirectSuperProperties : this.avgSuperProperties;
    }

    public double avgEquivProperties() {
        return this.avgEquivProperties;
    }

    public double avgInverseProperties() {
        return this.avgInversesPP;
    }

    public double avgSamesPerInstance() {
        return this.avgSamesPI;
    }

    public double avgDifferentsPerInstance() {
        return this.avgDifferentsPI;
    }

    public double avgClassesPerInstance(boolean direct) {
        return direct ? this.avgDirectClassesPI : this.avgClassesPI;
    }

    public double subClasses(ATermAppl sup, boolean direct) {
        Map<ATermAppl, Integer> map;
        Map<ATermAppl, Integer> map2 = map = direct ? this.directSubClasses : this.subClasses;
        if (!map.containsKey(sup)) {
            this.compute(Collections.singleton(sup), Collections.emptySet());
            _logger.fine(() -> "Computing additionally " + sup);
        }
        return map.get(sup).intValue();
    }

    public double subProperties(ATermAppl sup, boolean direct) {
        Map<ATermAppl, Integer> map;
        Map<ATermAppl, Integer> map2 = map = direct ? this.directSubProperties : this.subProperties;
        if (!map.containsKey(sup)) {
            this.compute(Collections.emptySet(), Collections.singleton(sup));
            _logger.fine(() -> "Computing additionally " + sup);
        }
        return map.get(sup).intValue();
    }

    public double superClasses(ATermAppl sup, boolean direct) {
        Map<ATermAppl, Integer> map;
        Map<ATermAppl, Integer> map2 = map = direct ? this.directSuperClasses : this.superClasses;
        if (!map.containsKey(sup)) {
            this.compute(Collections.singleton(sup), Collections.emptySet());
            _logger.fine(() -> "Computing additionally " + sup);
        }
        return map.get(sup).intValue();
    }

    public double superProperties(ATermAppl sup, boolean direct) {
        Map<ATermAppl, Integer> map;
        Map<ATermAppl, Integer> map2 = map = direct ? this.directSuperProperties : this.superProperties;
        if (!map.containsKey(sup)) {
            this.compute(Collections.emptySet(), Collections.singleton(sup));
            _logger.fine(() -> "Computing additionally " + sup);
        }
        return map.get(sup).intValue();
    }

    public double equivClasses(ATermAppl sup) {
        if (!this.equivClasses.containsKey(sup)) {
            this.compute(Collections.singleton(sup), Collections.emptySet());
            _logger.fine(() -> "Computing additionally " + sup);
        }
        return this.equivClasses.get(sup).intValue();
    }

    public double equivProperties(ATermAppl sup) {
        if (!this.equivProperties.containsKey(sup)) {
            this.compute(Collections.emptySet(), Collections.singleton(sup));
            _logger.fine(() -> "Computing additionally " + sup);
        }
        return this.equivProperties.get(sup).intValue();
    }

    public double sames(ATermAppl sup) {
        if (this.sames.containsKey(sup)) {
            return this.sames.get(sup).intValue();
        }
        throw new InternalReasonerException("Sames estimate for " + sup + " is not found!");
    }

    public double differents(ATermAppl sup) {
        if (this.differents.containsKey(sup)) {
            return this.differents.get(sup).intValue();
        }
        throw new InternalReasonerException("Sames estimate for " + sup + " is not found!");
    }

    public double disjoints(ATermAppl sup) {
        if (!this.disjoints.containsKey(sup)) {
            this.compute(Collections.singleton(sup), Collections.emptySet());
            _logger.fine(() -> "Computing additionally " + sup);
        }
        return this.disjoints.get(sup).intValue();
    }

    public double complements(ATermAppl sup) {
        if (!this.complements.containsKey(sup)) {
            this.compute(Collections.singleton(sup), Collections.emptySet());
            _logger.fine(() -> "Computing additionally " + sup);
        }
        return this.complements.get(sup).intValue();
    }

    public double inverses(ATermAppl sup) {
        if (!this.inverses.containsKey(sup)) {
            this.compute(Collections.emptySet(), Collections.singleton(sup));
            _logger.fine(() -> "Computing additionally " + sup);
        }
        return this.inverses.get(sup).intValue();
    }

    public long getCost(KBOperation operation) {
        long cost;
        switch (operation) {
            case IS_DIRECT_TYPE: {
                cost = this.getCost(KBOperation.IS_TYPE);
                break;
            }
            case IS_TYPE: {
                cost = this._kb.isRealized() ? this.noSatCost : this.oneSatCost;
                break;
            }
            case HAS_PROPERTY_VALUE: {
                cost = this.noSatCost;
                break;
            }
            case IS_SUBCLASS_OF: 
            case IS_EQUIVALENT_CLASS: {
                cost = this.oneSatCost;
                break;
            }
            case IS_DISJOINT_WITH: 
            case IS_COMPLEMENT_OF: {
                cost = this.oneSatCost;
                break;
            }
            case IS_SUBPROPERTY_OF: 
            case IS_EQUIVALENT_PROPERTY: {
                cost = this.noSatCost;
                break;
            }
            case IS_OBJECT_PROPERTY: 
            case IS_DATATYPE_PROPERTY: {
                cost = this.noSatCost;
                break;
            }
            case IS_FUNCTIONAL_PROPERTY: 
            case IS_INVERSE_FUNCTIONAL_PROPERTY: 
            case IS_TRANSITIVE_PROPERTY: 
            case IS_DOMAIN: 
            case IS_RANGE: {
                cost = this.oneSatCost;
                break;
            }
            case IS_INVERSE_OF: {
                cost = this.noSatCost;
                break;
            }
            case IS_SYMMETRIC_PROPERTY: {
                cost = this.noSatCost;
                break;
            }
            case IS_ASYMMETRIC_PROPERTY: {
                cost = this.noSatCost;
                break;
            }
            case IS_REFLEXIVE_PROPERTY: {
                cost = this.noSatCost;
                break;
            }
            case IS_IRREFLEXIVE_PROPERTY: {
                cost = this.noSatCost;
                break;
            }
            case GET_INVERSES: {
                cost = this.noSatCost;
                break;
            }
            case GET_INSTANCES: {
                cost = this.instanceRetrievalCost;
                break;
            }
            case GET_DIRECT_INSTANCES: {
                cost = this.instanceRetrievalCost + this.classificationCost;
                break;
            }
            case GET_TYPES: {
                cost = this.classRetrievalCost;
                break;
            }
            case GET_DIRECT_TYPES: {
                cost = this.getCost(KBOperation.GET_TYPES);
                break;
            }
            case GET_PROPERTY_VALUE: {
                cost = this.noSatCost;
                break;
            }
            case IS_SAME_AS: {
                cost = this.oneSatCost;
                break;
            }
            case GET_SAMES: {
                cost = this.oneSatCost;
                break;
            }
            case IS_DIFFERENT_FROM: {
                cost = this.oneSatCost;
                break;
            }
            case GET_DIFFERENTS: {
                cost = this.instanceRetrievalCost;
                break;
            }
            case GET_OBJECT_PROPERTIES: 
            case GET_DATATYPE_PROPERTIES: {
                cost = this.noSatCost;
                break;
            }
            case GET_FUNCTIONAL_PROPERTIES: 
            case GET_INVERSE_FUNCTIONAL_PROPERTIES: 
            case GET_TRANSITIVE_PROPERTIES: 
            case GET_SYMMETRIC_PROPERTIES: 
            case GET_ASYMMETRIC_PROPERTIES: 
            case GET_REFLEXIVE_PROPERTIES: 
            case GET_IRREFLEXIVE_PROPERTIES: 
            case GET_DOMAINS: 
            case GET_RANGES: {
                cost = this.noSatCost;
                break;
            }
            case GET_SUB_OR_SUPERCLASSES: 
            case GET_DIRECT_SUB_OR_SUPERCLASSES: 
            case GET_EQUIVALENT_CLASSES: {
                cost = this.classificationCost;
                break;
            }
            case GET_DISJOINT_CLASSES: 
            case GET_COMPLEMENT_CLASSES: {
                cost = this.classificationCost;
                break;
            }
            case GET_SUB_OR_SUPERPROPERTIES: 
            case GET_DIRECT_SUB_OR_SUPERPROPERTIES: 
            case GET_EQUIVALENT_PROPERTIES: {
                cost = this.noSatCost;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown KB Operation type : " + operation);
            }
        }
        return cost;
    }
}

