/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.config.ConfigurationException;

public class BaseConfiguration {
    private final Map<String, Validator> validators = new HashMap<String, Validator>();
    private final Map<String, Object> paramMap = new HashMap<String, Object>();

    public BaseConfiguration() {
    }

    protected BaseConfiguration(BaseConfiguration config) {
        this.paramMap.putAll(config.paramMap);
        this.validators.putAll(config.validators);
    }

    protected void initConfiguration() {
        Field[] allFields;
        for (Field field : allFields = this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Parameter.class)) continue;
            Parameter annotation = field.getAnnotation(Parameter.class);
            try {
                Class<?> paramClass = Class.forName(annotation.type());
                Validator validator = BaseConfiguration.newValidator(paramClass);
                String paramName = field.get(null).toString();
                Object paramValue = validator.create(annotation.value());
                this.paramMap.put(paramName, paramValue);
                this.validators.put(paramName, validator);
            }
            catch (Throwable e) {
                throw new ConfigurationException("Perhaps incorrect declaration of the configuration parameter " + field.getName(), e);
            }
        }
    }

    public Object getParameter(String name) {
        return this.paramMap.get(name);
    }

    public int getParameterAsInt(String name) {
        return Integer.valueOf("" + this.paramMap.get(name));
    }

    public boolean getParameterAsBoolean(String name) {
        return Boolean.valueOf("" + this.paramMap.get(name));
    }

    public BaseConfiguration setParameter(String name, String value) {
        Object createdValue;
        Validator validator = this.validators.get(name);
        if (validator == null) {
            createdValue = value;
        } else {
            try {
                createdValue = validator.create(value);
            }
            catch (Exception e) {
                throw new ConfigurationException("Wrong value " + value + " for parameter " + name, e);
            }
        }
        this.paramMap.put(name, createdValue);
        return this;
    }

    public BaseConfiguration setParameters(Map<String, String> parameters) {
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            this.setParameter(e.getKey(), e.getValue());
        }
        return this;
    }

    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.paramMap.keySet());
    }

    public static Method getValueOfMethod(Class<?> clazz) {
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            int mods = method.getModifiers();
            Class<?>[] params = method.getParameterTypes();
            if (Modifier.isPublic(mods) && Modifier.isStatic(mods) && params.length == 1 && params[0].equals(String.class)) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static Constructor<?> getStringConstructorMethod(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getConstructor(String.class);
            int mods = constructor.getModifiers();
            if (Modifier.isPublic(mods)) {
                return constructor;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static Validator newValidator(Class<?> clazz) throws IllegalArgumentException {
        Method valueOf = BaseConfiguration.getValueOfMethod(clazz);
        if (valueOf != null) {
            return new ValueOfValidator(valueOf);
        }
        Constructor<?> constructor = BaseConfiguration.getStringConstructorMethod(clazz);
        if (constructor != null) {
            return new ConstructorValidator(constructor);
        }
        throw new IllegalArgumentException("The class does not have valueOf method nor a constructor that accepts a String.");
    }

    private static class ConstructorValidator
    implements Validator {
        private final Constructor<?> constructor;

        public ConstructorValidator(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public Object create(String value) throws Exception {
            return this.constructor.newInstance(value);
        }
    }

    private static class ValueOfValidator
    implements Validator {
        private final Method valueOf;

        public ValueOfValidator(Method valueOf) {
            this.valueOf = valueOf;
        }

        @Override
        public Object create(String value) throws Exception {
            return this.valueOf.invoke(null, value);
        }
    }

    private static interface Validator {
        public Object create(String var1) throws Exception;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameter {
        public String type();

        public String value() default "";
    }
}

