/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import openllet.atom.OpenError;
import openllet.owlapi.IRIUtils;
import openllet.owlapi.OWLException;
import openllet.owlapi.OWLGenericTools;
import openllet.owlapi.OWLGroup;
import openllet.owlapi.OWLManagementObject;
import openllet.owlapi.OWLManagerGroup;
import openllet.owlapi.OpenlletReasoner;
import openllet.owlapi.PelletReasoner;
import openllet.shared.tools.Logging;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntaxObjectRenderer;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormatFactory;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.util.OWLDocumentFormatFactoryImpl;

public interface OWLHelper
extends Logging,
OWLManagementObject {
    public static final boolean _debug = false;
    public static final String _protocol = "http://";
    public static final String _secureProtocol = "https://";
    public static final String _localProtocol = "file:/";
    public static final String _webSeparator = "/";
    public static final String _prefixSeparator = ":";
    public static final String _entitySeparator = "#";
    public static final String _innerSeparator = "_";
    public static final String _caseSeparator = "-";
    public static final String _fileExtention = ".owl";
    public static final String _fileExtentionPart = ".part";
    public static final String _delta = "owl.delta";
    public static final OWLDocumentFormatFactoryImpl _formatFactory = new FunctionalSyntaxDocumentFormatFactory();
    public static final OWLDocumentFormat _format = _formatFactory.get();

    public boolean isVolatile();

    public static void setFormat(OWLOntology ontology) {
        ontology.getOWLOntologyManager().setOntologyFormat(ontology, _format);
    }

    public static IRI buildVersion(IRI ontologyIRI, double version) {
        return IRI.create((String)(ontologyIRI + _innerSeparator + version));
    }

    public static OWLOntologyID getVersion(IRI ontologyIRI, double version) {
        return new OWLOntologyID(ontologyIRI, OWLHelper.buildVersion(ontologyIRI, version));
    }

    public static String iri2filename(IRI iri) {
        if (null == iri) {
            throw new OWLException("iri2filename(null)");
        }
        return iri.toString().replaceAll(_prefixSeparator, _innerSeparator).replaceAll(_webSeparator, _innerSeparator).replaceAll(_webSeparator, _innerSeparator).replaceAll("&", _innerSeparator);
    }

    public static String ontology2filename(File directory, OWLOntologyID ontId) {
        String id = OWLHelper.iri2filename((IRI)ontId.getOntologyIRI().get());
        IRI versionIRI = (IRI)ontId.getVersionIRI().get();
        String version = versionIRI != null ? OWLHelper.iri2filename(versionIRI) : "0";
        return directory + _webSeparator + id + _caseSeparator + version + _fileExtention;
    }

    public static String ontology2filename(File directory, OWLOntology ontology) {
        return OWLHelper.ontology2filename(directory, ontology.getOntologyID());
    }

    default public Optional<PrefixDocumentFormat> getNamespaces() {
        OWLDocumentFormat format = this.getManager().getOntologyFormat(this.getOntology());
        return format.isPrefixOWLDocumentFormat() ? Optional.of((PrefixDocumentFormat)format) : Optional.empty();
    }

    default public IRI getRootIri() {
        return IRI.create((String)((IRI)this.getOntology().getOntologyID().getOntologyIRI().get()).getNamespace());
    }

    default public String getFragment(IRI iri) {
        return XMLUtils.getNCNameSuffix((CharSequence)iri);
    }

    default public Optional<OWLOntology> getOntology(OWLOntologyID ontologyID) {
        return OWLGroup.getOntology(this.getManager(), ontologyID);
    }

    default public double getVersion() {
        IRI version = (IRI)this.getOntology().getOntologyID().getVersionIRI().get();
        if (null == version) {
            return 0.0;
        }
        try {
            String fragment = this.getFragment(version);
            int index = fragment.lastIndexOf(_innerSeparator.charAt(0));
            return Double.parseDouble(fragment.substring(index + 1));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, version.toString() + " isn't a standard version format", e);
            throw new OWLException("Plz use " + OWLHelper.class.getSimpleName() + " to manage your versions.", e);
        }
    }

    default public Optional<OWLHelper> look(IRI ontology, double version) {
        return this.getGroup().getOntology(ontology, version, this.isVolatile());
    }

    default public Optional<OWLHelper> look(IRI ontology) {
        return this.getGroup().getOntology(new OWLOntologyID(ontology), this.isVolatile());
    }

    default public OWLHelper derivate(double version) throws OWLOntologyCreationException {
        Optional<OWLHelper> result = this.look((IRI)this.getOntology().getOntologyID().getOntologyIRI().get(), version);
        if (!result.isPresent()) {
            throw new OWLOntologyCreationException("Can't derivate to version " + version);
        }
        if (result.get().getOntology().getAxiomCount() != 0) {
            this.getLogger().warning(() -> "The ontology you try to derivate from " + this.getVersion() + " to version " + version + " already exist.");
        }
        result.get().addAxioms(this.getOntology().axioms());
        return result.get();
    }

    default public OWLHelper derivate() throws OWLOntologyCreationException {
        return this.derivate(System.currentTimeMillis());
    }

    default public String removeFirstLast(String quoteExpression) {
        String expression = quoteExpression;
        if (quoteExpression != null) {
            expression = quoteExpression.substring(1, quoteExpression.length() - 1);
        }
        return expression;
    }

    default public String path(String[] parts) {
        StringBuffer buff = new StringBuffer();
        buff.append(parts[1]);
        for (int i = 2; i < parts.length; ++i) {
            buff.append(_entitySeparator).append(parts[i]);
        }
        return buff.toString();
    }

    default public String[] resolvPrefix(String identifier) {
        String[] parts = identifier.split(_prefixSeparator);
        if (parts.length == 0) {
            return new String[]{this.getRootIri().toString(), ""};
        }
        Optional<PrefixDocumentFormat> space = this.getNamespaces();
        if (space.isPresent()) {
            if (parts.length == 1) {
                return new String[]{space.get().getPrefix(""), parts[0]};
            }
            return new String[]{space.get().getPrefix(parts[0]), this.path(parts)};
        }
        return new String[]{identifier};
    }

    default public String[] getNameSpace(String identifier) {
        if (identifier.startsWith(_protocol) || identifier.startsWith(_secureProtocol)) {
            String[] parts = identifier.split(_entitySeparator);
            switch (parts.length) {
                case 0: {
                    throw new OpenError("Error processing : " + identifier);
                }
                case 1: {
                    return new String[]{identifier, ""};
                }
            }
            return new String[]{parts[0], this.path(parts)};
        }
        return this.resolvPrefix(identifier);
    }

    default public void deserializeAxiomsInto(String input) throws OWLOntologyCreationException, IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes());){
            this.addAxioms(this.getManager().loadOntologyFromOntologyDocument((InputStream)stream).axioms());
        }
        catch (OWLOntologyAlreadyExistsException e) {
            if (e.getOntologyID().equals((Object)this.getOntology().getOntologyID())) {
                this.getLogger().severe("The ontology already exists with the name of the Tools : " + e.getOntologyID());
                throw e;
            }
            this.getManager().removeOntology(e.getOntologyID());
            this.deserializeAxiomsInto(input);
        }
    }

    default public Stream<OWLAxiom> deserializeAxioms(String input) throws OWLOntologyCreationException, IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes());){
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLOntology ontology = manager.loadOntologyFromOntologyDocument((InputStream)stream);
            Stream stream2 = ontology.axioms();
            return stream2;
        }
    }

    default public String serializeAxioms() throws OWLOntologyStorageException, IOException {
        String string;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.getManager().saveOntology(this.getOntology(), (OutputStream)stream);
            string = stream.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | OWLOntologyStorageException e) {
                this.getLogger().log(Level.SEVERE, "Problem at serialisation of axioms : " + this.getOntology().getOntologyID(), e);
                throw e;
            }
        }
        stream.close();
        return string;
    }

    default public NodeSet<OWLClass> getTypes(OWLIndividual ind) {
        if (ind instanceof OWLAnonymousIndividual) {
            OWLNamedIndividual individual = this.getFactory().getOWLNamedIndividual(IRI.create((String)(_protocol + OWLHelper.class.getPackage().getName() + _webSeparator + OWLHelper.class.getSimpleName() + _entitySeparator + IRIUtils.randId(OWLHelper.class.getSimpleName()))));
            Stream<OWLAxiom> axioms = Stream.of(this.getFactory().getOWLDeclarationAxiom((OWLEntity)individual), this.getFactory().getOWLSameIndividualAxiom(new OWLIndividual[]{individual, ind}));
            this.getManager().addAxioms(this.getOntology(), axioms);
            NodeSet result = this.getReasoner().getTypes(individual, false);
            this.getManager().removeAxioms(this.getOntology(), axioms);
            return result;
        }
        return this.getReasoner().getTypes((OWLNamedIndividual)ind, false);
    }

    default public StringBuffer ontologyToString(StringBuffer buff, String msg) {
        DLSyntaxObjectRenderer syntax = new DLSyntaxObjectRenderer();
        buff.append("====\\/==" + msg + "===\\/====\n");
        this.getOntology().axioms().map(arg_0 -> ((DLSyntaxObjectRenderer)syntax).render(arg_0)).filter(x -> x != null && x.length() > 0).sorted().map(x -> x + "\n").forEach(buff::append);
        buff.append("====/\\==" + msg + "===/\\====\n");
        return buff;
    }

    default public String ontologyToString(String msg) {
        StringBuffer buff = new StringBuffer();
        this.ontologyToString(buff, msg);
        return buff.toString();
    }

    public void dispose();

    public static OWLHelper createLightHelper(OWLOntology ontology) {
        return new OWLGenericTools((OWLGroup)new OWLManagerGroup(ontology), ontology, true){

            @Override
            public void dispose() {
                super.dispose();
                try {
                    this.getGroup().close();
                }
                catch (Exception exception) {
                    throw new OpenError((Throwable)exception);
                }
            }
        };
    }

    public static OWLHelper createLightHelper(InputStream inputStream) {
        try {
            return OWLHelper.createLightHelper(OWLManager.createOWLOntologyManager().loadOntologyFromOntologyDocument(inputStream));
        }
        catch (OWLOntologyCreationException exception) {
            throw new OpenError((Throwable)exception);
        }
    }

    public static OWLHelper createLightHelper(final OpenlletReasoner reasoner) {
        return new OWLHelper(){
            private final OWLGroup _group = new OWLManagerGroup(Optional.of(this.getManager()), Optional.empty());

            public Logger getLogger() {
                return PelletReasoner._logger;
            }

            @Override
            public OWLDataFactory getFactory() {
                return reasoner.getFactory();
            }

            @Override
            public OWLOntologyManager getManager() {
                return reasoner.getManager();
            }

            @Override
            public OWLGroup getGroup() {
                return this._group;
            }

            @Override
            public OWLOntology getOntology() {
                return reasoner.getOntology();
            }

            @Override
            public OpenlletReasoner getReasoner() {
                reasoner.flush();
                return reasoner;
            }

            @Override
            public boolean isVolatile() {
                return true;
            }

            @Override
            public void dispose() {
                reasoner.dispose();
                if (null != this._group) {
                    try {
                        this._group.close();
                    }
                    catch (Exception exception) {
                        throw new OpenError((Throwable)exception);
                    }
                }
            }
        };
    }
}

