/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Logger;
import openllet.owlapi.parser.OWLFunctionalSyntaxParser;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OWLFunctionalSyntax {
    private static final Logger _logger = Log.getLogger(OWLFunctionalSyntax.class);

    public static Optional<OWLOntology> load(File file, OWLOntologyManager manager, Optional<OWLOntologyID> ontologyId) {
        OWLOntology ontology;
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            try {
                ontology = ontologyId.isPresent() ? manager.createOntology(ontologyId.get()) : manager.createOntology();
                OWLFunctionalSyntaxParser parser = new OWLFunctionalSyntaxParser(in);
                parser.setUp(ontology, new OWLOntologyLoaderConfiguration());
                try {
                    while (true) {
                        axioms.add(parser.Axiom());
                    }
                }
                catch (Exception exception) {
                    in.close();
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            Log.error((Logger)_logger, (String)("Can't load the ontology from file " + file + "."), (Throwable)exception);
            return Optional.empty();
        }
        ontology.addAxioms(axioms);
        return Optional.of(ontology);
    }
}

