/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.elk.util.collections.LinearProbing;
import org.semanticweb.elk.util.collections.LinearProbingIterator;

public class ArraySlicedSet<E> {
    public static int MAX_SLICES = 32;
    transient E[] data;
    transient int[] masks;
    transient int[] sizes;
    transient int occupied = 0;
    private final byte logs;
    private static int[] MSK_ = new int[]{1, 3, 15, 255, 65535, -1};

    public ArraySlicedSet(int slices, int initialCapacity) {
        if (slices <= 0 || slices > MAX_SLICES) {
            throw new IllegalArgumentException("The nuber of slices should be between 1 and " + MAX_SLICES + ": " + slices);
        }
        int capacity = LinearProbing.getInitialCapacity(initialCapacity);
        this.data = new Object[capacity];
        this.logs = (byte)ArraySlicedSet.upperLog(slices);
        this.masks = new int[ArraySlicedSet.getMaskCapacity(this.logs, capacity)];
        this.sizes = new int[slices];
        this.initSizes();
    }

    public ArraySlicedSet(int slices) {
        this(slices, 16);
    }

    static int upperLog(int n) {
        int log = 0;
        for (int exp = 1; exp < n; exp <<= 1) {
            ++log;
        }
        return log;
    }

    void initSizes() {
        for (int i = 0; i < this.sizes.length; ++i) {
            this.sizes[i] = 0;
        }
    }

    static int getMaskCapacity(byte sl, int capacity) {
        int result = capacity >> 5 - sl;
        if (result == 0) {
            result = 1;
        }
        return result;
    }

    static int getFragment(byte sl, int[] masks, int pos) {
        int shift = 5 - sl;
        int p = pos >> shift;
        int r = p << shift ^ pos;
        return masks[p] >> (r << sl) & MSK_[sl];
    }

    static void changeFragment(byte sl, int[] masks, int pos, int diff) {
        int shift = 5 - sl;
        int p = pos >> shift;
        int r = p << shift ^ pos;
        int n = p;
        masks[n] = masks[n] ^ diff << (r << sl);
    }

    public int size(int s) {
        return this.sizes[s];
    }

    public boolean isEmpty(int s) {
        return this.sizes[s] == 0;
    }

    private static <E> int addMask(byte sl, E[] data, int[] masks, E e, int mask) {
        int pos = LinearProbing.getPosition(data, e);
        int oldMask = ArraySlicedSet.getFragment(sl, masks, pos);
        if (data[pos] == null) {
            data[pos] = e;
            ArraySlicedSet.changeFragment(sl, masks, pos, oldMask ^ mask);
            return 0;
        }
        int newMask = oldMask | mask;
        if (newMask != oldMask) {
            ArraySlicedSet.changeFragment(sl, masks, pos, oldMask ^ newMask);
        }
        return oldMask;
    }

    private static <E> void remove(byte sl, E[] data, int[] masks, int pos) {
        int oldFragment = ArraySlicedSet.getFragment(sl, masks, pos);
        while (true) {
            int next = LinearProbing.getMovedPosition(data, pos);
            E moved = data[pos] = data[next];
            int newFragment = ArraySlicedSet.getFragment(sl, masks, next);
            ArraySlicedSet.changeFragment(sl, masks, pos, oldFragment ^ newFragment);
            if (moved == null) {
                return;
            }
            pos = next;
            oldFragment = newFragment;
        }
    }

    private static <E> int removeMask(byte sl, E[] data, int[] masks, Object o, int mask) {
        int pos = LinearProbing.getPosition(data, o);
        if (data[pos] == null) {
            return 0;
        }
        int oldFragment = ArraySlicedSet.getFragment(sl, masks, pos);
        int newFragment = oldFragment & ~mask;
        if (newFragment == 0) {
            ArraySlicedSet.remove(sl, data, masks, pos);
        } else {
            ArraySlicedSet.changeFragment(sl, masks, pos, oldFragment ^ newFragment);
        }
        return oldFragment;
    }

    private void enlarge() {
        int oldCapacity = this.data.length;
        if (oldCapacity == 0x40000000) {
            throw new IllegalArgumentException("The set cannot grow beyond the capacity: 1073741824");
        }
        E[] oldData = this.data;
        int[] oldMasks = this.masks;
        int newCapacity = oldCapacity << 1;
        Object[] newData = new Object[newCapacity];
        int[] newMasks = new int[ArraySlicedSet.getMaskCapacity(this.logs, newCapacity)];
        for (int i = 0; i < oldCapacity; ++i) {
            E e = oldData[i];
            if (e == null) continue;
            ArraySlicedSet.addMask(this.logs, newData, newMasks, e, ArraySlicedSet.getFragment(this.logs, oldMasks, i));
        }
        this.data = newData;
        this.masks = newMasks;
    }

    private void shrink() {
        int oldCapacity = this.data.length;
        if (oldCapacity == 1) {
            return;
        }
        E[] oldData = this.data;
        int[] oldMasks = this.masks;
        int newCapacity = oldCapacity >> 1;
        Object[] newData = new Object[newCapacity];
        int[] newMasks = new int[ArraySlicedSet.getMaskCapacity(this.logs, newCapacity)];
        for (int i = 0; i < oldCapacity; ++i) {
            E e = oldData[i];
            if (e == null) continue;
            ArraySlicedSet.addMask(this.logs, newData, newMasks, e, ArraySlicedSet.getFragment(this.logs, oldMasks, i));
        }
        this.data = newData;
        this.masks = newMasks;
    }

    public boolean contains(int s, Object o) {
        E[] d;
        int[] m;
        if (o == null) {
            throw new NullPointerException();
        }
        while ((m = this.masks).length != ArraySlicedSet.getMaskCapacity(this.logs, (d = this.data).length)) {
        }
        int pos = LinearProbing.getPosition(d, o);
        if (d[pos] == null) {
            return false;
        }
        int mask = 1 << s;
        return (ArraySlicedSet.getFragment(this.logs, m, pos) & mask) == mask;
    }

    public boolean add(int s, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        int mask = 1 << s;
        int oldMask = ArraySlicedSet.addMask(this.logs, this.data, this.masks, e, mask);
        int newMask = oldMask | mask;
        if (newMask == oldMask) {
            return false;
        }
        if (oldMask == 0 && ++this.occupied == LinearProbing.getUpperSize(this.data.length)) {
            this.enlarge();
        }
        int n = s;
        this.sizes[n] = this.sizes[n] + 1;
        return true;
    }

    public boolean remove(int s, Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int mask = 1 << s;
        int oldMask = ArraySlicedSet.removeMask(this.logs, this.data, this.masks, o, mask);
        int newMask = oldMask & ~mask;
        if (newMask == oldMask) {
            return false;
        }
        if (newMask == 0 && --this.occupied == LinearProbing.getLowerSize(this.data.length)) {
            this.shrink();
        }
        int n = s;
        this.sizes[n] = this.sizes[n] - 1;
        return true;
    }

    public boolean removeAll(int s, Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(s, o);
        }
        return modified;
    }

    public void clear() {
        int capacity = this.data.length >> 2;
        if (capacity == 0) {
            capacity = 1;
        }
        this.initSizes();
        this.data = new Object[capacity];
        this.masks = new int[ArraySlicedSet.getMaskCapacity(this.logs, capacity)];
    }

    public Set<E> getSlice(int s) {
        return new Slice(s);
    }

    private class ElementIterator
    extends LinearProbingIterator<E, E> {
        final int s;
        final int mask;

        ElementIterator(int s) {
            super(ArraySlicedSet.this.data, ArraySlicedSet.this.sizes[s]);
            this.s = s;
            this.mask = 1 << s;
            this.init();
        }

        @Override
        void checkSize(int expectedSize) {
            if (expectedSize != ArraySlicedSet.this.sizes[this.s]) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        boolean isOccupied(int pos) {
            return this.dataSnapshot[pos] != null && (ArraySlicedSet.getFragment(ArraySlicedSet.this.logs, ArraySlicedSet.this.masks, pos) & this.mask) == this.mask;
        }

        @Override
        void remove(int pos) {
            int oldMask = ArraySlicedSet.getFragment(ArraySlicedSet.this.logs, ArraySlicedSet.this.masks, pos);
            int newMask = oldMask & ~this.mask;
            if (newMask == 0) {
                ArraySlicedSet.remove(ArraySlicedSet.this.logs, ArraySlicedSet.this.data, ArraySlicedSet.this.masks, pos);
                --ArraySlicedSet.this.occupied;
            } else {
                ArraySlicedSet.changeFragment(ArraySlicedSet.this.logs, ArraySlicedSet.this.masks, pos, oldMask ^ newMask);
            }
            int n = this.s;
            ArraySlicedSet.this.sizes[n] = ArraySlicedSet.this.sizes[n] - 1;
        }

        @Override
        E getValue(E element, int pos) {
            return element;
        }
    }

    private class Slice
    extends AbstractSet<E>
    implements Set<E> {
        final byte s;

        Slice(int s) {
            if (s > ArraySlicedSet.this.sizes.length || s < 0) {
                throw new IllegalArgumentException("Slice should be in [0;" + ArraySlicedSet.this.sizes.length + "]: " + s);
            }
            this.s = (byte)s;
        }

        @Override
        public int size() {
            return ArraySlicedSet.this.size(this.s);
        }

        @Override
        public boolean isEmpty() {
            return ArraySlicedSet.this.isEmpty(this.s);
        }

        @Override
        public boolean contains(Object o) {
            return ArraySlicedSet.this.contains(this.s, o);
        }

        @Override
        public boolean add(E e) {
            return ArraySlicedSet.this.add(this.s, e);
        }

        @Override
        public boolean remove(Object o) {
            return ArraySlicedSet.this.remove(this.s, o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return ArraySlicedSet.this.removeAll(this.s, c);
        }

        @Override
        public Iterator<E> iterator() {
            return new ElementIterator((int)this.s);
        }

        @Override
        public String toString() {
            return Arrays.toString(this.toArray());
        }
    }
}

