/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.Evictor;
import org.semanticweb.elk.util.collections.Evictors;
import org.semanticweb.elk.util.collections.RecencyEvictor;
import org.semanticweb.elk.util.statistics.Stat;

public class CountingEvictor<E>
extends RecencyEvictor<E> {
    private final Map<E, ElementRecord> elementRecords_ = new ArrayHashMap<E, ElementRecord>();
    private final RecencyEvictor<E> immediatelyEvicted_ = new RecencyEvictor(0, 0.0);
    private final int evictBeforeAddCount_;

    CountingEvictor(int capacity, int evictBeforeAddCount, double loadFactor) {
        super(capacity, loadFactor);
        this.evictBeforeAddCount_ = evictBeforeAddCount;
        this.stats = new Stats();
    }

    @Override
    public void add(E element) {
        ElementRecord record = this.elementRecords_.get(element);
        if (record == null) {
            record = new ElementRecord();
            this.elementRecords_.put(element, record);
        }
        ++record.addCount;
        if (record.addCount >= this.evictBeforeAddCount_) {
            super.add(element);
        } else {
            this.immediatelyEvicted_.add(element);
        }
    }

    @Override
    public Iterator<E> evict(Predicate<E> retain) {
        return Iterators.concat(super.evict(retain), this.immediatelyEvicted_.evict(retain));
    }

    public static Builder builder() {
        return new Builder();
    }

    protected class Stats
    extends RecencyEvictor.Stats {
        protected Stats() {
            super(CountingEvictor.this);
        }

        @Stat
        public int nDifferentQueries() {
            return CountingEvictor.this.elementRecords_.size();
        }
    }

    public static class Builder
    extends ProtectedBuilder<Builder>
    implements Evictor.Builder {
        @Override
        protected Builder convertThis() {
            return this;
        }

        public static Builder valueOf(String value) {
            String[] args = Evictors.parseArgs(value, CountingEvictor.class, 3);
            String capacityArg = args[0].trim();
            String loadFactorArg = args[1].trim();
            String evictBeforeAddCountArg = args[2].trim();
            int capacity = capacityArg.isEmpty() ? 128 : Integer.valueOf(capacityArg);
            double loadFactor = loadFactorArg.isEmpty() ? 0.75 : Double.valueOf(loadFactorArg);
            int evictBeforeAddCount = evictBeforeAddCountArg.isEmpty() ? 3 : Integer.valueOf(evictBeforeAddCountArg);
            return (Builder)((Builder)((Builder)new Builder().capacity(capacity < 0 ? Integer.MAX_VALUE : capacity)).loadFactor(loadFactor)).evictBeforeAddCount(evictBeforeAddCount);
        }

        public String toString() {
            return String.format("%s(%d,%f,%d)", CountingEvictor.class.getName(), this.capacity_, this.loadFactor_, this.evictBeforeAddCount_);
        }
    }

    protected static abstract class ProtectedBuilder<B extends ProtectedBuilder<B>>
    extends RecencyEvictor.ProtectedBuilder<B> {
        public static final int DEFAULT_EVICT_BEFORE_ADD_COUNT = 3;
        protected int evictBeforeAddCount_ = 3;

        protected ProtectedBuilder() {
        }

        public B evictBeforeAddCount(int evictBeforeAddCount) throws IllegalArgumentException {
            if (0 > evictBeforeAddCount) {
                throw new IllegalArgumentException("Cannot add an element negative number of times!");
            }
            this.evictBeforeAddCount_ = evictBeforeAddCount;
            return (B)this.convertThis();
        }

        @Override
        public <E> Evictor<E> build() {
            return new CountingEvictor(this.capacity_, this.evictBeforeAddCount_, this.loadFactor_);
        }

        @Override
        protected abstract B convertThis();
    }

    private static class ElementRecord {
        public int addCount = 0;

        private ElementRecord() {
        }
    }
}

