/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

class LinearProbing {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;

    LinearProbing() {
    }

    static int getInitialCapacity(int capacity) {
        int result;
        if (capacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }
        if (capacity > 0x40000000) {
            capacity = 0x40000000;
        }
        for (result = 1; result < capacity; result <<= 1) {
        }
        return result;
    }

    static int getUpperSize(int capacity) {
        if (capacity > 64) {
            return (capacity >> 1) + (capacity >> 2);
        }
        return capacity;
    }

    static int getLowerSize(int capacity) {
        return capacity >> 2;
    }

    private static int getIndex(Object o, int length) {
        return o.hashCode() & length - 1;
    }

    static <E> int getPosition(E[] d, Object o) {
        int i = LinearProbing.getIndex(o, d.length);
        E probe;
        while ((probe = d[i]) != null && !o.equals(probe)) {
            if (++i != d.length) continue;
            i = 0;
        }
        return i;
    }

    static <E> void remove(E[] d, int pos) {
        int next;
        E moved;
        while ((moved = (d[pos] = d[next = LinearProbing.getMovedPosition(d, pos)])) != null) {
            pos = next;
        }
        return;
    }

    static <K, V> void remove(K[] k, V[] v, int pos) {
        while (true) {
            int next = LinearProbing.getMovedPosition(k, pos);
            K moved = k[pos] = k[next];
            v[pos] = v[next];
            if (moved == null) {
                return;
            }
            pos = next;
        }
    }

    static <E> int getMovedPosition(E[] d, int del) {
        int k;
        int j = del;
        do {
            E test;
            if (++j == d.length) {
                j = 0;
            }
            if ((test = d[j]) == null) {
                return j;
            }
            k = LinearProbing.getIndex(test, d.length);
        } while (del < j ? del < k && k <= j : del < k || k <= j);
        return j;
    }

    static <E> boolean contains(E[] d, Object o) {
        int pos = LinearProbing.getPosition(d, o);
        return d[pos] != null;
    }

    static <E> boolean add(E[] d, E e) {
        int pos = LinearProbing.getPosition(d, e);
        if (d[pos] == null) {
            d[pos] = e;
            return true;
        }
        return false;
    }

    static <E> boolean remove(E[] d, Object o) {
        int pos = LinearProbing.getPosition(d, o);
        if (d[pos] == null) {
            return false;
        }
        LinearProbing.remove(d, pos);
        return true;
    }
}

