/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.loading;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.semanticweb.elk.loading.AbstractAxiomLoader;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

public class Owl2ParserLoader
extends AbstractAxiomLoader
implements AxiomLoader {
    private static final ArrayList<ElkAxiom> POISON_BATCH_ = new ArrayList(1);
    private final Owl2Parser parser_;
    private final BlockingQueue<ArrayList<ElkAxiom>> axiomExchanger_;
    private final int batchLength_;
    private final Thread parserThread_;
    private boolean started_;
    private volatile boolean finished_;
    protected volatile ElkLoadingException exception;

    public Owl2ParserLoader(InterruptMonitor interrupter, Owl2Parser owlParser, int batchLength) {
        super(interrupter);
        this.parser_ = owlParser;
        this.axiomExchanger_ = new SynchronousQueue<ArrayList<ElkAxiom>>();
        this.batchLength_ = batchLength;
        this.finished_ = false;
        this.parserThread_ = new Thread((Runnable)new Parser(), "elk-parser-thread");
        this.parserThread_.setDaemon(true);
        this.started_ = false;
        this.exception = null;
    }

    public Owl2ParserLoader(InterruptMonitor interrupter, Owl2Parser owlParser) {
        this(interrupter, owlParser, 128);
    }

    @Override
    public synchronized void load(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) throws ElkLoadingException {
        if (this.finished_) {
            return;
        }
        if (!this.started_) {
            this.parserThread_.start();
            this.started_ = true;
        }
        while (!this.isInterrupted()) {
            ArrayList<ElkAxiom> nextBatch;
            try {
                nextBatch = this.axiomExchanger_.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            if (nextBatch == POISON_BATCH_) break;
            for (int i = 0; i < nextBatch.size(); ++i) {
                ElkAxiom axiom = nextBatch.get(i);
                axiomInserter.visit(axiom);
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    @Override
    public synchronized void dispose() {
        this.disposeParserResources();
        this.axiomExchanger_.clear();
    }

    @Override
    public boolean isLoadingFinished() {
        return this.finished_;
    }

    protected void disposeParserResources() {
    }

    private static class AxiomInserter
    implements Owl2ParserAxiomProcessor {
        private final BlockingQueue<ArrayList<ElkAxiom>> axiomBuffer_;
        private final int batchLength_;
        private ArrayList<ElkAxiom> nextBatch_;

        AxiomInserter(BlockingQueue<ArrayList<ElkAxiom>> axiomBuffer, int batchLength) {
            this.axiomBuffer_ = axiomBuffer;
            this.batchLength_ = batchLength;
            this.nextBatch_ = new ArrayList(this.batchLength_);
        }

        public void visit(ElkAxiom elkAxiom) throws Owl2ParseException {
            this.nextBatch_.add(elkAxiom);
            if (this.nextBatch_.size() == this.batchLength_) {
                this.submitBatch();
                this.nextBatch_ = new ArrayList(this.batchLength_);
            }
        }

        public void visit(ElkPrefix elkPrefix) throws Owl2ParseException {
        }

        public void finish() throws Owl2ParseException {
            this.submitBatch();
        }

        private void submitBatch() throws Owl2ParseException {
            try {
                this.axiomBuffer_.put(this.nextBatch_);
            }
            catch (InterruptedException e) {
                throw new Owl2ParseException("ELK Parser was interrupted", (Throwable)e);
            }
        }
    }

    private class Parser
    implements Runnable {
        private Parser() {
        }

        @Override
        public void run() {
            try {
                Owl2ParserLoader.this.parser_.accept((Owl2ParserAxiomProcessor)new AxiomInserter(Owl2ParserLoader.this.axiomExchanger_, Owl2ParserLoader.this.batchLength_));
            }
            catch (Throwable e) {
                Owl2ParserLoader.this.exception = new ElkLoadingException("Cannot load the ontology!", e);
            }
            finally {
                Owl2ParserLoader.this.finished_ = true;
                try {
                    Owl2ParserLoader.this.axiomExchanger_.put(POISON_BATCH_);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Owl2ParserLoader.this.disposeParserResources();
            }
        }
    }
}

