/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.loading;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.loading.Owl2ParserLoader;
import org.semanticweb.elk.owl.parsing.Owl2ParserFactory;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

public class Owl2StreamLoader
extends Owl2ParserLoader
implements AxiomLoader {
    private final InputStream stream_;

    private Owl2StreamLoader(InterruptMonitor interrupter, Owl2ParserFactory parserFactory, InputStream stream) {
        super(interrupter, parserFactory.getParser(stream));
        this.stream_ = stream;
    }

    @Override
    public void disposeParserResources() {
        super.disposeParserResources();
        try {
            this.stream_.close();
        }
        catch (IOException e) {
            this.exception = new ElkLoadingException("Cannot close the input stream!", e);
        }
    }

    public static class Factory
    implements AxiomLoader.Factory {
        private final Owl2ParserFactory parserFactory_;
        private final InputStream stream_;

        public Factory(Owl2ParserFactory parserFactory, InputStream stream) {
            this.parserFactory_ = parserFactory;
            this.stream_ = stream;
        }

        public Factory(Owl2ParserFactory parserFactory, File file) throws FileNotFoundException {
            this(parserFactory, new FileInputStream(file));
        }

        public Factory(Owl2ParserFactory parserFactory, String text) {
            this(parserFactory, new ByteArrayInputStream(text.getBytes()));
        }

        @Override
        public Owl2StreamLoader getAxiomLoader(InterruptMonitor interrupter) {
            return new Owl2StreamLoader(interrupter, this.parserFactory_, this.stream_);
        }
    }
}

