/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.reasoner.DummyProgressMonitor;
import org.semanticweb.elk.reasoner.ElkFreshEntitiesException;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.ReasonerInterrupter;
import org.semanticweb.elk.reasoner.completeness.IncompleteResult;
import org.semanticweb.elk.reasoner.completeness.Incompleteness;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.FreshInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.FreshTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.FreshTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentExecutor;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reasoner
extends AbstractReasonerState {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(Reasoner.class);
    private static final ConcurrentExecutor EXECUTOR_ = ConcurrentExecutors.create((String)"elk-reasoner");
    protected ProgressMonitor progressMonitor;
    private final ReasonerStageExecutor stageExecutor_;
    private final ReasonerInterrupter interrupter_;
    private int workerNo_;
    protected boolean allowFreshEntities;

    protected Reasoner(ElkObject.Factory elkFactory, ReasonerInterrupter interrupter, ReasonerStageExecutor stageExecutor, ReasonerConfiguration config) {
        super(elkFactory, config);
        this.stageExecutor_ = stageExecutor;
        this.interrupter_ = interrupter;
        this.progressMonitor = new DummyProgressMonitor();
        this.allowFreshEntities = true;
        this.setConfigurationOptions(config);
        LOGGER_.info("ELK reasoner was created");
    }

    public synchronized void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public synchronized void setAllowFreshEntities(boolean allow) {
        this.allowFreshEntities = allow;
    }

    public synchronized boolean getAllowFreshEntities() {
        return this.allowFreshEntities;
    }

    @Override
    protected synchronized int getNumberOfWorkers() {
        return this.workerNo_;
    }

    public synchronized void setNumberOfWorkers(int workerNo) {
        this.workerNo_ = workerNo;
    }

    public synchronized void setConfigurationOptions(ReasonerConfiguration config) {
        this.workerNo_ = config.getParameterAsInt("elk.reasoner.number_of_workers");
        this.setAllowIncrementalMode(config.getParameterAsBoolean("elk.reasoner.incremental.allowed"));
    }

    @Override
    protected ConcurrentExecutor getProcessExecutor() {
        return EXECUTOR_;
    }

    @Override
    protected ReasonerStageExecutor getStageExecutor() {
        return this.stageExecutor_;
    }

    @Override
    protected ReasonerInterrupter getInterrupter() {
        return this.interrupter_;
    }

    @Override
    protected synchronized ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public synchronized boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        boolean success = true;
        if (success) {
            LOGGER_.info("ELK reasoner has shut down");
        } else {
            LOGGER_.error("ELK reasoner failed to shut down!");
        }
        return success;
    }

    public synchronized boolean shutdown() throws InterruptedException {
        return this.shutdown(1L, TimeUnit.MINUTES);
    }

    protected IncompleteResult<? extends TaxonomyNode<ElkClass>> getTaxonomyNode(ElkClass elkClass) throws ElkException {
        return this.getTaxonomy().map(taxonomy -> {
            TaxonomyNode<ElkClass> node = taxonomy.getNode(elkClass);
            if (node != null) {
                return node;
            }
            if (this.allowFreshEntities) {
                return new FreshTaxonomyNode<ElkClass>(elkClass, (Taxonomy<ElkClass>)taxonomy);
            }
            throw new ElkFreshEntitiesException((ElkEntity)elkClass);
        });
    }

    protected IncompleteResult<? extends InstanceNode<ElkClass, ElkNamedIndividual>> getInstanceNode(ElkNamedIndividual elkNamedIndividual) throws ElkException {
        return this.getInstanceTaxonomy().map(tax -> {
            InstanceNode node = tax.getInstanceNode(elkNamedIndividual);
            if (node != null) {
                return node;
            }
            if (this.allowFreshEntities) {
                return new FreshInstanceNode(elkNamedIndividual, tax);
            }
            throw new ElkFreshEntitiesException((ElkEntity)elkNamedIndividual);
        });
    }

    protected IncompleteResult<? extends TypeNode<ElkClass, ElkNamedIndividual>> getTypeNode(ElkClass elkClass) throws ElkException {
        return this.getInstanceTaxonomy().map(tax -> {
            TaxonomyNode node = tax.getNode((ElkEntity)elkClass);
            if (node != null) {
                return node;
            }
            if (this.allowFreshEntities) {
                return new FreshTypeNode(elkClass, tax);
            }
            throw new ElkFreshEntitiesException((ElkEntity)elkClass);
        });
    }

    protected IncompleteResult<? extends TaxonomyNode<ElkObjectProperty>> getObjectPropertyTaxonomyNode(ElkObjectProperty elkProperty) throws ElkException {
        return this.getObjectPropertyTaxonomy().map(tax -> {
            TaxonomyNode<ElkObjectProperty> node = tax.getNode(elkProperty);
            if (node != null) {
                return node;
            }
            if (this.allowFreshEntities) {
                return new FreshTaxonomyNode<ElkObjectProperty>(elkProperty, (Taxonomy<ElkObjectProperty>)tax);
            }
            throw new ElkFreshEntitiesException((ElkEntity)elkProperty);
        });
    }

    public synchronized IncompleteResult<? extends TaxonomyNode<ElkObjectProperty>> getObjectPropertyNode(ElkObjectProperty property) throws ElkException {
        return this.getObjectPropertyTaxonomyNode(property);
    }

    public synchronized IncompleteResult<? extends Node<ElkClass>> getEquivalentClasses(ElkClassExpression classExpression) throws ElkInconsistentOntologyException, ElkException {
        if (classExpression instanceof ElkClass) {
            return this.getTaxonomyNode((ElkClass)classExpression);
        }
        return this.queryEquivalentClasses(classExpression);
    }

    public synchronized IncompleteResult<? extends Node<ElkClass>> getEquivalentClassesQuitely(ElkClassExpression classExpression) throws ElkException {
        try {
            return this.getEquivalentClasses(classExpression);
        }
        catch (ElkInconsistentOntologyException e) {
            return this.getTaxonomyQuietly().map(tax -> tax.getBottomNode());
        }
    }

    public synchronized IncompleteResult<? extends Node<ElkClass>> getEquivalentClassesQuietly(ElkClassExpression classExpression) throws ElkException {
        try {
            return this.getEquivalentClasses(classExpression);
        }
        catch (ElkInconsistentOntologyException e) {
            return this.getTaxonomyQuietly().map(Taxonomy::getBottomNode);
        }
    }

    public synchronized IncompleteResult<? extends Set<? extends Node<ElkClass>>> getSubClasses(ElkClassExpression classExpression, boolean direct) throws ElkInconsistentOntologyException, ElkException {
        if (classExpression instanceof ElkClass) {
            return this.getTaxonomyNode((ElkClass)classExpression).map(node -> direct ? node.getDirectSubNodes() : node.getAllSubNodes());
        }
        IncompleteResult<? extends Set<? extends Node<ElkClass>>> incompleteDirectSubNodes = this.queryDirectSubClasses(classExpression);
        if (direct) {
            return incompleteDirectSubNodes;
        }
        return Incompleteness.compose(this.getTaxonomy(), incompleteDirectSubNodes, (taxonomy, subNodes) -> subNodes.stream().map(n -> taxonomy.getNode((ElkEntity)n.getCanonicalMember())).flatMap(n -> n.getAllSubNodes().stream()).collect(Collectors.toSet()));
    }

    public synchronized IncompleteResult<? extends Set<? extends Node<ElkClass>>> getSubClassesQuietly(ElkClassExpression classExpression, boolean direct) throws ElkException {
        try {
            return this.getSubClasses(classExpression, direct);
        }
        catch (ElkInconsistentOntologyException e) {
            return this.getTaxonomyQuietly().map(tax -> {
                TaxonomyNode node = tax.getBottomNode();
                return direct ? node.getDirectSubNodes() : node.getAllSubNodes();
            });
        }
    }

    public synchronized IncompleteResult<? extends Set<? extends Node<ElkClass>>> getSuperClasses(ElkClassExpression classExpression, boolean direct) throws ElkInconsistentOntologyException, ElkException {
        if (classExpression instanceof ElkClass) {
            return this.getTaxonomyNode((ElkClass)classExpression).map(n -> direct ? n.getDirectSuperNodes() : n.getAllSuperNodes());
        }
        IncompleteResult<? extends Set<? extends Node<ElkClass>>> incompleteSuperNodes = this.queryDirectSuperClasses(classExpression);
        if (direct) {
            return incompleteSuperNodes;
        }
        return Incompleteness.compose(this.getTaxonomy(), incompleteSuperNodes, (taxonomy, superNodes) -> superNodes.stream().map(n -> taxonomy.getNode((ElkEntity)n.getCanonicalMember())).flatMap(n -> n.getAllSuperNodes().stream()).collect(Collectors.toSet()));
    }

    public synchronized IncompleteResult<? extends Set<? extends Node<ElkClass>>> getSuperClassesQuietly(ElkClassExpression classExpression, boolean direct) throws ElkException {
        try {
            return this.getSuperClasses(classExpression, direct);
        }
        catch (ElkInconsistentOntologyException e) {
            return this.getTaxonomyQuietly().map(tax -> direct ? tax.getBottomNode().getDirectSuperNodes() : tax.getBottomNode().getAllSuperNodes());
        }
    }

    public synchronized IncompleteResult<? extends Set<? extends Node<ElkObjectProperty>>> getSubObjectProperties(ElkObjectProperty property, boolean direct) throws ElkException {
        return this.getObjectPropertyNode(property).map(queryNode -> direct ? queryNode.getDirectSubNodes() : queryNode.getAllSubNodes());
    }

    public synchronized IncompleteResult<? extends Set<? extends Node<ElkObjectProperty>>> getSuperObjectProperties(ElkObjectProperty property, boolean direct) throws ElkException {
        return this.getObjectPropertyNode(property).map(queryNode -> direct ? queryNode.getDirectSuperNodes() : queryNode.getAllSuperNodes());
    }

    public synchronized IncompleteResult<? extends Set<? extends Node<ElkNamedIndividual>>> getInstances(ElkClassExpression classExpression, boolean direct) throws ElkInconsistentOntologyException, ElkException {
        if (classExpression instanceof ElkClass) {
            return this.getTypeNode((ElkClass)classExpression).map(queryNode -> direct ? queryNode.getDirectInstanceNodes() : queryNode.getAllInstanceNodes());
        }
        IncompleteResult<? extends Set<? extends Node<ElkNamedIndividual>>> incompleteInstances = this.queryDirectInstances(classExpression);
        if (direct) {
            return incompleteInstances;
        }
        IncompleteResult<? extends InstanceTaxonomy<ElkClass, ElkNamedIndividual>> incompleteTaxonomy = this.getInstanceTaxonomy();
        IncompleteResult<? extends Set<? extends Node<ElkClass>>> incompleteSubNodes = this.queryDirectSubClasses(classExpression);
        return Incompleteness.compose(incompleteTaxonomy, incompleteSubNodes, incompleteInstances, (taxonomy, subNodes, instances) -> Stream.concat(instances.stream(), subNodes.stream().map(n -> taxonomy.getNode((ElkEntity)n.getCanonicalMember())).flatMap(n -> n.getAllInstanceNodes().stream())).collect(Collectors.toSet()));
    }

    public synchronized IncompleteResult<? extends Set<? extends Node<ElkNamedIndividual>>> getInstancesQuietly(ElkClassExpression classExpression, boolean direct) throws ElkException {
        try {
            return this.getInstances(classExpression, direct);
        }
        catch (ElkInconsistentOntologyException e) {
            return this.getInstanceTaxonomyQuietly().map(tax -> tax.getInstanceNodes());
        }
    }

    public synchronized IncompleteResult<? extends Set<? extends Node<ElkClass>>> getTypes(ElkNamedIndividual elkNamedIndividual, boolean direct) throws ElkException {
        return this.getInstanceNode(elkNamedIndividual).map(node -> direct ? node.getDirectTypeNodes() : node.getAllTypeNodes());
    }

    public synchronized IncompleteResult<? extends Boolean> isSatisfiable(ElkClassExpression classExpression) throws ElkInconsistentOntologyException, ElkException {
        if (classExpression instanceof ElkClass) {
            return this.getTaxonomyNode((ElkClass)classExpression).map(queryNode -> !queryNode.contains(this.getElkFactory().getOwlNothing()));
        }
        return this.querySatisfiability(classExpression);
    }

    public synchronized IncompleteResult<? extends Boolean> isSatisfiableQuitely(ElkClassExpression classExpression) throws ElkInconsistentOntologyException, ElkException {
        try {
            return this.isSatisfiable(classExpression);
        }
        catch (ElkInconsistentOntologyException e) {
            return new IncompleteResult<Boolean>(false, Incompleteness.getNoIncompletenessMonitor());
        }
    }

    public synchronized IncompleteResult<? extends Boolean> isSatisfiableQuietly(ElkClassExpression classExpression) throws ElkException {
        try {
            return this.isSatisfiable(classExpression);
        }
        catch (ElkInconsistentOntologyException e) {
            return new IncompleteResult<Boolean>(false, Incompleteness.getNoIncompletenessMonitor());
        }
    }
}

