/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import java.util.Collection;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.slf4j.Logger;

public class FirstOfIncompletenessMonitor
implements IncompletenessMonitor {
    private final IncompletenessMonitor[] monitors_;

    FirstOfIncompletenessMonitor(IncompletenessMonitor ... monitors) {
        this.monitors_ = monitors;
    }

    FirstOfIncompletenessMonitor(Collection<IncompletenessMonitor> monitors) {
        this(monitors.toArray(new IncompletenessMonitor[0]));
    }

    @Override
    public boolean isIncompletenessDetected() {
        for (IncompletenessMonitor monitor : this.monitors_) {
            if (!monitor.isIncompletenessDetected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStatusChanged(Logger logger) {
        for (IncompletenessMonitor monitor : this.monitors_) {
            if (monitor.isStatusChanged(logger)) {
                return true;
            }
            if (!monitor.isIncompletenessDetected()) continue;
            return false;
        }
        return false;
    }

    @Override
    public void logStatus(Logger logger) {
        for (IncompletenessMonitor monitor : this.monitors_) {
            monitor.logStatus(logger);
            if (!monitor.isIncompletenessDetected()) continue;
            return;
        }
    }
}

