/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import java.util.Collection;
import org.semanticweb.elk.reasoner.completeness.FirstOfIncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompleteResult;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.NoIncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.SomeOfIncompletenessMonitor;
import org.semanticweb.elk.reasoner.query.ElkQueryException;
import org.semanticweb.elk.reasoner.query.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Incompleteness {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(Incompleteness.class);

    public static IncompletenessMonitor getNoIncompletenessMonitor() {
        return NoIncompletenessMonitor.INSTNANCE;
    }

    public static IncompletenessMonitor someOf(IncompletenessMonitor ... monitors) {
        return new SomeOfIncompletenessMonitor(monitors);
    }

    public static IncompletenessMonitor someOf(Collection<IncompletenessMonitor> monitors) {
        return new SomeOfIncompletenessMonitor(monitors);
    }

    public static IncompletenessMonitor firstOf(IncompletenessMonitor ... monitors) {
        return new FirstOfIncompletenessMonitor(monitors);
    }

    public static IncompletenessMonitor firstOf(Collection<IncompletenessMonitor> monitors) {
        return new FirstOfIncompletenessMonitor(monitors);
    }

    public static <RA, RB, O, E extends Throwable> IncompleteResult<O> compose(IncompleteResult<? extends RA> first, IncompleteResult<? extends RB> second, CheckedBiFunction<RA, RB, O, E> fn) throws E {
        return new IncompleteResult<O>(fn.apply(first.getValue(), second.getValue()), Incompleteness.firstOf(first.getIncompletenessMonitor(), second.getIncompletenessMonitor()));
    }

    public static <RA, RB, RC, O, E extends Throwable> IncompleteResult<O> compose(IncompleteResult<? extends RA> first, IncompleteResult<? extends RB> second, IncompleteResult<? extends RC> third, CheckedTriFunction<RA, RB, RC, O, E> fn) throws E {
        return new IncompleteResult<O>(fn.apply(first.getValue(), second.getValue(), third.getValue()), Incompleteness.firstOf(first.getIncompletenessMonitor(), second.getIncompletenessMonitor(), third.getIncompletenessMonitor()));
    }

    public static <R> R getValue(IncompleteResult<? extends R> result) {
        result.getIncompletenessMonitor().logStatus(LOGGER_);
        return result.getValue();
    }

    public static boolean getValue(QueryResult result) throws ElkQueryException {
        result.getIncompletenessMonitor().logStatus(LOGGER_);
        return result.entailmentProved();
    }

    @FunctionalInterface
    public static interface CheckedTriFunction<I, J, K, O, E extends Throwable> {
        public O apply(I var1, J var2, K var3) throws E;
    }

    @FunctionalInterface
    public static interface CheckedBiFunction<I, J, O, E extends Throwable> {
        public O apply(I var1, J var2) throws E;
    }
}

