/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import org.semanticweb.elk.reasoner.completeness.DelegatingOccurrenceManager;
import org.semanticweb.elk.reasoner.completeness.Feature;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.OccurrenceManager;
import org.slf4j.Logger;

class IncompletenessDueToUnsupportedFeatures
extends DelegatingOccurrenceManager
implements IncompletenessMonitor {
    private final Feature[] unsupportedFeatures_;
    private String description_;
    boolean wasIncomplete_ = false;

    IncompletenessDueToUnsupportedFeatures(OccurrenceManager occurrences, Feature ... unsupportedOccurrences) {
        super(occurrences);
        this.unsupportedFeatures_ = unsupportedOccurrences;
    }

    @Override
    public boolean isIncompletenessDetected() {
        for (Feature occurrence : this.unsupportedFeatures_) {
            if (this.getOccurrenceCount(occurrence) > 0) continue;
            return false;
        }
        return true;
    }

    String getDescription() {
        if (this.description_ == null) {
            StringBuilder descriptionBuilder = new StringBuilder();
            descriptionBuilder.append("Potential incompleteness due to ");
            for (int i = 0; i < this.unsupportedFeatures_.length; ++i) {
                if (i > 0) {
                    descriptionBuilder.append(" and ");
                }
                descriptionBuilder.append((Object)this.unsupportedFeatures_[i]);
            }
            this.description_ = descriptionBuilder.toString();
        }
        return this.description_;
    }

    @Override
    public boolean isStatusChanged(Logger logger) {
        return logger.isInfoEnabled() && this.isIncompletenessDetected() != this.wasIncomplete_;
    }

    @Override
    public void logStatus(Logger logger) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        boolean isIncomplete = this.isIncompletenessDetected();
        if (this.wasIncomplete_ == isIncomplete) {
            return;
        }
        this.wasIncomplete_ = isIncomplete;
        logger.info((isIncomplete ? "" : "[FIXED] ") + this.getDescription());
        if (isIncomplete) {
            for (Feature occurrence : this.unsupportedFeatures_) {
                super.logOccurrences(occurrence, logger);
            }
        }
    }
}

