/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import org.semanticweb.elk.reasoner.completeness.DelegatingIncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.slf4j.Logger;

public class IncompletenessStatusMonitor
extends DelegatingIncompletenessMonitor {
    private final String statusMessage_;
    private boolean isIncompletenessDetected_ = false;

    public IncompletenessStatusMonitor(IncompletenessMonitor delegate, String statusMessage) {
        super(delegate);
        this.statusMessage_ = statusMessage;
    }

    @Override
    public boolean isStatusChanged(Logger logger) {
        return logger.isWarnEnabled() && (this.isIncompletenessDetected_ != this.isIncompletenessDetected() || super.isStatusChanged(logger));
    }

    @Override
    public void logStatus(Logger logger) {
        if (!logger.isWarnEnabled()) {
            return;
        }
        boolean isIncompletenessDetected = this.isIncompletenessDetected();
        if (this.isIncompletenessDetected_ == isIncompletenessDetected && !super.isStatusChanged(logger)) {
            return;
        }
        this.isIncompletenessDetected_ = isIncompletenessDetected;
        if (this.isIncompletenessDetected_) {
            logger.warn(this.statusMessage_);
        } else {
            logger.warn("[Fixed] " + this.statusMessage_);
        }
        super.logStatus(logger);
    }
}

