/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import java.util.Collection;
import org.semanticweb.elk.reasoner.completeness.Feature;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToUnsupportedFeatures;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.OccurrenceManager;

class ObjectPropertyTaxonomyIncompleteness {
    private static final Feature[] UNSUPPORTED_FEATURES_ = new Feature[]{Feature.OWL_NOTHING_POSITIVE, Feature.DISJOINT_CLASSES, Feature.OBJECT_COMPLEMENT_OF_POSITIVE};
    private static final Feature[][] UNSUPPORTED_COMBINATIONS_OF_FEATURES_ = new Feature[][]{{Feature.REFLEXIVE_OBJECT_PROPERTY, Feature.OBJECT_PROPERTY_CHAIN}};

    ObjectPropertyTaxonomyIncompleteness() {
    }

    static Collection<IncompletenessMonitor> appendMonitorsTo(Collection<IncompletenessMonitor> monitors, OccurrenceManager occurrencesInOntology) {
        for (Feature feature : UNSUPPORTED_FEATURES_) {
            monitors.add(new IncompletenessDueToUnsupportedFeatures(occurrencesInOntology, feature));
        }
        for (Feature feature : UNSUPPORTED_COMBINATIONS_OF_FEATURES_) {
            monitors.add(new IncompletenessDueToUnsupportedFeatures(occurrencesInOntology, (Feature[])feature));
        }
        return monitors;
    }
}

