/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.reasoner.completeness.Feature;
import org.semanticweb.elk.reasoner.completeness.OccurrenceListener;
import org.semanticweb.elk.reasoner.completeness.OccurrenceManager;
import org.semanticweb.elk.reasoner.completeness.OccurrenceRegistry;
import org.slf4j.Logger;

public class OccurrencesInOntology
implements ElkAxiomProcessor,
OccurrenceListener,
OccurrenceManager {
    private static int DEFAULT_RECENT_OCCURRENCE_LIMIT_ = 3;
    private final OccurrenceRegistry occurrenceRegistry_ = new OccurrenceRegistry();
    private final Map<Feature, Set<ElkAxiom>> recentOccurrences_ = new EnumMap<Feature, Set<ElkAxiom>>(Feature.class);
    private final int recentOccurrenceLimit_;
    private ElkAxiom currentAxiom_;

    public OccurrencesInOntology() {
        this(DEFAULT_RECENT_OCCURRENCE_LIMIT_);
    }

    OccurrencesInOntology(int recentOccurrenceLimit) {
        this.recentOccurrenceLimit_ = recentOccurrenceLimit;
    }

    public void visit(ElkAxiom elkAxiom) {
        this.currentAxiom_ = elkAxiom;
    }

    @Override
    public void occurrenceChanged(Feature occurrence, int increment) {
        this.occurrenceRegistry_.occurrenceChanged(occurrence, increment);
        Set<ElkAxiom> recent = this.recentOccurrences_.get((Object)occurrence);
        if (recent == null) {
            recent = new LinkedHashSet<ElkAxiom>(this.recentOccurrenceLimit_);
            this.recentOccurrences_.put(occurrence, recent);
        }
        if (increment > 0) {
            recent.add(this.currentAxiom_);
            if (recent.size() > this.recentOccurrenceLimit_) {
                Iterator<ElkAxiom> i = recent.iterator();
                i.next();
                i.remove();
            }
        } else {
            recent.remove(this.currentAxiom_);
            if (recent.isEmpty()) {
                this.recentOccurrences_.remove((Object)occurrence);
            }
        }
    }

    @Override
    public int getOccurrenceCount(Feature occurrence) {
        return this.occurrenceRegistry_.getOccurrenceCount(occurrence);
    }

    Set<ElkAxiom> getRecentOccurrences(Feature occurrence) {
        Set<ElkAxiom> result = this.recentOccurrences_.get((Object)occurrence);
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public void logOccurrences(Feature occurrence, Logger logger) {
        int count = this.getOccurrenceCount(occurrence);
        if (count == 0) {
            return;
        }
        String occurrencesString = count == 1 ? "occurrence" : "occurrences";
        String polarityString = "";
        switch (occurrence.getPolarity()) {
            case POSITIVE: {
                polarityString = "positive ";
                break;
            }
            case NEGATIVE: {
                polarityString = "negative ";
            }
        }
        logger.info("{} {}{} of {} found in the current ontology. Enable DEBUG for details", new Object[]{count, polarityString, occurrencesString, occurrence.getConstructor()});
        if (logger.isDebugEnabled()) {
            Set<ElkAxiom> axioms = this.getRecentOccurrences(occurrence);
            for (ElkAxiom axiom : axioms) {
                logger.debug(OwlFunctionalStylePrinter.toString((ElkObject)axiom));
            }
            if (count > axioms.size()) {
                logger.debug("...");
            }
        }
        this.recentOccurrences_.remove((Object)occurrence);
    }

    @Override
    public boolean hasNewOccurrencesOf(Feature occurrence) {
        return !this.getRecentOccurrences(occurrence).isEmpty();
    }
}

