/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.entailments.impl;

import java.util.Iterator;
import java.util.List;
import org.semanticweb.elk.reasoner.entailments.DefaultEntailmentInferenceVisitor;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.entailments.model.HasReason;

public class EntailmentInferencePrinter
extends DefaultEntailmentInferenceVisitor<String> {
    public static final EntailmentInferencePrinter INSTANCE = new EntailmentInferencePrinter();

    public static String toString(EntailmentInference entailmentInference) {
        return entailmentInference.accept(INSTANCE);
    }

    private EntailmentInferencePrinter() {
    }

    @Override
    protected String defaultVisit(EntailmentInference entailmentInference) {
        StringBuilder result = new StringBuilder(((Entailment)entailmentInference.getConclusion()).toString());
        result.append(" -| ");
        List premises = entailmentInference.getPremises();
        Iterator iter = premises.iterator();
        if (iter.hasNext()) {
            result.append(((Entailment)iter.next()).toString());
        }
        while (iter.hasNext()) {
            result.append("; ").append(((Entailment)iter.next()).toString());
        }
        if (entailmentInference instanceof HasReason) {
            if (!premises.isEmpty()) {
                result.append("; ");
            }
            result.append(((HasReason)((Object)entailmentInference)).getReason().toString());
        }
        return result.toString();
    }
}

