/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.reasoner.completeness.OccurrenceListener;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkAxiomConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingUnsupportedFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeIndexingProcessor
implements ElkAxiomProcessor {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ChangeIndexingProcessor.class);
    private final ElkAxiomConverter indexer_;
    private final int increment_;
    private final OccurrenceListener occurrenceTracker_;

    public ChangeIndexingProcessor(ElkAxiomConverter indexer, int increment, OccurrenceListener indexingListener) {
        this.indexer_ = indexer;
        this.increment_ = increment;
        this.occurrenceTracker_ = indexingListener;
    }

    public void visit(ElkAxiom elkAxiom) {
        try {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("$$ indexing " + OwlFunctionalStylePrinter.toString((ElkObject)elkAxiom) + " for " + (this.increment_ > 0 ? "addition" : "deletion"));
            }
            elkAxiom.accept((ElkAxiomVisitor)this.indexer_);
        }
        catch (ElkIndexingUnsupportedFeature e) {
            this.occurrenceTracker_.occurrenceChanged(e.getFeature(), this.increment_);
        }
    }
}

