/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionProcessor;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.reasoner.completeness.OccurrenceListener;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingUnsupportedFeature;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassQueryIndexingProcessor
implements ElkClassExpressionProcessor {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ClassQueryIndexingProcessor.class);
    private final ElkPolarityExpressionConverter indexer_;
    private final int increment_;
    private final OccurrenceListener occurrenceTracker_;

    public ClassQueryIndexingProcessor(ElkPolarityExpressionConverter indexer, int increment, OccurrenceListener indexingListener) {
        this.indexer_ = indexer;
        this.increment_ = increment;
        this.occurrenceTracker_ = indexingListener;
    }

    public void visit(ElkClassExpression elkClassExpression) {
        try {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("$$ indexing {} for {}", (Object)OwlFunctionalStylePrinter.toString((ElkObject)elkClassExpression), (Object)(this.increment_ > 0 ? "addition" : "deletion"));
            }
            elkClassExpression.accept((ElkClassExpressionVisitor)this.indexer_);
        }
        catch (ElkIndexingUnsupportedFeature e) {
            this.occurrenceTracker_.occurrenceChanged(e.getFeature(), this.increment_);
        }
    }
}

