/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.predefined.PredefinedElkIris;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpressionList;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedDataHasValue;
import org.semanticweb.elk.reasoner.indexing.model.IndexedDeclarationAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedDefinedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedDisjointClassesAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedEquivalentClassesAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectComplementOf;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectHasSelf;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectPropertyRangeAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectUnionOf;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPredefinedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedRangeFiller;
import org.semanticweb.elk.reasoner.indexing.model.IndexedSubClassOfAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedSubObjectPropertyOfAxiom;

public class IndexedObjectPrinter
implements IndexedObject.Visitor<String> {
    private static IndexedObjectPrinter INSTANCE_ = new IndexedObjectPrinter();

    static IndexedObject.Visitor<String> getPrinterVisitor() {
        return INSTANCE_;
    }

    public static String toString(IndexedObject element) {
        return element.accept(INSTANCE_);
    }

    private IndexedObjectPrinter() {
    }

    @Override
    public String visit(IndexedDefinedClass element) {
        return element.getElkEntity().toString();
    }

    @Override
    public String visit(IndexedPredefinedClass element) {
        ElkClass entity = element.getElkEntity();
        if (PredefinedElkIris.OWL_THING.equals((Object)entity.getIri())) {
            return "\u22a4";
        }
        if (PredefinedElkIris.OWL_NOTHING.equals((Object)entity.getIri())) {
            return "\u22a5";
        }
        return entity.toString();
    }

    @Override
    public String visit(IndexedClassExpressionList element) {
        return element.getElements().toString();
    }

    @Override
    public String visit(IndexedComplexPropertyChain element) {
        return element.getFirstProperty() + "\u2218" + element.getSuffixChain();
    }

    @Override
    public String visit(IndexedDataHasValue element) {
        return "\u2203" + element.getRelation() + '.' + element.getFiller();
    }

    @Override
    public String visit(IndexedDeclarationAxiom axiom) {
        return axiom.getEntity().getElkEntity().getEntityType() + "(" + axiom.getEntity() + ")";
    }

    @Override
    public String visit(IndexedEquivalentClassesAxiom axiom) {
        return axiom.getFirstMember() + " = " + axiom.getSecondMember();
    }

    @Override
    public String visit(IndexedDisjointClassesAxiom axiom) {
        return "Disjoint(" + axiom.getMembers() + ")";
    }

    @Override
    public String visit(IndexedIndividual element) {
        return "{" + element.getElkEntity() + "}";
    }

    @Override
    public String visit(IndexedObjectComplementOf element) {
        return "\u00ac" + element.getNegated();
    }

    @Override
    public String visit(IndexedObjectHasSelf element) {
        return "\u2203" + element.getProperty() + ".Self";
    }

    @Override
    public String visit(IndexedObjectIntersectionOf element) {
        return element.getFirstConjunct() + " \u2293 " + element.getSecondConjunct();
    }

    @Override
    public String visit(IndexedObjectProperty element) {
        return element.getElkEntity().getIri().toString();
    }

    @Override
    public String visit(IndexedObjectPropertyRangeAxiom axiom) {
        return "Range(" + axiom.getProperty() + ' ' + axiom.getRange() + ')';
    }

    @Override
    public String visit(IndexedObjectSomeValuesFrom element) {
        return "\u2203" + element.getProperty() + '.' + element.getFiller();
    }

    @Override
    public String visit(IndexedObjectUnionOf element) {
        return "ObjectUnionOf(" + element.getDisjuncts() + ')';
    }

    @Override
    public String visit(IndexedRangeFiller element) {
        return element.getFiller() + " \u2293 \u2203" + element.getProperty() + "-.\u22a4";
    }

    @Override
    public String visit(IndexedSubClassOfAxiom axiom) {
        return axiom.getSubClass() + " \u2291 " + axiom.getSuperClass();
    }

    @Override
    public String visit(IndexedSubObjectPropertyOfAxiom axiom) {
        return axiom.getSubPropertyChain() + " \u2291 " + axiom.getSuperProperty();
    }
}

