/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.elk.owl.predefined.PredefinedElkEntityFactory;
import org.semanticweb.elk.reasoner.indexing.classes.ModifiableIndexedOwlNothingImpl;
import org.semanticweb.elk.reasoner.indexing.classes.ModifiableIndexedOwlThingImpl;
import org.semanticweb.elk.reasoner.indexing.classes.OwlBottomObjectPropertyImpl;
import org.semanticweb.elk.reasoner.indexing.classes.OwlTopObjectPropertyImpl;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpressionList;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedDataHasValue;
import org.semanticweb.elk.reasoner.indexing.model.IndexedDefinedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectCache;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectComplementOf;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectHasSelf;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectUnionOf;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPredefinedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedSubObject;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObjectCache;
import org.semanticweb.elk.reasoner.indexing.model.StructuralIndexedClassEntry;
import org.semanticweb.elk.reasoner.indexing.model.StructuralIndexedClassExpressionListEntry;
import org.semanticweb.elk.reasoner.indexing.model.StructuralIndexedComplexClassExpressionEntry;
import org.semanticweb.elk.reasoner.indexing.model.StructuralIndexedComplexPropertyChainEntry;
import org.semanticweb.elk.reasoner.indexing.model.StructuralIndexedIndividualEntry;
import org.semanticweb.elk.reasoner.indexing.model.StructuralIndexedObjectPropertyEntry;
import org.semanticweb.elk.reasoner.indexing.model.StructuralIndexedSubObject;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.collections.entryset.EntryCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModifiableIndexedObjectCacheImpl
implements ModifiableIndexedObjectCache {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ModifiableIndexedObjectCacheImpl.class);
    private final EntryCollection<StructuralIndexedComplexClassExpressionEntry<?>> cachedComplexClassExpressions_;
    private final EntryCollection<StructuralIndexedComplexPropertyChainEntry<?>> cachedComplexPropertyChains_;
    private final EntryCollection<StructuralIndexedClassExpressionListEntry<?>> cachedClassExpressionLists_;
    private final EntryCollection<StructuralIndexedClassEntry<?>> cachedClasses_;
    private final EntryCollection<StructuralIndexedObjectPropertyEntry<?>> cachedObjectProperties_;
    private final EntryCollection<StructuralIndexedIndividualEntry<?>> cachedIndividuals_;
    private final StructuralIndexedClassEntry<?> owlThing_;
    private final StructuralIndexedClassEntry<?> owlNothing_;
    private final StructuralIndexedObjectPropertyEntry<?> owlTopObjectProperty_;
    private final StructuralIndexedObjectPropertyEntry<?> owlBottomObjectProperty_;
    private final List<IndexedObjectCache.ChangeListener> listeners_;

    public ModifiableIndexedObjectCacheImpl(PredefinedElkEntityFactory elkFactory, int initialSize) {
        this.cachedComplexClassExpressions_ = new EntryCollection(initialSize);
        this.cachedComplexPropertyChains_ = new EntryCollection(initialSize);
        this.cachedClassExpressionLists_ = new EntryCollection(initialSize);
        this.cachedClasses_ = new EntryCollection(initialSize);
        this.cachedObjectProperties_ = new EntryCollection(initialSize);
        this.cachedIndividuals_ = new EntryCollection(initialSize);
        this.owlThing_ = new ModifiableIndexedOwlThingImpl(elkFactory.getOwlThing());
        this.owlNothing_ = new ModifiableIndexedOwlNothingImpl(elkFactory.getOwlNothing());
        this.owlTopObjectProperty_ = new OwlTopObjectPropertyImpl(elkFactory.getOwlTopObjectProperty());
        this.owlBottomObjectProperty_ = new OwlBottomObjectPropertyImpl(elkFactory.getOwlBottomObjectProperty());
        this.listeners_ = new ArrayList<IndexedObjectCache.ChangeListener>();
        this.add(this.owlThing_);
        this.add(this.owlNothing_);
        this.add(this.owlTopObjectProperty_);
        this.add(this.owlBottomObjectProperty_);
    }

    public ModifiableIndexedObjectCacheImpl(PredefinedElkEntityFactory elkFactory) {
        this(elkFactory, 1024);
    }

    @Override
    public final Collection<? extends IndexedClass> getClasses() {
        return this.cachedClasses_;
    }

    @Override
    public final Collection<? extends IndexedIndividual> getIndividuals() {
        return this.cachedIndividuals_;
    }

    @Override
    public final Collection<? extends IndexedObjectProperty> getObjectProperties() {
        return this.cachedObjectProperties_;
    }

    @Override
    public final Collection<? extends IndexedClassExpression> getClassExpressions() {
        return Operations.getCollection((Iterable)Operations.concat((Iterable[])new Iterable[]{this.cachedClasses_, this.cachedIndividuals_, this.cachedComplexClassExpressions_}), (int)(this.cachedClasses_.size() + this.cachedIndividuals_.size() + this.cachedComplexClassExpressions_.size()));
    }

    @Override
    public final Collection<? extends IndexedPropertyChain> getPropertyChains() {
        return Operations.getCollection((Iterable)Operations.concat((Iterable[])new Iterable[]{this.cachedObjectProperties_, this.cachedComplexPropertyChains_}), (int)(this.cachedObjectProperties_.size() + this.cachedComplexPropertyChains_.size()));
    }

    @Override
    public final StructuralIndexedClassEntry<?> getOwlThing() {
        return this.owlThing_;
    }

    @Override
    public final StructuralIndexedClassEntry<?> getOwlNothing() {
        return this.owlNothing_;
    }

    @Override
    public StructuralIndexedObjectPropertyEntry<?> getOwlTopObjectProperty() {
        return this.owlTopObjectProperty_;
    }

    @Override
    public StructuralIndexedObjectPropertyEntry<?> getOwlBottomObjectProperty() {
        return this.owlBottomObjectProperty_;
    }

    @Override
    public void add(StructuralIndexedSubObject<?> input) {
        LOGGER_.trace("{}: adding to cache", input);
        input.accept(new StructuralIndexedSubObject.Visitor<Void>(){

            @Override
            public <T extends StructuralIndexedClassEntry<T>> Void visit(T element) {
                ModifiableIndexedObjectCacheImpl.this.cachedClasses_.addStructural(element);
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                    listener.classAddition(element);
                    listener.classExpressionAddition(element);
                }
                return null;
            }

            @Override
            public <T extends StructuralIndexedComplexClassExpressionEntry<T>> Void visit(T element) {
                ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_.addStructural(element);
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    ((IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i)).classExpressionAddition(element);
                }
                return null;
            }

            @Override
            public <T extends StructuralIndexedIndividualEntry<T>> Void visit(T element) {
                ModifiableIndexedObjectCacheImpl.this.cachedIndividuals_.addStructural(element);
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                    listener.individualAddition(element);
                    listener.classExpressionAddition(element);
                }
                return null;
            }

            @Override
            public <T extends StructuralIndexedClassExpressionListEntry<T>> Void visit(T element) {
                ModifiableIndexedObjectCacheImpl.this.cachedClassExpressionLists_.addStructural(element);
                return null;
            }

            @Override
            public <T extends StructuralIndexedComplexPropertyChainEntry<T>> Void visit(T element) {
                ModifiableIndexedObjectCacheImpl.this.cachedComplexPropertyChains_.addStructural(element);
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    ((IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i)).propertyChainAddition(element);
                }
                return null;
            }

            @Override
            public <T extends StructuralIndexedObjectPropertyEntry<T>> Void visit(T element) {
                ModifiableIndexedObjectCacheImpl.this.cachedObjectProperties_.addStructural(element);
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                    listener.objectPropertyAddition(element);
                    listener.propertyChainAddition(element);
                }
                return null;
            }
        });
    }

    private EntryCollection<?> getResolver(IndexedSubObject input) {
        return (EntryCollection)input.accept(new IndexedSubObject.Visitor<EntryCollection<?>>(){

            @Override
            public EntryCollection<?> visit(IndexedDefinedClass element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedClasses_;
            }

            @Override
            public EntryCollection<?> visit(IndexedPredefinedClass element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedClasses_;
            }

            @Override
            public EntryCollection<?> visit(IndexedIndividual element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedIndividuals_;
            }

            @Override
            public EntryCollection<?> visit(IndexedDataHasValue element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_;
            }

            @Override
            public EntryCollection<?> visit(IndexedObjectComplementOf element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_;
            }

            @Override
            public EntryCollection<?> visit(IndexedObjectHasSelf element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_;
            }

            @Override
            public EntryCollection<?> visit(IndexedObjectIntersectionOf element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_;
            }

            @Override
            public EntryCollection<?> visit(IndexedObjectSomeValuesFrom element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_;
            }

            @Override
            public EntryCollection<?> visit(IndexedObjectUnionOf element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_;
            }

            @Override
            public EntryCollection<?> visit(IndexedObjectProperty element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedObjectProperties_;
            }

            @Override
            public EntryCollection<?> visit(IndexedComplexPropertyChain element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedComplexPropertyChains_;
            }

            @Override
            public EntryCollection<?> visit(IndexedClassExpressionList element) {
                return ModifiableIndexedObjectCacheImpl.this.cachedClassExpressionLists_;
            }
        });
    }

    @Override
    public <T extends StructuralIndexedSubObject<T>> T resolve(T input) {
        return (T)((StructuralIndexedSubObject)this.getResolver(input).findStructural(input));
    }

    @Override
    public void remove(StructuralIndexedSubObject<?> input) {
        input.accept(new StructuralIndexedSubObject.Visitor<Void>(){

            @Override
            public <T extends StructuralIndexedClassEntry<T>> Void visit(T element) {
                StructuralIndexedClassEntry removed = (StructuralIndexedClassEntry)ModifiableIndexedObjectCacheImpl.this.cachedClasses_.removeStructural(element);
                if (removed == null) {
                    return null;
                }
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                    listener.classRemoval(removed);
                    listener.classExpressionRemoval(removed);
                }
                return null;
            }

            @Override
            public <T extends StructuralIndexedComplexClassExpressionEntry<T>> Void visit(T element) {
                StructuralIndexedComplexClassExpressionEntry removed = (StructuralIndexedComplexClassExpressionEntry)ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_.removeStructural(element);
                if (removed == null) {
                    return null;
                }
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    ((IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i)).classExpressionRemoval(removed);
                }
                return null;
            }

            @Override
            public <T extends StructuralIndexedIndividualEntry<T>> Void visit(T element) {
                StructuralIndexedIndividualEntry removed = (StructuralIndexedIndividualEntry)ModifiableIndexedObjectCacheImpl.this.cachedIndividuals_.removeStructural(element);
                if (removed == null) {
                    return null;
                }
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                    listener.individualRemoval(element);
                    listener.classExpressionRemoval(element);
                }
                return null;
            }

            @Override
            public <T extends StructuralIndexedClassExpressionListEntry<T>> Void visit(T element) {
                ModifiableIndexedObjectCacheImpl.this.cachedClassExpressionLists_.removeStructural(element);
                return null;
            }

            @Override
            public <T extends StructuralIndexedComplexPropertyChainEntry<T>> Void visit(T element) {
                ModifiableIndexedObjectCacheImpl.this.cachedComplexPropertyChains_.removeStructural(element);
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    ((IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i)).propertyChainRemoval(element);
                }
                return null;
            }

            @Override
            public <T extends StructuralIndexedObjectPropertyEntry<T>> Void visit(T element) {
                ModifiableIndexedObjectCacheImpl.this.cachedObjectProperties_.removeStructural(element);
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                    listener.objectPropertyRemoval(element);
                    listener.propertyChainRemoval(element);
                }
                return null;
            }
        });
    }

    @Override
    public final boolean addListener(IndexedObjectCache.ChangeListener listener) {
        return this.listeners_.add(listener);
    }

    @Override
    public final boolean removeListener(IndexedObjectCache.ChangeListener listener) {
        return this.listeners_.remove(listener);
    }
}

