/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.conversion;

import java.util.ArrayList;
import org.semanticweb.elk.owl.interfaces.ElkAnonymousIndividual;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataAllValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkDataExactCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataExactCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataHasValue;
import org.semanticweb.elk.owl.interfaces.ElkDataMaxCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMaxCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMinCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMinCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectAllValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectExactCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectExactCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasSelf;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasValue;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectInverseOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectMaxCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMaxCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMinCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMinCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectOneOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectUnionOf;
import org.semanticweb.elk.owl.predefined.ElkPolarity;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkIndividualVisitor;
import org.semanticweb.elk.owl.visitors.ElkObjectPropertyExpressionVisitor;
import org.semanticweb.elk.reasoner.completeness.Feature;
import org.semanticweb.elk.reasoner.completeness.OccurrenceListener;
import org.semanticweb.elk.reasoner.indexing.classes.ResolvingModifiableIndexedObjectFactory;
import org.semanticweb.elk.reasoner.indexing.classes.UpdatingModifiableIndexedObjectFactory;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingUnsupportedFeature;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverter;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;

public class ElkPolarityExpressionConverterImpl
implements ElkPolarityExpressionConverter {
    private final ElkPolarityExpressionConverter complementaryConverter_;
    private final PredefinedElkClassFactory elkFactory_;
    private final ModifiableIndexedObject.Factory factory_;
    private final int increment_;
    private final OccurrenceListener occurrenceListener_;
    private final ElkPolarity polarity_;

    ElkPolarityExpressionConverterImpl(ElkPolarity polarity, PredefinedElkClassFactory elkFactory, ModifiableIndexedObject.Factory factory, ElkPolarityExpressionConverter complementaryConverter, OccurrenceListener occurrenceListener, int increment) {
        this.polarity_ = polarity;
        this.elkFactory_ = elkFactory;
        this.factory_ = factory;
        this.complementaryConverter_ = complementaryConverter;
        this.occurrenceListener_ = occurrenceListener;
        this.increment_ = increment;
    }

    public ElkPolarityExpressionConverterImpl(ElkPolarity polarity, PredefinedElkClassFactory elkFactory, ModifiableIndexedObject.Factory factory, ModifiableIndexedObject.Factory complementaryFactory, OccurrenceListener occurrenceTracker, int increment) {
        this.polarity_ = polarity;
        this.elkFactory_ = elkFactory;
        this.factory_ = factory;
        this.complementaryConverter_ = new ElkPolarityExpressionConverterImpl(polarity.getComplementary(), elkFactory, complementaryFactory, this, occurrenceTracker, increment);
        this.occurrenceListener_ = occurrenceTracker;
        this.increment_ = increment;
    }

    public ElkPolarityExpressionConverterImpl(PredefinedElkClassFactory elkFactory, ModifiableIndexedObject.Factory dualFactory, OccurrenceListener occurrrenceTracker, int increment) {
        this.polarity_ = ElkPolarity.DUAL;
        this.elkFactory_ = elkFactory;
        this.factory_ = dualFactory;
        this.complementaryConverter_ = this;
        this.occurrenceListener_ = occurrrenceTracker;
        this.increment_ = increment;
    }

    public ElkPolarityExpressionConverterImpl(PredefinedElkClassFactory elkFactory, ModifiableOntologyIndex index) {
        this(elkFactory, new ResolvingModifiableIndexedObjectFactory(index), index, 0);
    }

    public ElkPolarityExpressionConverterImpl(PredefinedElkClassFactory elkFactory, ModifiableOntologyIndex index, int increment) {
        this(elkFactory, new UpdatingModifiableIndexedObjectFactory(index, OccurrenceIncrement.getDualIncrement(increment)), index, increment);
    }

    @Override
    public ElkPolarityExpressionConverter getComplementaryConverter() {
        return this.complementaryConverter_;
    }

    @Override
    public ElkPolarity getPolarity() {
        return this.polarity_;
    }

    private ElkIndexingUnsupportedFeature unsupported(Feature feature) {
        return new ElkIndexingUnsupportedFeature(feature);
    }

    public ModifiableIndexedIndividual visit(ElkAnonymousIndividual expression) {
        throw this.unsupported(Feature.ANONYMOUS_INDIVIDUAL);
    }

    public ModifiableIndexedClassExpression visit(ElkClass elkClass) {
        return this.factory_.getIndexedClass(elkClass);
    }

    public ModifiableIndexedClassExpression visit(ElkDataAllValuesFrom expression) {
        throw this.unsupported(Feature.DATA_ALL_VALUES_FROM);
    }

    public ModifiableIndexedClassExpression visit(ElkDataExactCardinalityQualified expression) {
        throw this.unsupported(Feature.DATA_EXACT_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkDataExactCardinalityUnqualified expression) {
        throw this.unsupported(Feature.DATA_EXACT_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkDataHasValue elkDataHasValue) {
        this.occurrenceListener_.occurrenceChanged(Feature.DATA_HAS_VALUE, this.increment_);
        return this.factory_.getIndexedDataHasValue(elkDataHasValue);
    }

    public ModifiableIndexedClassExpression visit(ElkDataMaxCardinalityQualified expression) {
        throw this.unsupported(Feature.DATA_MAX_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkDataMaxCardinalityUnqualified expression) {
        throw this.unsupported(Feature.DATA_MAX_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkDataMinCardinalityQualified expression) {
        throw this.unsupported(Feature.DATA_MIN_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkDataMinCardinalityUnqualified expression) {
        throw this.unsupported(Feature.DATA_MIN_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkDataSomeValuesFrom expression) {
        throw this.unsupported(Feature.DATA_SOME_VALUES_FROM);
    }

    public ModifiableIndexedIndividual visit(ElkNamedIndividual elkNamedIndividual) {
        return this.factory_.getIndexedIndividual(elkNamedIndividual);
    }

    public ModifiableIndexedClassExpression visit(ElkObjectAllValuesFrom expression) {
        throw this.unsupported(Feature.OBJECT_ALL_VALUES_FROM);
    }

    public ModifiableIndexedClassExpression visit(ElkObjectComplementOf elkObjectComplementOf) {
        return this.factory_.getIndexedObjectComplementOf((ModifiableIndexedClassExpression)elkObjectComplementOf.getClassExpression().accept((ElkClassExpressionVisitor)this.complementaryConverter_));
    }

    public ModifiableIndexedClassExpression visit(ElkObjectExactCardinalityQualified expression) {
        throw this.unsupported(Feature.OBJECT_EXACT_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkObjectExactCardinalityUnqualified expression) {
        throw this.unsupported(Feature.OBJECT_EXACT_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkObjectHasSelf expression) {
        return this.factory_.getIndexedObjectHasSelf((ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)expression.getProperty()).accept((ElkObjectPropertyExpressionVisitor)this));
    }

    public ModifiableIndexedClassExpression visit(ElkObjectHasValue elkObjectHasValue) {
        return this.factory_.getIndexedObjectSomeValuesFrom((ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)elkObjectHasValue.getProperty()).accept((ElkObjectPropertyExpressionVisitor)this), (ModifiableIndexedClassExpression)((ElkIndividual)elkObjectHasValue.getFiller()).accept((ElkIndividualVisitor)this));
    }

    public ModifiableIndexedClassExpression visit(ElkObjectIntersectionOf elkObjectIntersectionOf) {
        int size = elkObjectIntersectionOf.getClassExpressions().size();
        switch (size) {
            case 0: {
                return this.factory_.getIndexedClass(this.elkFactory_.getOwlThing());
            }
        }
        ModifiableIndexedClassExpression result = null;
        for (ElkClassExpression conjunct : elkObjectIntersectionOf.getClassExpressions()) {
            ModifiableIndexedClassExpression ice = (ModifiableIndexedClassExpression)conjunct.accept((ElkClassExpressionVisitor)this);
            if (result == null) {
                result = ice;
                continue;
            }
            result = this.factory_.getIndexedObjectIntersectionOf(result, ice);
        }
        return result;
    }

    public ModifiableIndexedObjectProperty visit(ElkObjectInverseOf expression) {
        throw this.unsupported(Feature.OBJECT_INVERSE_OF);
    }

    public ModifiableIndexedClassExpression visit(ElkObjectMaxCardinalityQualified expression) {
        throw this.unsupported(Feature.OBJECT_MAX_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkObjectMaxCardinalityUnqualified expression) {
        throw this.unsupported(Feature.OBJECT_MAX_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkObjectMinCardinalityQualified expression) {
        throw this.unsupported(Feature.OBJECT_MIN_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkObjectMinCardinalityUnqualified expression) {
        throw this.unsupported(Feature.OBJECT_MIN_CARDINALITY);
    }

    public ModifiableIndexedClassExpression visit(ElkObjectOneOf elkObjectOneOf) {
        int size = elkObjectOneOf.getIndividuals().size();
        if (size > 0) {
            this.occurrenceListener_.occurrenceChanged(Feature.OBJECT_ONE_OF, this.increment_);
        }
        switch (size) {
            case 0: {
                return this.factory_.getIndexedClass(this.elkFactory_.getOwlNothing());
            }
            case 1: {
                return (ModifiableIndexedClassExpression)((ElkIndividual)elkObjectOneOf.getIndividuals().iterator().next()).accept((ElkIndividualVisitor)this);
            }
        }
        ArrayList<Object> disjuncts = new ArrayList<Object>(size);
        for (ElkIndividual member : elkObjectOneOf.getIndividuals()) {
            disjuncts.add(member.accept((ElkIndividualVisitor)this));
        }
        return this.factory_.getIndexedObjectUnionOf(disjuncts);
    }

    public ModifiableIndexedObjectProperty visit(ElkObjectProperty elkObjectProperty) {
        return this.factory_.getIndexedObjectProperty(elkObjectProperty);
    }

    public ModifiableIndexedClassExpression visit(ElkObjectSomeValuesFrom elkObjectSomeValuesFrom) {
        return this.factory_.getIndexedObjectSomeValuesFrom((ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)elkObjectSomeValuesFrom.getProperty()).accept((ElkObjectPropertyExpressionVisitor)this), (ModifiableIndexedClassExpression)((ElkClassExpression)elkObjectSomeValuesFrom.getFiller()).accept((ElkClassExpressionVisitor)this));
    }

    public ModifiableIndexedClassExpression visit(ElkObjectUnionOf elkObjectUnionOf) {
        int size = elkObjectUnionOf.getClassExpressions().size();
        switch (size) {
            case 0: {
                return this.factory_.getIndexedClass(this.elkFactory_.getOwlNothing());
            }
            case 1: {
                return (ModifiableIndexedClassExpression)((ElkClassExpression)elkObjectUnionOf.getClassExpressions().iterator().next()).accept((ElkClassExpressionVisitor)this);
            }
        }
        ArrayList<Object> disjuncts = new ArrayList<Object>(size);
        for (ElkClassExpression disjunct : elkObjectUnionOf.getClassExpressions()) {
            disjuncts.add(disjunct.accept((ElkClassExpressionVisitor)this));
        }
        return this.factory_.getIndexedObjectUnionOf(disjuncts);
    }
}

