/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.model.OntologyIndex;
import org.semanticweb.elk.reasoner.saturation.AbstractSaturationState;
import org.semanticweb.elk.reasoner.saturation.ExtendedContext;
import org.semanticweb.elk.reasoner.saturation.MainContextFactory;

class ReferenceSaturationState
extends AbstractSaturationState<ExtendedContext> {
    AtomicInteger contextCount = new AtomicInteger(0);

    public ReferenceSaturationState(OntologyIndex index) {
        super(index, new MainContextFactory());
    }

    @Override
    public Collection<ExtendedContext> getContexts() {
        return new AbstractCollection<ExtendedContext>(){

            @Override
            public Iterator<ExtendedContext> iterator() {
                return new Iterator<ExtendedContext>(){
                    Iterator<? extends IndexedClassExpression> ices;
                    ExtendedContext nextContext;
                    ExtendedContext nextFillerContext;
                    {
                        this.ices = ReferenceSaturationState.this.ontologyIndex.getClassExpressions().iterator();
                        this.seekNext();
                    }

                    void seekNext() {
                        while (this.ices.hasNext()) {
                            IndexedClassExpression nextIce = this.ices.next();
                            this.nextContext = nextIce.getContext();
                            if (nextIce instanceof IndexedObjectSomeValuesFrom) {
                                this.nextFillerContext = ((IndexedObjectSomeValuesFrom)nextIce).getRangeFiller().getContext();
                                if (this.nextFillerContext != null) {
                                    return;
                                }
                            }
                            if (this.nextContext == null) continue;
                            return;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextContext != null || this.nextFillerContext != null;
                    }

                    @Override
                    public ExtendedContext next() {
                        ExtendedContext result;
                        if (this.nextContext != null) {
                            result = this.nextContext;
                            this.nextContext = null;
                        } else if (this.nextFillerContext != null) {
                            result = this.nextFillerContext;
                            this.nextFillerContext = null;
                        } else {
                            throw new NoSuchElementException("No next context");
                        }
                        if (!this.hasNext()) {
                            this.seekNext();
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal not supported");
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public int size() {
                return ReferenceSaturationState.this.contextCount.get();
            }
        };
    }

    @Override
    public ExtendedContext getContext(IndexedContextRoot root) {
        return root.getContext();
    }

    @Override
    void resetContexts() {
        int cc = this.contextCount.get();
        if (cc == 0) {
            return;
        }
        if (this.contextCount.compareAndSet(cc, 0)) {
            for (ExtendedContext context : this.getContexts()) {
                context.getRoot().resetContext();
            }
            this.notifyContextsClear();
        }
    }

    @Override
    ExtendedContext setIfAbsent(ExtendedContext context) {
        ExtendedContext previous = context.getRoot().setContextIfAbsent(context);
        if (previous == null) {
            this.contextCount.incrementAndGet();
            this.notifyContextAddition(context);
        }
        return previous;
    }
}

