/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions.classes;

import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.AbstractClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusion;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.RuleVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.LinkedSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.SubsumerDecompositionVisitor;

public abstract class AbstractSubClassInclusion<S extends IndexedClassExpression>
extends AbstractClassConclusion
implements SubClassInclusion {
    private final S expression_;

    protected AbstractSubClassInclusion(IndexedContextRoot subExpression, S superExpression) {
        super(subExpression);
        if (superExpression == null) {
            throw new NullPointerException("Subsumer cannot be null!");
        }
        this.expression_ = superExpression;
    }

    public S getSubsumer() {
        return this.expression_;
    }

    void applyCompositionRules(RuleVisitor<?> ruleAppVisitor, ContextPremises premises, ClassInferenceProducer producer) {
        for (LinkedSubsumerRule compositionRule = this.expression_.getCompositionRuleHead(); compositionRule != null; compositionRule = (LinkedSubsumerRule)compositionRule.next()) {
            compositionRule.accept(ruleAppVisitor, this.expression_, premises, producer);
        }
    }

    void applyDecompositionRules(RuleVisitor<?> ruleAppVisitor, ContextPremises premises, ClassInferenceProducer producer) {
        this.expression_.accept(new SubsumerDecompositionVisitor(ruleAppVisitor, premises, producer));
    }

    @Override
    public <O> O accept(ClassConclusion.Visitor<O> visitor) {
        return this.accept(visitor);
    }
}

