/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions.classes;

import org.semanticweb.elk.reasoner.indexing.classes.DummyIndexedContextRootVisitor;
import org.semanticweb.elk.reasoner.indexing.model.HasNegativeOccurrence;
import org.semanticweb.elk.reasoner.indexing.model.HasPositiveOccurrence;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedRangeFiller;
import org.semanticweb.elk.reasoner.indexing.model.IndexedSubObject;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ContextInitialization;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.DisjointSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.Propagation;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionComposed;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionDecomposed;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubContextInitialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerivedClassConclusionChecker
implements ClassConclusion.Visitor<Boolean> {
    private static final ClassConclusion.Visitor<Boolean> INSTANCE_ = new DerivedClassConclusionChecker();
    private static final Logger LOGGER_ = LoggerFactory.getLogger(DerivedClassConclusionChecker.class);
    private static final IndexedContextRoot.Visitor<Boolean> ROOT_OCCURRENCE_CHECKER_ = new DummyIndexedContextRootVisitor<Boolean>(){

        @Override
        protected Boolean defaultVisit(IndexedClassExpression element) {
            return DerivedClassConclusionChecker.occursPositively(element);
        }

        @Override
        public Boolean visit(IndexedRangeFiller element) {
            return DerivedClassConclusionChecker.occursPositively(element.getFiller()) && DerivedClassConclusionChecker.occurs(element.getProperty());
        }
    };

    public static boolean check(ClassConclusion conclusion) {
        return conclusion.accept(INSTANCE_);
    }

    private static boolean occurs(IndexedSubObject iobj) {
        return iobj.occurs();
    }

    private static boolean occurs(IndexedClassExpression iobj) {
        return iobj.occurs();
    }

    private static boolean occurs(IndexedContextRoot root) {
        return root.accept(ROOT_OCCURRENCE_CHECKER_);
    }

    private static boolean occursNegatively(IndexedComplexClassExpression ice) {
        return ice.occursNegatively();
    }

    private static boolean occursNegatively(IndexedSubObject obj) {
        if (obj instanceof HasNegativeOccurrence) {
            return ((HasNegativeOccurrence)((Object)obj)).occursNegatively();
        }
        return DerivedClassConclusionChecker.occurs(obj);
    }

    private static boolean occursPositively(IndexedSubObject obj) {
        if (obj instanceof HasPositiveOccurrence) {
            return ((HasPositiveOccurrence)((Object)obj)).occursPositively();
        }
        return DerivedClassConclusionChecker.occurs(obj);
    }

    private boolean log(ClassConclusion conclusion) {
        LOGGER_.trace("Conclusion could be (re)derived: {}", (Object)conclusion);
        return true;
    }

    protected boolean defaultVisit(ClassConclusion conclusion) {
        return DerivedClassConclusionChecker.occurs(conclusion.getDestination()) && DerivedClassConclusionChecker.occurs(conclusion.getTraceRoot()) && this.log(conclusion);
    }

    protected boolean defaultVisit(SubClassConclusion conclusion) {
        return DerivedClassConclusionChecker.occurs(conclusion.getSubDestination()) && DerivedClassConclusionChecker.occurs(conclusion.getTraceRoot()) && this.defaultVisit((ClassConclusion)conclusion);
    }

    @Override
    public Boolean visit(BackwardLink conclusion) {
        return DerivedClassConclusionChecker.occurs(conclusion.getRelation()) && DerivedClassConclusionChecker.occurs(conclusion.getSource()) && this.defaultVisit(conclusion);
    }

    @Override
    public Boolean visit(ClassInconsistency conclusion) {
        return this.defaultVisit(conclusion);
    }

    @Override
    public Boolean visit(ContextInitialization conclusion) {
        return this.defaultVisit(conclusion);
    }

    @Override
    public Boolean visit(DisjointSubsumer conclusion) {
        return DerivedClassConclusionChecker.occurs(conclusion.getDisjointExpressions()) && this.defaultVisit(conclusion);
    }

    @Override
    public Boolean visit(ForwardLink conclusion) {
        return DerivedClassConclusionChecker.occurs(conclusion.getChain()) && DerivedClassConclusionChecker.occurs(conclusion.getTarget()) && this.defaultVisit(conclusion);
    }

    @Override
    public Boolean visit(Propagation subConclusion) {
        return DerivedClassConclusionChecker.occurs(subConclusion.getRelation()) && DerivedClassConclusionChecker.occursNegatively(subConclusion.getCarry()) && this.defaultVisit(subConclusion);
    }

    @Override
    public Boolean visit(SubClassInclusionComposed conclusion) {
        return DerivedClassConclusionChecker.occursNegatively(conclusion.getSubsumer()) && this.defaultVisit(conclusion);
    }

    @Override
    public Boolean visit(SubClassInclusionDecomposed conclusion) {
        return DerivedClassConclusionChecker.occurs(conclusion.getSubsumer()) && this.defaultVisit(conclusion);
    }

    @Override
    public Boolean visit(SubContextInitialization conclusion) {
        return this.defaultVisit(conclusion);
    }
}

