/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions.classes;

import org.semanticweb.elk.reasoner.saturation.conclusions.classes.ClassConclusionTimer;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ContextInitialization;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.DisjointSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.Propagation;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionComposed;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionDecomposed;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubContextInitialization;
import org.semanticweb.elk.util.logging.CachedTimeThread;

public class TimedClassConclusionVisitor<O>
implements ClassConclusion.Visitor<O> {
    private final ClassConclusion.Visitor<O> processor_;
    private final ClassConclusionTimer timer_;

    public TimedClassConclusionVisitor(ClassConclusionTimer timer, ClassConclusion.Visitor<O> processor) {
        this.timer_ = timer;
        this.processor_ = processor;
    }

    @Override
    public O visit(BackwardLink subConclusion) {
        this.timer_.timeBackwardLinks -= CachedTimeThread.getCurrentTimeMillis();
        Object result = this.processor_.visit(subConclusion);
        this.timer_.timeBackwardLinks += CachedTimeThread.getCurrentTimeMillis();
        return result;
    }

    @Override
    public O visit(SubClassInclusionComposed conclusion) {
        this.timer_.timeComposedSubsumers -= CachedTimeThread.getCurrentTimeMillis();
        Object result = this.processor_.visit(conclusion);
        this.timer_.timeComposedSubsumers += CachedTimeThread.getCurrentTimeMillis();
        return result;
    }

    @Override
    public O visit(ContextInitialization conclusion) {
        this.timer_.timeContextInitializations -= CachedTimeThread.getCurrentTimeMillis();
        Object result = this.processor_.visit(conclusion);
        this.timer_.timeContextInitializations += CachedTimeThread.getCurrentTimeMillis();
        return result;
    }

    @Override
    public O visit(ClassInconsistency conclusion) {
        this.timer_.timeContradictions -= CachedTimeThread.getCurrentTimeMillis();
        Object result = this.processor_.visit(conclusion);
        this.timer_.timeContradictions += CachedTimeThread.getCurrentTimeMillis();
        return result;
    }

    @Override
    public O visit(SubClassInclusionDecomposed conclusion) {
        this.timer_.timeDecomposedSubsumers -= CachedTimeThread.getCurrentTimeMillis();
        Object result = this.processor_.visit(conclusion);
        this.timer_.timeDecomposedSubsumers += CachedTimeThread.getCurrentTimeMillis();
        return result;
    }

    @Override
    public O visit(DisjointSubsumer conclusion) {
        this.timer_.timeDisjointSubsumers -= CachedTimeThread.getCurrentTimeMillis();
        Object result = this.processor_.visit(conclusion);
        this.timer_.timeDisjointSubsumers += CachedTimeThread.getCurrentTimeMillis();
        return result;
    }

    @Override
    public O visit(ForwardLink conclusion) {
        this.timer_.timeForwardLinks -= CachedTimeThread.getCurrentTimeMillis();
        Object result = this.processor_.visit(conclusion);
        this.timer_.timeForwardLinks += CachedTimeThread.getCurrentTimeMillis();
        return result;
    }

    @Override
    public O visit(Propagation subConclusion) {
        this.timer_.timePropagations -= CachedTimeThread.getCurrentTimeMillis();
        Object result = this.processor_.visit(subConclusion);
        this.timer_.timePropagations += CachedTimeThread.getCurrentTimeMillis();
        return result;
    }

    @Override
    public O visit(SubContextInitialization subConclusion) {
        this.timer_.timeSubContextInitializations -= CachedTimeThread.getCurrentTimeMillis();
        Object result = this.processor_.visit(subConclusion);
        this.timer_.timeSubContextInitializations += CachedTimeThread.getCurrentTimeMillis();
        return result;
    }
}

