/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.inferences;

import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpressionList;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.DisjointSubsumer;
import org.semanticweb.elk.reasoner.saturation.inferences.AbstractClassInconsistencyInference;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInconsistencyInference;
import org.semanticweb.elk.reasoner.tracing.Conclusion;

public class ClassInconsistencyOfDisjointSubsumers
extends AbstractClassInconsistencyInference {
    private final IndexedClassExpressionList disjointExpressions_;
    private final Integer firstPosition_;
    private final Integer secondPosition_;

    public ClassInconsistencyOfDisjointSubsumers(DisjointSubsumer premise, Integer otherPos) {
        super(premise.getDestination());
        this.disjointExpressions_ = premise.getDisjointExpressions();
        this.firstPosition_ = premise.getPosition();
        this.secondPosition_ = otherPos;
    }

    @Override
    public IndexedContextRoot getOrigin() {
        return this.getDestination();
    }

    public IndexedClassExpressionList getDisjointExpressions() {
        return this.disjointExpressions_;
    }

    public int getFirstDisjointPosition() {
        return this.firstPosition_;
    }

    public int getSecondDisjointPosition() {
        return this.secondPosition_;
    }

    public DisjointSubsumer getFirstPremise(DisjointSubsumer.Factory factory) {
        return factory.getDisjointSubsumer(this.getOrigin(), this.disjointExpressions_, this.firstPosition_);
    }

    public DisjointSubsumer getSecondPremise(DisjointSubsumer.Factory factory) {
        return factory.getDisjointSubsumer(this.getOrigin(), this.disjointExpressions_, this.secondPosition_);
    }

    @Override
    public int getPremiseCount() {
        return 2;
    }

    @Override
    public Conclusion getPremise(int index, Conclusion.Factory factory) {
        switch (index) {
            case 0: {
                return this.getFirstPremise(factory);
            }
            case 1: {
                return this.getSecondPremise(factory);
            }
        }
        return (Conclusion)ClassInconsistencyOfDisjointSubsumers.failGetPremise(index);
    }

    @Override
    public final <O> O accept(ClassInconsistencyInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    public static interface Visitor<O> {
        public O visit(ClassInconsistencyOfDisjointSubsumers var1);
    }
}

