/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.inferences;

import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.inferences.AbstractClassInconsistencyInference;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInconsistencyInference;
import org.semanticweb.elk.reasoner.tracing.Conclusion;

public class ClassInconsistencyPropagated
extends AbstractClassInconsistencyInference {
    private final IndexedContextRoot origin_;
    private final IndexedObjectProperty premiseRelation_;

    public ClassInconsistencyPropagated(IndexedContextRoot origin, IndexedObjectProperty relation, IndexedContextRoot destination) {
        super(destination);
        this.premiseRelation_ = relation;
        this.origin_ = origin;
    }

    public ClassInconsistencyPropagated(BackwardLink premise) {
        this(premise.getDestination(), premise.getRelation(), premise.getTraceRoot());
    }

    @Override
    public IndexedContextRoot getOrigin() {
        return this.origin_;
    }

    public IndexedObjectProperty getPremiseRelation() {
        return this.premiseRelation_;
    }

    public BackwardLink getFirstPremise(BackwardLink.Factory factory) {
        return factory.getBackwardLink(this.getOrigin(), this.premiseRelation_, this.getDestination());
    }

    public ClassInconsistency getSecondPremise(ClassInconsistency.Factory factory) {
        return factory.getContradiction(this.getOrigin());
    }

    @Override
    public int getPremiseCount() {
        return 2;
    }

    @Override
    public Conclusion getPremise(int index, Conclusion.Factory factory) {
        switch (index) {
            case 0: {
                return this.getFirstPremise(factory);
            }
            case 1: {
                return this.getSecondPremise(factory);
            }
        }
        return (Conclusion)ClassInconsistencyPropagated.failGetPremise(index);
    }

    @Override
    public final <O> O accept(ClassInconsistencyInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    public static interface Visitor<O> {
        public O visit(ClassInconsistencyPropagated var1);
    }
}

