/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.proof.ReasonerProducer;
import org.semanticweb.elk.reasoner.saturation.properties.RangeExplorer;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.SubPropertyExplorer;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.ObjectPropertyInference;
import org.semanticweb.elk.reasoner.stages.PropertyHierarchyCompositionState;
import org.semanticweb.elk.util.collections.AbstractHashMultimap;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.concurrent.computation.DelegateInterruptMonitor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyHierarchyCompositionComputationFactory
extends DelegateInterruptMonitor
implements InputProcessorFactory<IndexedPropertyChain, Engine> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(PropertyHierarchyCompositionComputationFactory.class);
    private final ReasonerProducer<? super ObjectPropertyInference> inferenceProducer_;
    private final PropertyHierarchyCompositionState.Dispatcher dispatcher_;
    private final IndexedPropertyChain.Visitor<Void> PROCESSOR_ = new IndexedPropertyChain.Visitor<Void>(){

        @Override
        public Void visit(IndexedObjectProperty element) {
            LOGGER_.trace("{}: computing sub-property chains and ranges", (Object)element);
            SubPropertyExplorer.getSubPropertyChains(element, PropertyHierarchyCompositionComputationFactory.this.inferenceProducer_, PropertyHierarchyCompositionComputationFactory.this.dispatcher_);
            RangeExplorer.getRanges(element, PropertyHierarchyCompositionComputationFactory.this.inferenceProducer_);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visit(IndexedComplexPropertyChain element) {
            LOGGER_.trace("{}: computing compositions", (Object)element);
            IndexedObjectProperty left = element.getFirstProperty();
            IndexedPropertyChain right = element.getSuffixChain();
            Set<IndexedObjectProperty> leftSubProperties = SubPropertyExplorer.getSubProperties(left, PropertyHierarchyCompositionComputationFactory.this.inferenceProducer_, PropertyHierarchyCompositionComputationFactory.this.dispatcher_);
            if (leftSubProperties.isEmpty()) {
                return null;
            }
            Set<IndexedPropertyChain> rightSubProperties = SubPropertyExplorer.getSubPropertyChains(right, PropertyHierarchyCompositionComputationFactory.this.inferenceProducer_, PropertyHierarchyCompositionComputationFactory.this.dispatcher_);
            for (IndexedPropertyChain rightSubPropertyChain : rightSubProperties) {
                IndexedComplexPropertyChain composition;
                IndexedPropertyChain rightRightSubProperty;
                if (left == right && rightSubPropertyChain == element) {
                    LOGGER_.trace("{} o {} => {}: transitivity composition [ignored]", new Object[]{left, rightSubPropertyChain, element});
                    continue;
                }
                Collection<Object> redundantLeftProperties = Collections.emptySet();
                if (rightSubPropertyChain instanceof IndexedComplexPropertyChain && rightSubProperties.contains(rightRightSubProperty = (composition = (IndexedComplexPropertyChain)rightSubPropertyChain).getSuffixChain())) {
                    IndexedObjectProperty rightLeftSubProperty = composition.getFirstProperty();
                    redundantLeftProperties = SubPropertyExplorer.getLeftSubComposableSubPropertiesByRightProperties(left, PropertyHierarchyCompositionComputationFactory.this.inferenceProducer_, PropertyHierarchyCompositionComputationFactory.this.dispatcher_).get((Object)rightLeftSubProperty);
                }
                SaturatedPropertyChain rightSaturation = rightSubPropertyChain.getSaturated();
                Object object = rightSaturation;
                synchronized (object) {
                    if (rightSaturation.nonRedundantCompositionsByLeftSubProperty == null) {
                        rightSaturation.nonRedundantCompositionsByLeftSubProperty = new CompositionMultimap<IndexedObjectProperty>();
                    }
                }
                if (!redundantLeftProperties.isEmpty()) {
                    object = rightSaturation;
                    synchronized (object) {
                        if (rightSaturation.redundantCompositionsByLeftSubProperty == null) {
                            rightSaturation.redundantCompositionsByLeftSubProperty = new CompositionMultimap<IndexedObjectProperty>();
                        }
                    }
                }
                for (IndexedObjectProperty leftSubProperty : leftSubProperties) {
                    Collection compositionsSoFar;
                    AbstractHashMultimap<IndexedObjectProperty, IndexedComplexPropertyChain> compositionsByLeft;
                    boolean newRecord = false;
                    boolean redundant = redundantLeftProperties.contains(leftSubProperty);
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace("{} o {} => {}: new composition [redundant: {}]", new Object[]{leftSubProperty, rightSubPropertyChain, element, redundant});
                    }
                    Object object2 = compositionsByLeft = redundant ? rightSaturation.redundantCompositionsByLeftSubProperty : rightSaturation.nonRedundantCompositionsByLeftSubProperty;
                    synchronized (object2) {
                        compositionsSoFar = compositionsByLeft.getValues((Object)leftSubProperty);
                        if (compositionsSoFar == null) {
                            compositionsSoFar = new ArrayHashSet(2);
                            compositionsByLeft.put((Object)leftSubProperty, (Object)compositionsSoFar);
                            newRecord = true;
                        }
                    }
                    if (newRecord) {
                        AbstractHashMultimap<IndexedPropertyChain, IndexedComplexPropertyChain> compositionsByRight;
                        AbstractHashMultimap<IndexedPropertyChain, IndexedComplexPropertyChain> abstractHashMultimap;
                        AbstractHashMultimap<IndexedPropertyChain, IndexedComplexPropertyChain> leftSaturation = leftSubProperty.getSaturated();
                        if (redundant) {
                            abstractHashMultimap = leftSaturation;
                            synchronized (abstractHashMultimap) {
                                if (leftSaturation.redundantCompositionsByRightSubProperty == null) {
                                    leftSaturation.redundantCompositionsByRightSubProperty = new CompositionMultimap<IndexedPropertyChain>();
                                }
                            }
                            compositionsByRight = leftSaturation.redundantCompositionsByRightSubProperty;
                        } else {
                            abstractHashMultimap = leftSaturation;
                            synchronized (abstractHashMultimap) {
                                if (leftSaturation.nonRedundantCompositionsByRightSubProperty == null) {
                                    leftSaturation.nonRedundantCompositionsByRightSubProperty = new CompositionMultimap<IndexedPropertyChain>();
                                }
                            }
                            compositionsByRight = leftSaturation.nonRedundantCompositionsByRightSubProperty;
                        }
                        abstractHashMultimap = compositionsByRight;
                        synchronized (abstractHashMultimap) {
                            compositionsByRight.put(rightSubPropertyChain, (IndexedComplexPropertyChain)((Object)compositionsSoFar));
                        }
                    }
                    object2 = compositionsSoFar;
                    synchronized (object2) {
                        compositionsSoFar.add(element);
                    }
                }
            }
            return null;
        }
    };

    public PropertyHierarchyCompositionComputationFactory(InterruptMonitor interrupter, ReasonerProducer<? super ObjectPropertyInference> inferenceProducer, PropertyHierarchyCompositionState.Dispatcher dispatcher) {
        super(interrupter);
        this.inferenceProducer_ = inferenceProducer;
        this.dispatcher_ = dispatcher;
    }

    public Engine getEngine() {
        return new Engine();
    }

    public void finish() {
    }

    private static class CompositionMultimap<P extends IndexedPropertyChain>
    extends AbstractHashMultimap<P, IndexedComplexPropertyChain> {
        private CompositionMultimap() {
        }

        protected Collection<IndexedComplexPropertyChain> newRecord() {
            return new ArrayHashSet(2);
        }
    }

    class Engine
    implements InputProcessor<IndexedPropertyChain> {
        Engine() {
        }

        public void submit(IndexedPropertyChain job) {
            job.accept(PropertyHierarchyCompositionComputationFactory.this.PROCESSOR_);
        }

        public void process() throws InterruptedException {
        }

        public void finish() {
        }
    }
}

