/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.util.collections.AbstractHashMultimap;
import org.semanticweb.elk.util.collections.Multimap;
import org.semanticweb.elk.util.collections.Operations;

public class SaturatedPropertyChain {
    final IndexedPropertyChain root;
    Set<IndexedObjectProperty> derivedSubProperties;
    Set<IndexedPropertyChain> derivedSubProperyChains;
    volatile boolean derivedSubPropertiesComputed = false;
    Set<IndexedClassExpression> derivedRanges;
    volatile boolean derivedRangesComputed = false;
    Multimap<IndexedObjectProperty, IndexedObjectProperty> leftSubComposableSubPropertiesByRightProperties;
    volatile boolean leftSubComposableSubPropertiesByRightPropertiesComputed = false;
    AbstractHashMultimap<IndexedObjectProperty, IndexedComplexPropertyChain> nonRedundantCompositionsByLeftSubProperty;
    AbstractHashMultimap<IndexedObjectProperty, IndexedComplexPropertyChain> redundantCompositionsByLeftSubProperty;
    AbstractHashMultimap<IndexedPropertyChain, IndexedComplexPropertyChain> nonRedundantCompositionsByRightSubProperty;
    AbstractHashMultimap<IndexedPropertyChain, IndexedComplexPropertyChain> redundantCompositionsByRightSubProperty;

    public SaturatedPropertyChain(IndexedPropertyChain ipc) {
        this.root = ipc;
    }

    public void clear() {
        this.derivedSubProperties = null;
        this.derivedSubProperyChains = null;
        this.derivedSubPropertiesComputed = false;
        this.derivedRanges = null;
        this.derivedRangesComputed = false;
        this.leftSubComposableSubPropertiesByRightProperties = null;
        this.leftSubComposableSubPropertiesByRightPropertiesComputed = false;
        this.nonRedundantCompositionsByLeftSubProperty = null;
        this.redundantCompositionsByLeftSubProperty = null;
        this.nonRedundantCompositionsByRightSubProperty = null;
        this.redundantCompositionsByRightSubProperty = null;
    }

    public boolean isClear() {
        return this.derivedSubProperties == null && this.derivedSubProperyChains == null && this.leftSubComposableSubPropertiesByRightProperties == null && this.nonRedundantCompositionsByLeftSubProperty == null && this.redundantCompositionsByLeftSubProperty == null && this.nonRedundantCompositionsByRightSubProperty == null && this.redundantCompositionsByRightSubProperty == null;
    }

    public Set<IndexedObjectProperty> getSubProperties() {
        if (this.derivedSubProperties != null) {
            return this.derivedSubProperties;
        }
        if (this.root instanceof IndexedObjectProperty) {
            return Collections.singleton((IndexedObjectProperty)this.root);
        }
        return Collections.emptySet();
    }

    public Set<IndexedPropertyChain> getSubPropertyChains() {
        return this.derivedSubProperyChains == null ? Collections.singleton(this.root) : this.derivedSubProperyChains;
    }

    public Set<IndexedClassExpression> getRanges() {
        if (this.derivedRanges == null) {
            return Collections.emptySet();
        }
        return this.derivedRanges;
    }

    public Multimap<IndexedObjectProperty, IndexedComplexPropertyChain> getNonRedundantCompositionsByLeftSubProperty() {
        return this.nonRedundantCompositionsByLeftSubProperty == null ? Operations.emptyMultimap() : this.nonRedundantCompositionsByLeftSubProperty;
    }

    public Multimap<IndexedObjectProperty, IndexedComplexPropertyChain> getRedundantCompositionsByLeftSubProperty() {
        return this.redundantCompositionsByLeftSubProperty == null ? Operations.emptyMultimap() : this.redundantCompositionsByLeftSubProperty;
    }

    public Multimap<IndexedPropertyChain, IndexedComplexPropertyChain> getNonRedundantCompositionsByRightSubProperty() {
        return this.nonRedundantCompositionsByRightSubProperty == null ? Operations.emptyMultimap() : this.nonRedundantCompositionsByRightSubProperty;
    }

    public Multimap<IndexedPropertyChain, IndexedComplexPropertyChain> getRedundantCompositionsByRightSubProperty() {
        return this.redundantCompositionsByRightSubProperty == null ? Operations.emptyMultimap() : this.redundantCompositionsByRightSubProperty;
    }

    public void dumpDiff(SaturatedPropertyChain other, Writer writer) throws IOException {
        if (this.root != other.root) {
            writer.append("this root: " + this.root + "; other root: " + other.root + "\n");
        }
        Operations.dumpDiff(this.getSubPropertyChains(), other.getSubPropertyChains(), (Writer)writer, (String)(this.root + ": this sub-property not in other: "));
        Operations.dumpDiff(other.getSubPropertyChains(), this.getSubPropertyChains(), (Writer)writer, (String)(this.root + ": other sub-property not in this: "));
        Operations.dumpDiff(this.getNonRedundantCompositionsByLeftSubProperty(), other.getNonRedundantCompositionsByLeftSubProperty(), (Writer)writer, (String)(this.root + ": this non-redundant left composition not in other: "));
        Operations.dumpDiff(this.getRedundantCompositionsByLeftSubProperty(), other.getRedundantCompositionsByLeftSubProperty(), (Writer)writer, (String)(this.root + ": this redundant left composition not in other: "));
        Operations.dumpDiff(other.getNonRedundantCompositionsByLeftSubProperty(), this.getNonRedundantCompositionsByLeftSubProperty(), (Writer)writer, (String)(this.root + ": other non-redundant left composition not in this: "));
        Operations.dumpDiff(other.getRedundantCompositionsByLeftSubProperty(), this.getRedundantCompositionsByLeftSubProperty(), (Writer)writer, (String)(this.root + ": other redundant left composition not in this: "));
        Operations.dumpDiff(this.getNonRedundantCompositionsByRightSubProperty(), other.getNonRedundantCompositionsByRightSubProperty(), (Writer)writer, (String)(this.root + ": this non-redundant right composition not in other: "));
        Operations.dumpDiff(this.getRedundantCompositionsByRightSubProperty(), other.getRedundantCompositionsByRightSubProperty(), (Writer)writer, (String)(this.root + ": this redundant right composition not in other: "));
        Operations.dumpDiff(other.getNonRedundantCompositionsByRightSubProperty(), this.getNonRedundantCompositionsByRightSubProperty(), (Writer)writer, (String)(this.root + ": other non-redundant right composition not in this: "));
        Operations.dumpDiff(other.getRedundantCompositionsByRightSubProperty(), this.getRedundantCompositionsByRightSubProperty(), (Writer)writer, (String)(this.root + ": other redundant right composition not in this: "));
    }
}

