/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.contradiction;

import java.util.Map;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.context.SubContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInconsistencyPropagated;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.contradiction.AbstractContradictionRule;
import org.semanticweb.elk.reasoner.saturation.rules.contradiction.ContradictionRuleVisitor;

public class ContradictionPropagationRule
extends AbstractContradictionRule {
    private static final ContradictionPropagationRule INSTANCE_ = new ContradictionPropagationRule();
    public static final String NAME = "Contradiction Propagation over Backward Links";

    private ContradictionPropagationRule() {
    }

    public static ContradictionPropagationRule getInstance() {
        return INSTANCE_;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public void apply(ClassInconsistency premise, ContextPremises premises, ClassInferenceProducer producer) {
        Map<IndexedObjectProperty, ? extends SubContextPremises> subPremises = premises.getSubContextPremisesByObjectProperty();
        for (IndexedObjectProperty propRelation : subPremises.keySet()) {
            for (IndexedContextRoot target : subPremises.get(propRelation).getLinkedRoots()) {
                producer.produce(new ClassInconsistencyPropagated(premises.getRoot(), propRelation, target));
            }
        }
    }

    @Override
    public boolean isTracingRule() {
        return false;
    }

    @Override
    public void accept(ContradictionRuleVisitor<?> visitor, ClassInconsistency premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }
}

