/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.disjointsubsumer;

import java.util.Iterator;
import java.util.Set;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpressionList;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.DisjointSubsumer;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInconsistencyOfDisjointSubsumers;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.disjointsubsumer.AbstractDisjointSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.disjointsubsumer.DisjointSubsumerRuleVisitor;

public class ContradictionCompositionRule
extends AbstractDisjointSubsumerRule {
    public static final String NAME = "Contradiction by Disjointness Axiom";

    public String toString() {
        return NAME;
    }

    @Override
    public void apply(DisjointSubsumer premise, ContextPremises premises, ClassInferenceProducer producer) {
        IndexedClassExpressionList disjoint = premise.getDisjointExpressions();
        Set<? extends Integer> disjointSubsumerPositions = premises.getSubsumerPositions(disjoint);
        if (disjointSubsumerPositions.size() > 1) {
            int lastPos = premise.getPosition();
            Iterator<? extends Integer> iterator = disjointSubsumerPositions.iterator();
            while (iterator.hasNext()) {
                int otherPos = iterator.next();
                if (otherPos == lastPos) continue;
                producer.produce(new ClassInconsistencyOfDisjointSubsumers(premise, otherPos));
            }
        }
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    @Override
    public void accept(DisjointSubsumerRuleVisitor<?> visitor, DisjointSubsumer premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }
}

