/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.factories;

import org.semanticweb.elk.ModifiableReference;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationInput;
import org.semanticweb.elk.reasoner.saturation.rules.factories.WorkerLocalTodo;
import org.semanticweb.elk.util.concurrent.computation.DelegateInterruptMonitor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleEngine<I extends RuleApplicationInput>
extends DelegateInterruptMonitor
implements InputProcessor<I> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(AbstractRuleEngine.class);
    private final ModifiableReference<Context> activeContext_;
    private final ClassInference.Visitor<?> inferenceProcessor_;
    private final WorkerLocalTodo workerLocalTodo_;

    public AbstractRuleEngine(ModifiableReference<Context> activeContext, ClassInference.Visitor<?> inferenceProcessor, WorkerLocalTodo localizedProducer, InterruptMonitor interrupter) {
        super(interrupter);
        this.activeContext_ = activeContext;
        this.inferenceProcessor_ = inferenceProcessor;
        this.workerLocalTodo_ = localizedProducer;
    }

    public void process() throws InterruptedException {
        try {
            while (true) {
                if (this.isInterrupted()) {
                    LOGGER_.trace("Rule application interrupted");
                    break;
                }
                Context nextContext = this.getNextActiveContext();
                if (nextContext == null) {
                    break;
                }
                this.process(nextContext);
            }
        }
        finally {
            this.workerLocalTodo_.deactivate();
        }
    }

    void process(Context context) {
        this.activeContext_.set((Object)context);
        this.workerLocalTodo_.setActiveRoot(context.getRoot());
        ClassInference inference;
        while ((inference = this.workerLocalTodo_.poll()) != null || (inference = context.takeToDo()) != null) {
            LOGGER_.trace("{}: processing inference {}", (Object)context, (Object)inference);
            inference.accept(this.inferenceProcessor_);
        }
        return;
    }

    protected abstract Context getNextActiveContext();
}

