/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.forwardlink;

import java.util.Collection;
import java.util.Set;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.forwardlink.AbstractForwardLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.forwardlink.ForwardLinkRuleVisitor;
import org.semanticweb.elk.util.collections.LazySetIntersection;
import org.semanticweb.elk.util.collections.Multimap;

public class ReflexiveBackwardLinkCompositionRule
extends AbstractForwardLinkRule {
    public static final String NAME = "ForwardLink Reflexive BackwardLink Composition";
    private final ForwardLink forwardLink_;

    private ReflexiveBackwardLinkCompositionRule(ForwardLink forwardLink) {
        this.forwardLink_ = forwardLink;
    }

    public static ReflexiveBackwardLinkCompositionRule getRuleFor(ForwardLink link) {
        return new ReflexiveBackwardLinkCompositionRule(link);
    }

    public String toString() {
        return NAME;
    }

    @Override
    private void apply(Multimap<IndexedObjectProperty, IndexedComplexPropertyChain> compsByBackwardRelation, ContextPremises premises, ClassInferenceProducer producer) {
        Set<IndexedObjectProperty> reflexiveBackwardRelations = premises.getLocalReflexiveObjectProperties();
        for (IndexedObjectProperty backwardRelation : new LazySetIntersection(compsByBackwardRelation.keySet(), reflexiveBackwardRelations)) {
            Collection compositions = compsByBackwardRelation.get((Object)backwardRelation);
            for (IndexedComplexPropertyChain composition : compositions) {
                IndexedContextRoot root = premises.getRoot();
                IndexedObjectSomeValuesFrom.Helper.produceComposedLink(producer, root, backwardRelation, root, this.forwardLink_.getChain(), this.forwardLink_.getTarget(), composition);
            }
        }
    }

    @Override
    public void apply(ForwardLink premise, ContextPremises premises, ClassInferenceProducer producer) {
        this.apply(this.forwardLink_.getChain().getSaturated().getNonRedundantCompositionsByLeftSubProperty(), premises, producer);
    }

    @Override
    public void applyTracing(ForwardLink premise, ContextPremises premises, ClassInferenceProducer producer) {
        this.apply(this.forwardLink_.getChain().getSaturated().getNonRedundantCompositionsByLeftSubProperty(), premises, producer);
        this.apply(this.forwardLink_.getChain().getSaturated().getRedundantCompositionsByLeftSubProperty(), premises, producer);
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    @Override
    public void accept(ForwardLinkRuleVisitor<?> visitor, ForwardLink premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }
}

