/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.subsumers;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpressionList;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedDisjointClassesAxiom;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.DisjointSubsumerFromSubsumer;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.AbstractChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.LinkedSubsumerRuleVisitor;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisjointSubsumerFromMemberRule
extends AbstractChainableSubsumerRule {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(DisjointSubsumerFromMemberRule.class);
    public static final String NAME = "DisjointClasses Introduction";
    private final List<IndexedClassExpressionList> disjointMembers_ = new ArrayList<IndexedClassExpressionList>(1);
    private final List<Integer> positions_ = new ArrayList<Integer>(1);
    private final List<ElkAxiom> reasons_ = new ArrayList<ElkAxiom>(1);
    private static Matcher<ChainableSubsumerRule, DisjointSubsumerFromMemberRule> MATCHER_ = new SimpleTypeBasedMatcher(DisjointSubsumerFromMemberRule.class);
    private static ReferenceFactory<ChainableSubsumerRule, DisjointSubsumerFromMemberRule> FACTORY_ = new ReferenceFactory<ChainableSubsumerRule, DisjointSubsumerFromMemberRule>(){

        public DisjointSubsumerFromMemberRule create(ChainableSubsumerRule tail) {
            return new DisjointSubsumerFromMemberRule(tail);
        }
    };

    private DisjointSubsumerFromMemberRule(ChainableSubsumerRule tail) {
        super(tail);
    }

    private DisjointSubsumerFromMemberRule(ModifiableIndexedDisjointClassesAxiom axiom, int position, ElkAxiom reason) {
        this(null);
        this.disjointMembers_.add(axiom.getMembers());
        this.positions_.add(position);
        this.reasons_.add(reason);
    }

    public static boolean addRulesFor(ModifiableIndexedDisjointClassesAxiom axiom, ModifiableOntologyIndex index, ElkAxiom reason) {
        ModifiableIndexedClassExpression ice;
        int pos;
        boolean success = true;
        int added = 0;
        List<? extends ModifiableIndexedClassExpression> members = axiom.getMembers().getElements();
        for (pos = 0; pos < members.size(); ++pos) {
            ice = members.get(pos);
            if (index.add(ice, new DisjointSubsumerFromMemberRule(axiom, pos, reason))) {
                ++added;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            return true;
        }
        for (pos = 0; pos < members.size(); ++pos) {
            ice = members.get(pos);
            if (added == 0) break;
            --added;
            index.remove(ice, new DisjointSubsumerFromMemberRule(axiom, pos, reason));
        }
        return false;
    }

    public static boolean removeRulesFor(ModifiableIndexedDisjointClassesAxiom axiom, ModifiableOntologyIndex index, ElkAxiom reason) {
        ModifiableIndexedClassExpression ice;
        int pos;
        boolean success = true;
        int removed = 0;
        List<? extends ModifiableIndexedClassExpression> members = axiom.getMembers().getElements();
        for (pos = 0; pos < members.size(); ++pos) {
            ice = members.get(pos);
            if (index.remove(ice, new DisjointSubsumerFromMemberRule(axiom, pos, reason))) {
                ++removed;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            return true;
        }
        for (pos = 0; pos < members.size(); ++pos) {
            ice = members.get(pos);
            if (removed == 0) break;
            --removed;
            index.add(ice, new DisjointSubsumerFromMemberRule(axiom, pos, reason));
        }
        return false;
    }

    @Deprecated
    public List<IndexedClassExpressionList> getDisjointnessAxioms() {
        return this.disjointMembers_;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public void accept(LinkedSubsumerRuleVisitor<?> visitor, IndexedClassExpression premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }

    @Override
    public void apply(IndexedClassExpression member, ContextPremises premises, ClassInferenceProducer producer) {
        for (int i = 0; i < this.disjointMembers_.size(); ++i) {
            producer.produce(new DisjointSubsumerFromSubsumer(premises.getRoot(), this.disjointMembers_.get(i), this.positions_.get(i), this.reasons_.get(i)));
        }
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    public boolean addTo(Chain<ChainableSubsumerRule> ruleChain) {
        int i;
        if (this.isEmpty()) {
            return true;
        }
        DisjointSubsumerFromMemberRule rule = (DisjointSubsumerFromMemberRule)ruleChain.getCreate(MATCHER_, FACTORY_);
        boolean success = true;
        int added = 0;
        for (i = 0; i < this.disjointMembers_.size(); ++i) {
            IndexedClassExpressionList disjoint = this.disjointMembers_.get(i);
            int position = this.positions_.get(i);
            ElkAxiom reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: adding to {} reason: {}", new Object[]{disjoint, NAME, reason});
            }
            if (rule.disjointMembers_.add(disjoint)) {
                rule.positions_.add(position);
                rule.reasons_.add(reason);
                ++added;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            return true;
        }
        for (i = 0; i < this.disjointMembers_.size() && added != 0; ++i) {
            --added;
            IndexedClassExpressionList axiom = this.disjointMembers_.get(i);
            ElkAxiom reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: removing from {} reason: {}", new Object[]{axiom, NAME, reason});
            }
            int j = rule.indexOf(axiom, reason);
            rule.disjointMembers_.remove(j);
            rule.positions_.remove(j);
            rule.reasons_.remove(j);
        }
        return false;
    }

    public boolean removeFrom(Chain<ChainableSubsumerRule> ruleChain) {
        IndexedClassExpressionList axiom;
        int i;
        if (this.isEmpty()) {
            return true;
        }
        DisjointSubsumerFromMemberRule rule = (DisjointSubsumerFromMemberRule)ruleChain.find(MATCHER_);
        if (rule == null) {
            return false;
        }
        boolean success = true;
        int removed = 0;
        for (i = 0; i < this.disjointMembers_.size(); ++i) {
            int j;
            axiom = this.disjointMembers_.get(i);
            ElkAxiom reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: removing from {} reason: {}", new Object[]{axiom, NAME, reason});
            }
            if ((j = rule.indexOf(axiom, reason)) >= 0) {
                rule.disjointMembers_.remove(j);
                rule.positions_.remove(j);
                rule.reasons_.remove(j);
                ++removed;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            if (rule.isEmpty()) {
                ruleChain.remove(MATCHER_);
                LOGGER_.trace("{}: removed ", (Object)NAME);
            }
            return true;
        }
        for (i = 0; i < this.disjointMembers_.size() && removed != 0; ++i) {
            --removed;
            axiom = this.disjointMembers_.get(i);
            int position = this.positions_.get(i);
            ElkAxiom reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: adding to {} reason: {} [revert]", new Object[]{axiom, NAME, reason});
            }
            rule.disjointMembers_.add(axiom);
            rule.positions_.add(position);
            rule.reasons_.add(reason);
        }
        return false;
    }

    private int indexOf(IndexedClassExpressionList disjoint, ElkAxiom reason) {
        for (int i = 0; i < this.disjointMembers_.size(); ++i) {
            if (!this.disjointMembers_.get(i).equals(disjoint) || !this.reasons_.get(i).equals(reason)) continue;
            return i;
        }
        return -1;
    }

    private boolean isEmpty() {
        return this.disjointMembers_.isEmpty();
    }
}

