/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.subsumers;

import org.semanticweb.elk.owl.predefined.PredefinedElkIris;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPredefinedClass;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInconsistencyOfOwlNothing;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.AbstractSubsumerDecompositionRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.SubsumerDecompositionRuleVisitor;

public class OwlNothingDecompositionRule
extends AbstractSubsumerDecompositionRule<IndexedPredefinedClass> {
    public static final String NAME = "owl:Nothing Decomposition";
    private static OwlNothingDecompositionRule INSTANCE_ = new OwlNothingDecompositionRule();

    public static OwlNothingDecompositionRule getInstance() {
        return INSTANCE_;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public void apply(IndexedPredefinedClass premise, ContextPremises premises, ClassInferenceProducer producer) {
        if (premise.getElkEntity().getIri().equals((Object)PredefinedElkIris.OWL_NOTHING)) {
            producer.produce(new ClassInconsistencyOfOwlNothing(premises.getRoot(), premise));
        }
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    @Override
    public void accept(SubsumerDecompositionRuleVisitor<?> visitor, IndexedPredefinedClass premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }
}

