/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.semanticweb.elk.loading.AbstractClassQueryLoader;
import org.semanticweb.elk.loading.ClassQueryLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionProcessor;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.reasoner.completeness.Feature;
import org.semanticweb.elk.reasoner.completeness.IncompletenessManager;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.OccurrenceListener;
import org.semanticweb.elk.reasoner.completeness.OccurrenceRegistry;
import org.semanticweb.elk.reasoner.completeness.OccurrencesInClassExpressionQuery;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.indexing.classes.OntologyIndexDummyChangeListener;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingUnsupportedException;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverterImpl;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.query.ElkQueryException;
import org.semanticweb.elk.reasoner.query.QueryNode;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalent;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputUnsatisfiable;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputVisitor;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateDummyChangeListener;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.taxonomy.ElkClassKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.Evictor;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassExpressionQueryState
implements ClassQueryLoader.Factory {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ClassExpressionQueryState.class);
    private final Map<ElkClassExpression, QueryState> queried_ = new ConcurrentHashMap<ElkClassExpression, QueryState>();
    private final Queue<ElkClassExpression> toLoad_ = new ConcurrentLinkedQueue<ElkClassExpression>();
    private final Map<IndexedClassExpression, QueryState> indexed_ = new ConcurrentHashMap<IndexedClassExpression, QueryState>();
    private final Evictor<ElkClassExpression> queriedEvictor_;
    private final Set<ElkClassExpression> lastQueries_ = new ArrayHashSet();
    private final IncompletenessManager incompletenessManager_;
    private final Map<ElkClass, Collection<IndexedClassExpression>> queriesByRelated_ = new ConcurrentHashMap<ElkClass, Collection<IndexedClassExpression>>();
    private final SaturationState<? extends Context> saturationState_;
    private final ElkPolarityExpressionConverter resolvingExpressionConverter_;
    private final ClassInconsistency.Factory conclusionFactory_;
    private final QueryOccurrenceListener occurrenceListener_ = new QueryOccurrenceListener();
    private final Predicate<ElkClassExpression> doNotEvict_ = new Predicate<ElkClassExpression>(){

        public boolean apply(ElkClassExpression ce) {
            return ClassExpressionQueryState.this.lastQueries_.contains(ce);
        }
    };
    private final TransitiveReductionOutputVisitor<IndexedClassExpression> transitiveReductionOutputProcessor_ = new TransitiveReductionOutputVisitor<IndexedClassExpression>(){

        @Override
        public void visit(TransitiveReductionOutputEquivalentDirect<IndexedClassExpression> output) {
            Object ice = output.getRoot();
            QueryState state = ClassExpressionQueryState.this.markComputed(ice);
            if (state == null) {
                return;
            }
            List<ElkClass> equivalent = output.getEquivalent();
            Collection<List<ElkClass>> directSubsumers = output.getDirectSubsumers();
            QueryNode<ElkEntity> node = new QueryNode<ElkEntity>((Iterable<ElkEntity>)equivalent, equivalent.size(), (ComparatorKeyProvider<ElkEntity>)ElkClassKeyProvider.INSTANCE);
            for (List<ElkClass> directSubs : directSubsumers) {
                QueryNode<ElkEntity> directSuperNode = new QueryNode<ElkEntity>((Iterable<ElkEntity>)directSubs, directSubs.size(), (ComparatorKeyProvider<ElkEntity>)ElkClassKeyProvider.INSTANCE);
                node.addDirectSuperNode(directSuperNode);
            }
            ClassExpressionQueryState.this.addAllRelated(ice, node);
            state.node = node;
        }

        @Override
        public void visit(TransitiveReductionOutputUnsatisfiable<IndexedClassExpression> output) {
            Object ice = output.getRoot();
            ClassExpressionQueryState.this.markComputed(ice);
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalent<IndexedClassExpression> output) {
            throw new IllegalArgumentException("Unexpected output of transitive reduction!");
        }
    };
    private static final Operations.Transformation<QueryState, IndexedClassExpression> notComputedIces_ = new Operations.Transformation<QueryState, IndexedClassExpression>(){

        public IndexedClassExpression transform(QueryState element) {
            if (element.isComputed) {
                return null;
            }
            return element.indexed;
        }
    };

    public <C extends Context> ClassExpressionQueryState(ReasonerConfiguration config, SaturationState<C> saturationState, PredefinedElkClassFactory elkFactory, ModifiableOntologyIndex ontologyIndex, ClassInconsistency.Factory conclusionFactory, IncompletenessManager incompletenessManager) {
        this.saturationState_ = saturationState;
        this.resolvingExpressionConverter_ = new ElkPolarityExpressionConverterImpl(elkFactory, ontologyIndex);
        this.conclusionFactory_ = conclusionFactory;
        this.incompletenessManager_ = incompletenessManager;
        ontologyIndex.addListener(new OntologyIndexDummyChangeListener(){

            @Override
            public void classRemoval(IndexedClass cls) {
                ClassExpressionQueryState.this.removeRelated(cls);
            }
        });
        saturationState.addListener(new SaturationStateDummyChangeListener<C>(){

            @Override
            public void contextMarkedNonSaturated(C context) {
                this.contextModified(context.getRoot());
            }

            @Override
            public void saturatedContextModified(C context) {
                this.contextModified(context.getRoot());
            }

            public void contextModified(IndexedContextRoot root) {
                if (root instanceof IndexedClass) {
                    ClassExpressionQueryState.this.removeRelated((IndexedClass)root);
                } else if (root instanceof IndexedClassExpression) {
                    IndexedClassExpression ice = (IndexedClassExpression)root;
                    ClassExpressionQueryState.this.markNotComputed(ice);
                }
            }

            @Override
            public void contextsClear() {
                for (QueryState state : ClassExpressionQueryState.this.queried_.values()) {
                    state.isComputed = false;
                    state.node = null;
                }
                LOGGER_.trace("Clear related classes");
                ClassExpressionQueryState.this.queriesByRelated_.clear();
            }
        });
        Object builder = config.getParameter("elk.reasoner.classexpressionquery.evictor");
        LOGGER_.debug("{} = {}", (Object)"elk.reasoner.classexpressionquery.evictor", builder);
        this.queriedEvictor_ = ((Evictor.Builder)builder).build();
    }

    private QueryState markComputed(IndexedClassExpression queryClass) {
        QueryState state = this.indexed_.get(queryClass);
        if (state == null || state.isComputed) {
            return null;
        }
        state.isComputed = true;
        LOGGER_.trace("query computed {}", (Object)queryClass);
        return state;
    }

    private QueryState markNotComputed(IndexedClassExpression queryClass) {
        QueryState state = this.indexed_.get(queryClass);
        if (state == null || !state.isComputed) {
            return null;
        }
        LOGGER_.trace("{}: reset query result", (Object)queryClass);
        state.isComputed = false;
        if (state.node != null) {
            this.removeAllRelated(queryClass, state.node);
            state.node = null;
        }
        return state;
    }

    boolean registerQuery(ElkClassExpression query) {
        LOGGER_.trace("class expression query registered {}", (Object)query);
        this.lastQueries_.clear();
        this.queriedEvictor_.add((Object)query);
        this.lastQueries_.add(query);
        QueryState state = this.queried_.get(query);
        if (state != null) {
            return false;
        }
        state = new QueryState(query);
        this.queried_.put(query, state);
        this.toLoad_.add(query);
        return true;
    }

    public OccurrenceListener getOccurrenceListener() {
        return this.occurrenceListener_;
    }

    @Override
    public ClassQueryLoader getQueryLoader(InterruptMonitor interrupter) {
        return new Loader(interrupter);
    }

    private void addAllRelated(IndexedClassExpression queryClass, QueryNode<ElkClass> queryNode) {
        for (ElkClass elkClass : queryNode) {
            this.addRelated(queryClass, elkClass);
        }
        for (Node node : queryNode.getDirectSuperNodes()) {
            for (ElkClass related : node) {
                this.addRelated(queryClass, related);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRelated(IndexedClass related) {
        Collection<IndexedClassExpression> queryClasses = this.queriesByRelated_.remove(related.getElkEntity());
        if (queryClasses != null) {
            Collection<IndexedClassExpression> collection = queryClasses;
            synchronized (collection) {
                for (IndexedClassExpression queryClass : queryClasses) {
                    this.markNotComputed(queryClass);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelated(IndexedClassExpression queryClass, ElkClass related) {
        ArrayHashSet queryClasses = this.queriesByRelated_.get(related);
        if (queryClasses == null) {
            queryClasses = new ArrayHashSet();
            this.queriesByRelated_.put(related, (Collection<IndexedClassExpression>)queryClasses);
            LOGGER_.trace("{} add related class: {}", (Object)queryClass, (Object)related);
        }
        ArrayHashSet arrayHashSet = queryClasses;
        synchronized (arrayHashSet) {
            queryClasses.add(queryClass);
        }
    }

    private void removeAllRelated(IndexedClassExpression queryClass, QueryNode<ElkClass> queryNode) {
        for (ElkClass elkClass : queryNode) {
            this.removeRelated(queryClass, elkClass);
        }
        for (Node node : queryNode.getDirectSuperNodes()) {
            for (ElkClass related : node) {
                this.removeRelated(queryClass, related);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRelated(IndexedClassExpression queryClass, ElkClass related) {
        Collection<IndexedClassExpression> queryClasses = this.queriesByRelated_.get(related);
        if (queryClasses != null) {
            Collection<IndexedClassExpression> collection = queryClasses;
            synchronized (collection) {
                queryClasses.remove(queryClass);
            }
            LOGGER_.trace("{} remove related class: {}", (Object)queryClass, (Object)related);
            if (queryClasses.isEmpty()) {
                this.queriesByRelated_.remove(related);
            }
        }
    }

    TransitiveReductionOutputVisitor<IndexedClassExpression> getTransitiveReductionOutputProcessor() {
        return this.transitiveReductionOutputProcessor_;
    }

    public Collection<IndexedClassExpression> getNotSaturatedQueriedClassExpressions() {
        return Operations.map(this.indexed_.values(), notComputedIces_);
    }

    public boolean isIndexed(ElkClassExpression classExpression) {
        QueryState state = this.queried_.get(classExpression);
        return state != null && state.indexed != null;
    }

    public boolean isComputed(ElkClassExpression classExpression) {
        QueryState state = this.queried_.get(classExpression);
        return state != null && state.isComputed;
    }

    private QueryState checkComputed(ElkClassExpression classExpression) throws ElkQueryException {
        QueryState state = this.queried_.get(classExpression);
        if (state != null && state.isComputed) {
            return state;
        }
        throw new ElkQueryException("Query was not computed yet: " + classExpression);
    }

    IncompletenessMonitor getIncompletenessMonitor(ElkClassExpression classExpression) {
        return this.queried_.get((Object)classExpression).queryMonitor_;
    }

    boolean isSatisfiable(ElkClassExpression classExpression) throws ElkQueryException {
        QueryState state = this.checkComputed(classExpression);
        return state.node != null;
    }

    Node<ElkClass> getEquivalentClasses(ElkClassExpression classExpression) throws ElkQueryException {
        QueryState state = this.checkComputed(classExpression);
        return state.node;
    }

    Set<? extends Node<ElkClass>> getDirectSuperClasses(ElkClassExpression classExpression) throws ElkQueryException {
        QueryState state = this.checkComputed(classExpression);
        if (state.node == null) {
            return null;
        }
        return state.node.getDirectSuperNodes();
    }

    Set<? extends Node<ElkClass>> getDirectSubClasses(ElkClassExpression classExpression, Taxonomy<ElkClass> taxonomy) throws ElkQueryException {
        QueryState state = this.checkComputed(classExpression);
        if (state.node == null) {
            return null;
        }
        Iterator iter = state.node.iterator();
        if (iter.hasNext()) {
            ElkClass cls = (ElkClass)iter.next();
            return taxonomy.getNode(cls).getDirectSubNodes();
        }
        Collection<? extends IndexedClass> allClasses = this.saturationState_.getOntologyIndex().getClasses();
        ArrayHashSet strictSubclasses = new ArrayHashSet(allClasses.size());
        for (IndexedClass indexedClass : allClasses) {
            Set<IndexedClassExpression> subsumers = indexedClass.getContext().getComposedSubsumers();
            if (!subsumers.contains(state.indexed) || state.indexed.getContext().getComposedSubsumers().size() == subsumers.size()) continue;
            strictSubclasses.add(indexedClass);
        }
        ArrayHashSet result = new ArrayHashSet();
        for (IndexedClass strictSubclass : strictSubclasses) {
            boolean isDirect = true;
            for (TaxonomyNode<ElkClass> superNode : taxonomy.getNode(strictSubclass.getElkEntity()).getDirectSuperNodes()) {
                IndexedClassExpression superClass = (IndexedClassExpression)((ElkClass)superNode.getCanonicalMember()).accept((ElkClassExpressionVisitor)this.resolvingExpressionConverter_);
                if (!strictSubclasses.contains(superClass)) continue;
                isDirect = false;
                break;
            }
            if (!isDirect) continue;
            result.add(taxonomy.getNode(strictSubclass.getElkEntity()));
        }
        if (result.isEmpty()) {
            result.add(taxonomy.getBottomNode());
        }
        return Collections.unmodifiableSet(result);
    }

    Set<? extends Node<ElkNamedIndividual>> getDirectInstances(ElkClassExpression classExpression, InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy) throws ElkQueryException {
        QueryState state = this.checkComputed(classExpression);
        if (state.node == null) {
            return null;
        }
        Iterator iter = state.node.iterator();
        if (iter.hasNext()) {
            ElkClass cls = (ElkClass)iter.next();
            return taxonomy.getNode((ElkEntity)cls).getDirectInstanceNodes();
        }
        Collection<? extends IndexedIndividual> allIndividuals = this.saturationState_.getOntologyIndex().getIndividuals();
        ArrayHashSet instances = new ArrayHashSet(allIndividuals.size());
        for (IndexedIndividual indexedIndividual : allIndividuals) {
            Set<IndexedClassExpression> subsumers = indexedIndividual.getContext().getComposedSubsumers();
            if (!subsumers.contains(state.indexed)) continue;
            instances.add(indexedIndividual);
        }
        ArrayHashSet result = new ArrayHashSet();
        for (IndexedIndividual instance : instances) {
            boolean isDirect = true;
            for (TypeNode<ElkClass, ElkNamedIndividual> typeNode : taxonomy.getInstanceNode(instance.getElkEntity()).getDirectTypeNodes()) {
                IndexedClassExpression type = (IndexedClassExpression)((ElkClass)typeNode.getCanonicalMember()).accept((ElkClassExpressionVisitor)this.resolvingExpressionConverter_);
                Set<IndexedClassExpression> subsumers = type.getContext().getComposedSubsumers();
                if (!subsumers.contains(state.indexed) || state.indexed.getContext().getComposedSubsumers().size() == subsumers.size()) continue;
                isDirect = false;
                break;
            }
            if (!isDirect) continue;
            result.add(taxonomy.getInstanceNode(instance.getElkEntity()));
        }
        return Collections.unmodifiableSet(result);
    }

    private class Loader
    extends AbstractClassQueryLoader {
        public Loader(InterruptMonitor interrupter) {
            super(interrupter);
        }

        @Override
        public void load(ElkClassExpressionProcessor inserter, ElkClassExpressionProcessor deleter) throws ElkLoadingException {
            QueryState state;
            ElkClassExpression classExpression;
            Iterator evicted = ClassExpressionQueryState.this.queriedEvictor_.evict(ClassExpressionQueryState.this.doNotEvict_);
            while (evicted.hasNext()) {
                classExpression = (ElkClassExpression)evicted.next();
                state = (QueryState)ClassExpressionQueryState.this.queried_.remove(classExpression);
                if (!state.isLoaded) continue;
                ClassExpressionQueryState.this.occurrenceListener_.beingLoaded_ = state;
                deleter.visit(classExpression);
                if (state.indexed == null) continue;
                if (state.isComputed && state.node != null) {
                    ClassExpressionQueryState.this.removeAllRelated(state.indexed, state.node);
                    state.node = null;
                }
                ClassExpressionQueryState.this.indexed_.remove(state.indexed);
                state.indexed = null;
            }
            while ((classExpression = (ElkClassExpression)ClassExpressionQueryState.this.toLoad_.poll()) != null) {
                state = (QueryState)ClassExpressionQueryState.this.queried_.get(classExpression);
                if (state == null) continue;
                ClassExpressionQueryState.this.occurrenceListener_.beingLoaded_ = state;
                inserter.visit(classExpression);
                state.isLoaded = true;
                try {
                    IndexedClassExpression ice;
                    state.indexed = ice = (IndexedClassExpression)classExpression.accept((ElkClassExpressionVisitor)ClassExpressionQueryState.this.resolvingExpressionConverter_);
                    ClassExpressionQueryState.this.indexed_.put(state.indexed, state);
                    LOGGER_.trace("query {} indexed as {}", (Object)classExpression, (Object)ice);
                    Object context = ClassExpressionQueryState.this.saturationState_.getContext(state.indexed);
                    if (context != null && context.isInitialized() && context.isSaturated() && context.containsConclusion(ClassExpressionQueryState.this.conclusionFactory_.getContradiction(state.indexed))) {
                        state.isComputed = true;
                        LOGGER_.trace("query computed {}", (Object)ice);
                    } else {
                        state.isComputed = false;
                    }
                }
                catch (ElkIndexingUnsupportedException e) {
                    state.indexed = null;
                    LOGGER_.trace("query NOT indexed {}", (Object)classExpression);
                }
                if (!this.isInterrupted()) continue;
                return;
            }
        }

        @Override
        public boolean isLoadingFinished() {
            return ClassExpressionQueryState.this.toLoad_.isEmpty();
        }
    }

    private class QueryOccurrenceListener
    implements OccurrenceListener {
        private QueryState beingLoaded_ = null;

        private QueryOccurrenceListener() {
        }

        @Override
        public void occurrenceChanged(Feature feature, int increment) {
            this.beingLoaded_.occurrences.occurrenceChanged(feature, increment);
        }
    }

    private class QueryState {
        boolean isLoaded = false;
        IndexedClassExpression indexed = null;
        boolean isComputed = false;
        QueryNode<ElkClass> node = null;
        final OccurrenceRegistry occurrences = new OccurrenceRegistry();
        final IncompletenessMonitor queryMonitor_;

        QueryState(ElkClassExpression query) {
            this.queryMonitor_ = ClassExpressionQueryState.this.incompletenessManager_.getQueryMonitor(new OccurrencesInClassExpressionQuery(query, this.occurrences));
        }
    }
}

