/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collections;
import org.semanticweb.elk.reasoner.completeness.Feature;
import org.semanticweb.elk.reasoner.completeness.OccurrencesInOntology;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassEntity;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturation;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationAdditionFactory;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationInput;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsistencyCheckingStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ConsistencyCheckingStage.class);
    protected ClassExpressionSaturation<IndexedClassEntity> computation = null;

    public ConsistencyCheckingStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Consistency Checking";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.computation = new ClassExpressionSaturation(this.isTriviallyConsistent() ? Collections.emptyList() : this.reasoner.consistencyCheckingState.getTestEntitites(), this.reasoner.getProcessExecutor(), this.workerNo, this.reasoner.getProgressMonitor(), new RuleApplicationAdditionFactory<RuleApplicationInput>((InterruptMonitor)this.reasoner.getInterrupter(), (SaturationState<?>)this.reasoner.saturationState));
        return true;
    }

    boolean isTriviallyConsistent() {
        OccurrencesInOntology occurrences = this.reasoner.getOccurrencesInOntology();
        if (occurrences.getOccurrenceCount(Feature.OWL_NOTHING_POSITIVE) == 0 && occurrences.getOccurrenceCount(Feature.DIFFERENT_INDIVIDUALS) == 0 && occurrences.getOccurrenceCount(Feature.DISJOINT_CLASSES) == 0 && occurrences.getOccurrenceCount(Feature.DISJOINT_UNION) == 0 && occurrences.getOccurrenceCount(Feature.OBJECT_COMPLEMENT_OF_POSITIVE) == 0) {
            LOGGER_.debug("The ontology is trivially consistent");
            return true;
        }
        return false;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        this.computation.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.ruleAndConclusionStats.add(this.computation.getRuleAndConclusionStatistics());
        this.computation = null;
        this.reasoner.consistencyCheckingState.getTestEntitites();
        return true;
    }

    @Override
    public void printInfo() {
        if (this.computation != null) {
            this.computation.printStatistics();
        }
    }
}

