/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.semanticweb.elk.loading.AbstractEntailmentQueryLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.loading.EntailmentQueryLoader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.reasoner.completeness.Feature;
import org.semanticweb.elk.reasoner.completeness.IncompletenessManager;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.OccurrenceListener;
import org.semanticweb.elk.reasoner.completeness.OccurrenceRegistry;
import org.semanticweb.elk.reasoner.completeness.OccurrencesInEntailmentQuery;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.consistency.ConsistencyCheckingState;
import org.semanticweb.elk.reasoner.entailments.InconsistencyProofWrapper;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.proof.ReasonerProof;
import org.semanticweb.elk.reasoner.query.ElkQueryException;
import org.semanticweb.elk.reasoner.query.IndexedEntailmentQuery;
import org.semanticweb.elk.reasoner.query.VerifiableQueryResult;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SaturationConclusion;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.Condition;
import org.semanticweb.elk.util.collections.Evictor;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntailmentQueryState
implements EntailmentQueryLoader.Factory {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(EntailmentQueryState.class);
    private final Map<ElkAxiom, QueryState> queried_ = new ConcurrentHashMap<ElkAxiom, QueryState>();
    private final Queue<ElkAxiom> toLoad_ = new ConcurrentLinkedQueue<ElkAxiom>();
    private final Evictor<QueryState> queriedEvictor_;
    private final Set<ElkAxiom> lastQueries_ = new ArrayHashSet();
    private final IncompletenessManager incompletenessManager_;
    private final SaturationState<? extends Context> saturationState_;
    private final ConsistencyCheckingState consistencyCheckingState_;
    private final SaturationConclusion.Factory conclusionFactory_;
    private final QueryOccurrenceListener occurrenceListener_ = new QueryOccurrenceListener();
    private final Predicate<QueryState> doNotEvict_ = new Predicate<QueryState>(){

        public boolean apply(QueryState state) {
            return state.isLocked() || EntailmentQueryState.this.lastQueries_.contains(state.getQuery());
        }
    };
    private final Condition<IndexedContextRoot> IS_NOT_SATURATED = new Condition<IndexedContextRoot>(){

        public boolean holds(IndexedContextRoot root) {
            Object context = EntailmentQueryState.this.saturationState_.getContext(root);
            return context == null || !context.isInitialized() || !context.isSaturated();
        }
    };
    private final Operations.Transformation<QueryState, Iterable<? extends IndexedContextRoot>> POSITIVELY_INDEXED = new Operations.Transformation<QueryState, Iterable<? extends IndexedContextRoot>>(){

        public Iterable<? extends IndexedContextRoot> transform(QueryState state) {
            if (state.indexed == null) {
                return null;
            }
            Collection<IndexedContextRoot> roots = state.indexed.getPositivelyIndexed();
            return Operations.filter(roots, (Condition)EntailmentQueryState.this.IS_NOT_SATURATED);
        }
    };

    public <C extends Context> EntailmentQueryState(ReasonerConfiguration config, SaturationState<C> saturationState, ConsistencyCheckingState consistencyCheckingState, SaturationConclusion.Factory factory, IncompletenessManager incompletenessManager) {
        this.saturationState_ = saturationState;
        this.consistencyCheckingState_ = consistencyCheckingState;
        this.conclusionFactory_ = factory;
        Object builder = config.getParameter("elk.reasoner.entailmentquery.evictor");
        LOGGER_.debug("{} = {}", (Object)"elk.reasoner.entailmentquery.evictor", builder);
        this.queriedEvictor_ = ((Evictor.Builder)builder).build();
        this.incompletenessManager_ = incompletenessManager;
    }

    void registerQueries(Iterable<? extends ElkAxiom> axioms) {
        this.lastQueries_.clear();
        for (ElkAxiom elkAxiom : axioms) {
            LOGGER_.trace("entailment query registered {}", (Object)elkAxiom);
            this.lastQueries_.add(elkAxiom);
            QueryState state = this.queried_.get(elkAxiom);
            if (state == null) {
                state = new QueryState(elkAxiom);
                this.queried_.put(elkAxiom, state);
                this.toLoad_.add(elkAxiom);
            }
            this.queriedEvictor_.add((Object)state);
        }
    }

    public OccurrenceListener getOccurrenceListener() {
        return this.occurrenceListener_;
    }

    @Override
    public EntailmentQueryLoader getQueryLoader(InterruptMonitor interrupter) {
        return new Loader(interrupter);
    }

    Collection<IndexedContextRoot> getNotSaturatedPositivelyIndexedRoots() {
        int sizeUpper = 0;
        for (QueryState state : this.queried_.values()) {
            if (state.indexed == null) continue;
            sizeUpper += state.indexed.getPositivelyIndexed().size();
        }
        Iterable result = Operations.concat((Iterable)Operations.map(this.queried_.values(), this.POSITIVELY_INDEXED));
        return Operations.getCollection((Iterable)result, (int)sizeUpper);
    }

    Map<ElkAxiom, VerifiableQueryResult> isEntailed(Iterable<? extends ElkAxiom> axioms) throws ElkQueryException {
        ArrayHashMap results = new ArrayHashMap();
        for (ElkAxiom elkAxiom : axioms) {
            QueryState state = this.queried_.get(elkAxiom);
            if (state == null) {
                throw new ElkQueryException("Query was not registered: " + elkAxiom);
            }
            state.lock();
            results.put(elkAxiom, state);
        }
        return results;
    }

    private class Loader
    extends AbstractEntailmentQueryLoader {
        public Loader(InterruptMonitor interrupter) {
            super(interrupter);
        }

        @Override
        public void load(ElkAxiomVisitor<IndexedEntailmentQuery<? extends Entailment>> inserter, ElkAxiomVisitor<IndexedEntailmentQuery<? extends Entailment>> deleter) throws ElkLoadingException {
            ElkAxiom axiom;
            Iterator evicted = EntailmentQueryState.this.queriedEvictor_.evict(EntailmentQueryState.this.doNotEvict_);
            while (evicted.hasNext()) {
                QueryState state = (QueryState)evicted.next();
                EntailmentQueryState.this.queried_.remove(state.getQuery());
                if (!state.isLoaded) continue;
                EntailmentQueryState.this.occurrenceListener_.beingLoaded_ = state;
                state.getQuery().accept(deleter);
                state.indexed = null;
                state.isLoaded = false;
            }
            while ((axiom = (ElkAxiom)EntailmentQueryState.this.toLoad_.poll()) != null) {
                QueryState state = (QueryState)EntailmentQueryState.this.queried_.get(axiom);
                EntailmentQueryState.this.occurrenceListener_.beingLoaded_ = state;
                state.indexed = (IndexedEntailmentQuery)axiom.accept(inserter);
                state.isLoaded = true;
                if (!this.isInterrupted()) continue;
                return;
            }
        }

        @Override
        public boolean isLoadingFinished() {
            return EntailmentQueryState.this.toLoad_.isEmpty();
        }
    }

    private class QueryOccurrenceListener
    implements OccurrenceListener {
        private QueryState beingLoaded_ = null;

        private QueryOccurrenceListener() {
        }

        @Override
        public void occurrenceChanged(Feature occurrence, int increment) {
            this.beingLoaded_.occurrences.occurrenceChanged(occurrence, increment);
        }
    }

    private class QueryState
    implements VerifiableQueryResult {
        private final ElkAxiom query_;
        boolean isLoaded = false;
        IndexedEntailmentQuery<? extends Entailment> indexed = null;
        int lockedCount = 0;
        OccurrenceRegistry occurrences = new OccurrenceRegistry();
        private final IncompletenessMonitor queryIncompletenessMonitor_;

        QueryState(ElkAxiom query) {
            this.query_ = query;
            this.queryIncompletenessMonitor_ = EntailmentQueryState.this.incompletenessManager_.getQueryMonitor(new OccurrencesInEntailmentQuery(query, this.occurrences));
        }

        @Override
        public ElkAxiom getQuery() {
            return this.query_;
        }

        @Override
        public Entailment getEntailment() throws ElkQueryException {
            if (this.indexed == null) {
                return null;
            }
            return this.indexed.getQuery();
        }

        @Override
        public boolean entailmentProved() throws ElkQueryException {
            if (this.indexed == null) {
                return false;
            }
            return !this.getEvidence(true).getInferences(this.indexed.getQuery()).isEmpty();
        }

        @Override
        public IncompletenessMonitor getIncompletenessMonitor() {
            return this.queryIncompletenessMonitor_;
        }

        @Override
        public ReasonerProof<EntailmentInference> getEvidence(boolean onlyOne) throws ElkQueryException {
            if (this.indexed == null) {
                return ReasonerProof.empty();
            }
            InconsistencyProofWrapper inconsistencyEvidence = new InconsistencyProofWrapper(EntailmentQueryState.this.consistencyCheckingState_.getEvidence(onlyOne));
            if (EntailmentQueryState.this.consistencyCheckingState_.isInconsistent() && onlyOne) {
                return inconsistencyEvidence;
            }
            ReasonerProof<EntailmentInference> entailmentEvidence = this.indexed.getEvidence(onlyOne, EntailmentQueryState.this.saturationState_, EntailmentQueryState.this.conclusionFactory_);
            return ReasonerProof.union(inconsistencyEvidence, entailmentEvidence);
        }

        public synchronized boolean lock() {
            boolean wasLocked = this.isLocked();
            ++this.lockedCount;
            return wasLocked != this.isLocked();
        }

        public synchronized boolean isLocked() {
            return this.lockedCount > 0;
        }

        public synchronized boolean unlock() {
            if (!this.isLocked()) {
                return false;
            }
            --this.lockedCount;
            return !this.isLocked();
        }
    }
}

