/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collection;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.taxonomy.InstanceTaxonomyComputation;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

public class InstanceTaxonomyComputationStage
extends AbstractReasonerStage {
    private InstanceTaxonomyComputation computation_ = null;

    public InstanceTaxonomyComputationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Instance Taxonomy Computation";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        Collection<IndexedIndividual> toAdd = this.reasoner.instanceTaxonomyState.getToAdd();
        this.computation_ = new InstanceTaxonomyComputation(toAdd, (InterruptMonitor)this.reasoner.getInterrupter(), this.reasoner.getProcessExecutor(), this.workerNo, this.reasoner.getProgressMonitor(), this.reasoner.saturationState, this.reasoner.instanceTaxonomyState.getTaxonomy());
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        this.computation_.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        Collection<IndexedIndividual> toAdd = this.reasoner.instanceTaxonomyState.getToAdd();
        if (!toAdd.isEmpty()) {
            throw new ElkRuntimeException(InstanceTaxonomyComputation.class.getSimpleName() + " did not add all individuals to the taxonomy!");
        }
        this.reasoner.instanceTaxonomyState.taxonomyComplete();
        this.reasoner.ontologyIndex.initIndividualChanges();
        this.computation_ = null;
        return true;
    }

    @Override
    public void printInfo() {
        if (this.computation_ != null) {
            this.computation_.printStatistics();
        }
    }
}

