/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.reasoner.stages.AbstractStageExecutor;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.util.logging.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStageExecutor
extends AbstractStageExecutor {
    protected static final Logger LOGGER_ = LoggerFactory.getLogger(LoggingStageExecutor.class);

    @Override
    public void execute(ReasonerStage stage) throws ElkException {
        LOGGER_.debug("{} stage:", (Object)stage);
        Statistics.logOperationStart((String)stage.getName(), (Logger)LOGGER_);
        try {
            stage.preExecute();
            stage.execute();
            stage.printInfo();
            stage.postExecute();
        }
        catch (ElkInterruptedException e) {
            LOGGER_.debug("{} was interrupted.", (Object)stage);
            stage.printInfo();
            throw e;
        }
        finally {
            Statistics.logOperationFinish((String)stage.getName(), (Logger)LOGGER_);
            Statistics.logMemoryUsage((Logger)LOGGER_);
        }
        LOGGER_.debug("{}: done.", (Object)stage);
    }
}

