/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.predefined.PredefinedElkObjectPropertyFactory;
import org.semanticweb.elk.reasoner.saturation.properties.ObjectPropertyTaxonomyComputation;
import org.semanticweb.elk.reasoner.saturation.properties.TransitiveReductionOutputEquivalent;
import org.semanticweb.elk.reasoner.saturation.properties.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.saturation.properties.TransitiveReductionOutputExtreme;
import org.semanticweb.elk.reasoner.saturation.properties.TransitiveReductionOutputVisitor;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.taxonomy.ElkObjectPropertyKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.ReverseObjectPropertyTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.ReverseTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.NonBottomTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPropertyTaxonomyState {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ObjectPropertyTaxonomyState.class);
    private final PredefinedElkObjectPropertyFactory elkFactory_;
    private ReverseObjectPropertyTaxonomy taxonomy_ = null;
    private final TransitiveReductionOutputVisitor<ElkObjectProperty> transitiveReductionOutputProcessor_ = new TransitiveReductionOutputVisitor<ElkObjectProperty>(){

        @Override
        public void visit(TransitiveReductionOutputEquivalentDirect<ElkObjectProperty> output) {
            NonBottomTaxonomyNode node = ObjectPropertyTaxonomyState.this.taxonomy_.getCreateNode(output.getEquivalent());
            ObjectPropertyTaxonomyState.this.taxonomy_.setCreateDirectSupernodes(node, output.getDirectlyRelated());
        }

        @Override
        public void visit(TransitiveReductionOutputExtreme<ElkObjectProperty> output) {
            ObjectPropertyTaxonomyState.this.taxonomy_.addToBottomNode(output.getExtremeMember());
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalent<ElkObjectProperty> output) {
            throw new IllegalArgumentException("Object property transitive reduction is not expected to emit " + output.getClass());
        }
    };

    public ObjectPropertyTaxonomyState(PredefinedElkObjectPropertyFactory elkFactory) {
        this.elkFactory_ = elkFactory;
        this.resetTaxonomy();
    }

    public Taxonomy<ElkObjectProperty> getTaxonomy() {
        return new ReverseTaxonomy<ElkObjectProperty>(this.taxonomy_);
    }

    private void resetTaxonomy() {
        LOGGER_.trace("Reset object property taxonomy");
        this.taxonomy_ = new ReverseObjectPropertyTaxonomy(this.elkFactory_, ElkObjectPropertyKeyProvider.INSTANCE);
    }

    AbstractReasonerStage createStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        return new AbstractReasonerStage(reasoner, preStages){
            private ObjectPropertyTaxonomyComputation computation_;
            {
                this.computation_ = null;
            }

            @Override
            public String getName() {
                return "Object Property Taxonomy Computation";
            }

            @Override
            public boolean preExecute() {
                if (!super.preExecute()) {
                    return false;
                }
                ObjectPropertyTaxonomyState.this.resetTaxonomy();
                this.computation_ = new ObjectPropertyTaxonomyComputation(this.reasoner.ontologyIndex, (InterruptMonitor)this.reasoner.getInterrupter(), ObjectPropertyTaxonomyState.this.transitiveReductionOutputProcessor_, (PredefinedElkObjectPropertyFactory)this.reasoner.getElkFactory(), this.reasoner.getProcessExecutor(), this.workerNo, this.reasoner.getProgressMonitor());
                return true;
            }

            @Override
            void executeStage() throws ElkException {
                this.computation_.process();
            }

            @Override
            public boolean postExecute() {
                if (!super.postExecute()) {
                    return false;
                }
                this.computation_ = null;
                return true;
            }

            @Override
            public void printInfo() {
            }
        };
    }
}

