/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.hashing;

import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.hashing.TaxonomyEqualator;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;

public class InstanceTaxonomyEqualator {
    public static <T extends ElkEntity, I extends ElkEntity> boolean equals(Taxonomy<T> taxonomy1, Taxonomy<T> taxonomy2) {
        boolean areTaxonomiesEqual = TaxonomyEqualator.equals(taxonomy1, taxonomy2);
        if (!areTaxonomiesEqual) {
            return false;
        }
        if (!(taxonomy1 instanceof InstanceTaxonomy) || !(taxonomy2 instanceof InstanceTaxonomy)) {
            return areTaxonomiesEqual;
        }
        try {
            ElkEntity member1;
            InstanceTaxonomy instanceTaxonomy1 = (InstanceTaxonomy)taxonomy1;
            InstanceTaxonomy instanceTaxonomy2 = (InstanceTaxonomy)taxonomy2;
            Set instanceNodes1 = instanceTaxonomy1.getInstanceNodes();
            Set instanceNodes2 = instanceTaxonomy2.getInstanceNodes();
            if (instanceNodes1.size() != instanceNodes2.size()) {
                return false;
            }
            for (InstanceNode instanceNode : instanceNodes1) {
                member1 = (ElkEntity)instanceNode.getCanonicalMember();
                InstanceNode<ElkEntity, ElkEntity> instanceNode2 = instanceTaxonomy2.getInstanceNode(member1);
                if (instanceNode2 == null) {
                    return false;
                }
                if (instanceNode.size() != instanceNode2.size()) {
                    return false;
                }
                for (ElkEntity member : instanceNode) {
                    if (instanceNode2.contains(member)) continue;
                    return false;
                }
                Set types1 = instanceNode.getDirectTypeNodes();
                Set types2 = instanceNode2.getDirectTypeNodes();
                if (types1.size() != types2.size()) {
                    return false;
                }
                for (TypeNode typeNode : types1) {
                    TaxonomyNode type2 = instanceTaxonomy2.getNode((ElkEntity)typeNode.getCanonicalMember());
                    if (types2.contains(type2)) continue;
                    return false;
                }
            }
            for (TypeNode typeNode : instanceTaxonomy1.getNodes()) {
                member1 = (ElkEntity)typeNode.getCanonicalMember();
                TaxonomyNode typeNode2 = instanceTaxonomy2.getNode(member1);
                Set instances1 = typeNode.getDirectInstanceNodes();
                Set instances2 = typeNode2.getDirectInstanceNodes();
                if (instances1.size() != instances2.size()) {
                    return false;
                }
                for (InstanceNode instanceNode : instances1) {
                    InstanceNode instance2 = instanceTaxonomy2.getInstanceNode((ElkEntity)instanceNode.getCanonicalMember());
                    if (instances2.contains(instance2)) continue;
                    return false;
                }
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }
}

