/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.impl.AbstractDistinctBottomTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.impl.NonBottomGenericTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.util.collections.Condition;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.hashing.HashGenerator;

public class BottomGenericTaxonomyNode<T extends ElkEntity, N extends GenericTaxonomyNode<T, N>, UN extends UpdateableTaxonomyNode<T, N, UN>>
implements GenericTaxonomyNode<T, N> {
    protected final AbstractDistinctBottomTaxonomy<T, N, UN> taxonomy_;
    private final T bottomMember_;
    private final int hashCode_ = HashGenerator.generateNextHashCode();

    public BottomGenericTaxonomyNode(AbstractDistinctBottomTaxonomy<T, N, UN> taxonomy, T bottomMember) {
        this.taxonomy_ = taxonomy;
        this.bottomMember_ = bottomMember;
        this.taxonomy_.unsatisfiableClasses_.put(this.getKeyProvider().getKey(this.bottomMember_), this.bottomMember_);
    }

    @Override
    public ComparatorKeyProvider<? super T> getKeyProvider() {
        return this.taxonomy_.getKeyProvider();
    }

    @Override
    public boolean contains(T member) {
        return this.taxonomy_.unsatisfiableClasses_.containsKey(this.getKeyProvider().getKey(member));
    }

    @Override
    public int size() {
        return this.taxonomy_.unsatisfiableClasses_.size();
    }

    @Override
    public T getCanonicalMember() {
        return this.bottomMember_;
    }

    @Override
    public Iterator<T> iterator() {
        return this.taxonomy_.unsatisfiableClasses_.values().iterator();
    }

    @Override
    public Set<? extends N> getDirectSuperNodes() {
        Set<N> nonBottomNodes = this.getAllSuperNodes();
        return Operations.filter(nonBottomNodes, (Condition)new Condition<N>(){

            public boolean holds(N element) {
                return element.getDirectSubNodes().contains(BottomGenericTaxonomyNode.this.taxonomy_.getBottomNode());
            }
        }, (int)(nonBottomNodes.size() - this.taxonomy_.countNodesWithSubClasses_.get()));
    }

    @Override
    public Set<? extends N> getAllSuperNodes() {
        return this.taxonomy_.toTaxonomyNodes(this.taxonomy_.getNonBottomNodes());
    }

    @Override
    public Set<? extends N> getDirectSubNodes() {
        return Collections.emptySet();
    }

    @Override
    public Set<? extends N> getAllSubNodes() {
        return Collections.emptySet();
    }

    @Override
    public Taxonomy<T> getTaxonomy() {
        return this.taxonomy_;
    }

    public final int hashCode() {
        return this.hashCode_;
    }

    public static class Projection<T extends ElkEntity>
    extends BottomGenericTaxonomyNode<T, GenericTaxonomyNode.Projection<T>, NonBottomGenericTaxonomyNode.Projection<T>>
    implements GenericTaxonomyNode.Projection<T> {
        public Projection(AbstractDistinctBottomTaxonomy<T, GenericTaxonomyNode.Projection<T>, NonBottomGenericTaxonomyNode.Projection<T>> taxonomy, T bottomMember) {
            super(taxonomy, bottomMember);
        }
    }
}

