/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.impl;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeUtils;
import org.semanticweb.elk.reasoner.taxonomy.impl.AbstractDistinctBottomTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.impl.SimpleUpdateableNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.hashing.HashGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NonBottomGenericTaxonomyNode<T extends ElkEntity, N extends GenericTaxonomyNode<T, N>, UN extends UpdateableTaxonomyNode<T, N, UN>>
extends SimpleUpdateableNode<T>
implements GenericTaxonomyNode<T, N>,
UpdateableTaxonomyNode<T, N, UN> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(NonBottomGenericTaxonomyNode.class);
    protected final AbstractDistinctBottomTaxonomy<T, N, UN> taxonomy_;
    protected final Set<UN> directSuperNodes_;
    protected final Set<UN> directSubNodes_;
    private final int hashCode_ = HashGenerator.generateNextHashCode();

    public NonBottomGenericTaxonomyNode(AbstractDistinctBottomTaxonomy<T, N, UN> taxonomy, Iterable<? extends T> members, int size) {
        super(members, size, taxonomy.getKeyProvider());
        this.taxonomy_ = taxonomy;
        this.directSubNodes_ = new ArrayHashSet();
        this.directSuperNodes_ = new ArrayHashSet();
    }

    @Override
    public Set<? extends N> getDirectSuperNodes() {
        return Collections.unmodifiableSet(this.taxonomy_.toTaxonomyNodes(this.directSuperNodes_));
    }

    @Override
    public Set<? extends UN> getDirectNonBottomSuperNodes() {
        return Collections.unmodifiableSet(this.directSuperNodes_);
    }

    @Override
    public Set<? extends N> getAllSuperNodes() {
        return TaxonomyNodeUtils.getAllSuperNodes(this.getDirectSuperNodes());
    }

    @Override
    public Set<? extends N> getDirectSubNodes() {
        if (!this.directSubNodes_.isEmpty()) {
            return Collections.unmodifiableSet(this.taxonomy_.toTaxonomyNodes(this.directSubNodes_));
        }
        return Collections.singleton(this.taxonomy_.getBottomNode());
    }

    @Override
    public Set<? extends UN> getDirectNonBottomSubNodes() {
        return Collections.unmodifiableSet(this.directSubNodes_);
    }

    @Override
    public Set<? extends N> getAllSubNodes() {
        return TaxonomyNodeUtils.getAllSubNodes(this.getDirectSubNodes());
    }

    @Override
    public Taxonomy<T> getTaxonomy() {
        return this.taxonomy_;
    }

    @Override
    public synchronized void addDirectSuperNode(UN superNode) {
        LOGGER_.trace("{}: new direct super-node {}", (Object)this, superNode);
        this.directSuperNodes_.add(superNode);
    }

    @Override
    public synchronized void addDirectSubNode(UN subNode) {
        LOGGER_.trace("{}: new direct sub-node {}", (Object)this, subNode);
        if (this.directSubNodes_.isEmpty()) {
            this.taxonomy_.countNodesWithSubClasses_.incrementAndGet();
        }
        this.directSubNodes_.add(subNode);
    }

    @Override
    public synchronized boolean removeDirectSubNode(UN subNode) {
        boolean changed = this.directSubNodes_.remove(subNode);
        if (changed) {
            LOGGER_.trace("{}: removed direct sub-node {}", (Object)this, subNode);
        }
        if (this.directSubNodes_.isEmpty()) {
            this.taxonomy_.countNodesWithSubClasses_.decrementAndGet();
        }
        return changed;
    }

    @Override
    public synchronized boolean removeDirectSuperNode(UN superNode) {
        boolean changed = this.directSuperNodes_.remove(superNode);
        LOGGER_.trace("{}: removed direct super-node {}", (Object)this, superNode);
        return changed;
    }

    public final int hashCode() {
        return this.hashCode_;
    }

    public static class Projection<T extends ElkEntity>
    extends NonBottomGenericTaxonomyNode<T, GenericTaxonomyNode.Projection<T>, Projection<T>>
    implements GenericTaxonomyNode.Projection<T> {
        public Projection(AbstractDistinctBottomTaxonomy<T, GenericTaxonomyNode.Projection<T>, Projection<T>> taxonomy, Iterable<? extends T> members, int size) {
            super(taxonomy, members, size);
        }
    }
}

